/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.keys;

import com.ibm.icu.util.VersionInfo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ICUVersionRecord
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private VersionInfo icuVersion;
    private VersionInfo ucolRuntimeVersion;
    private VersionInfo ucolBuilderVersion;
    private VersionInfo ucolTailoringsVersion;
    private static final transient int VERSION0 = 0;
    private static final transient int CURRENT_VERSION = 0;

    public VersionInfo getICUVersion() {
        return this.icuVersion;
    }

    public VersionInfo getUColRuntimeVersion() {
        return this.ucolRuntimeVersion;
    }

    public VersionInfo getUColBuilderVersion() {
        return this.ucolBuilderVersion;
    }

    public VersionInfo getUColTailoringsVersion() {
        return this.ucolTailoringsVersion;
    }

    public static ICUVersionRecord newInstance() {
        ICUVersionRecord r = new ICUVersionRecord(VersionInfo.ICU_VERSION, VersionInfo.UCOL_RUNTIME_VERSION, VersionInfo.UCOL_BUILDER_VERSION, VersionInfo.UCOL_TAILORINGS_VERSION);
        return r;
    }

    ICUVersionRecord(VersionInfo icuVersion, VersionInfo ucolRuntimeVesion, VersionInfo ucolBuilderVersion, VersionInfo ucolTailoringsVersion) {
        this.icuVersion = icuVersion;
        this.ucolRuntimeVersion = ucolRuntimeVesion;
        this.ucolBuilderVersion = ucolBuilderVersion;
        this.ucolTailoringsVersion = ucolTailoringsVersion;
    }

    public ICUVersionRecord() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new IOException("Unknown version: " + version);
            }
        }
        this.icuVersion = this.readVersionInfo(in);
        this.ucolRuntimeVersion = this.readVersionInfo(in);
        this.ucolBuilderVersion = this.readVersionInfo(in);
        this.ucolTailoringsVersion = this.readVersionInfo(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(0);
        this.writeVersionInfo(this.icuVersion, out);
        this.writeVersionInfo(this.ucolRuntimeVersion, out);
        this.writeVersionInfo(this.ucolBuilderVersion, out);
        this.writeVersionInfo(this.ucolTailoringsVersion, out);
    }

    private VersionInfo readVersionInfo(ObjectInput in) throws IOException {
        int major = in.readInt();
        int minor = in.readInt();
        int micro = in.readInt();
        int milli = in.readInt();
        return VersionInfo.getInstance(major, minor, milli, micro);
    }

    private void writeVersionInfo(VersionInfo v, ObjectOutput out) throws IOException {
        out.writeInt(v.getMajor());
        out.writeInt(v.getMinor());
        out.writeInt(v.getMicro());
        out.writeInt(v.getMilli());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{icuVersion=" + this.icuVersion);
        sb.append(",ucolRuntimeVersion=" + this.ucolRuntimeVersion);
        sb.append(",ucolBuilderVersion=" + this.ucolBuilderVersion);
        sb.append(",ucolTailoringsVersion=" + this.ucolTailoringsVersion);
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ICUVersionRecord)) {
            return false;
        }
        ICUVersionRecord r = (ICUVersionRecord)o;
        if (!this.icuVersion.equals(r.icuVersion)) {
            return false;
        }
        if (!this.ucolRuntimeVersion.equals(r.ucolRuntimeVersion)) {
            return false;
        }
        if (!this.ucolBuilderVersion.equals(r.ucolBuilderVersion)) {
            return false;
        }
        return this.ucolTailoringsVersion.equals(r.ucolTailoringsVersion);
    }

    public static void main(String[] args) {
        System.out.println(ICUVersionRecord.newInstance().toString());
        ICUVersionRecord a = ICUVersionRecord.newInstance();
        ICUVersionRecord b = ICUVersionRecord.newInstance();
        if (!a.equals(b)) {
            throw new AssertionError();
        }
        if (!b.equals(a)) {
            throw new AssertionError();
        }
    }
}

