/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.proc;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IParallelizableIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.LongAggregator;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.util.BytesUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class BatchRemove
extends AbstractKeyArrayIndexProcedure<Object>
implements IParallelizableIndexProcedure<Object> {
    private static final long serialVersionUID = -5332443478547654844L;
    private boolean assertFound;
    private ReturnWhatEnum returnWhat;

    public boolean getAssertFound() {
        return this.assertFound;
    }

    public boolean getReturnOldValues() {
        return this.returnWhat == ReturnWhatEnum.OldValues;
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    public BatchRemove() {
    }

    protected BatchRemove(IRabaCoder keySer, IRabaCoder valSer, int fromIndex, int toIndex, byte[][] keys, boolean assertFound, ReturnWhatEnum returnWhat) {
        super(keySer, valSer, fromIndex, toIndex, keys, null);
        this.assertFound = assertFound;
        this.returnWhat = returnWhat;
        if (returnWhat == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Object applyOnce(IIndex ndx, IRaba keys, IRaba vals) {
        int n = keys.size();
        boolean returnOldValues = this.getReturnOldValues();
        Object ret = returnOldValues ? new byte[n][] : (Object)null;
        boolean[] modified = this.returnWhat == ReturnWhatEnum.BitMask ? new boolean[n] : null;
        int mutationCount = 0;
        for (int i = 0; i < n; ++i) {
            byte[] key = keys.get(i);
            if (!returnOldValues && ndx.contains(key)) {
                ++mutationCount;
                if (modified != null) {
                    modified[i] = true;
                }
            }
            byte[] oldval = ndx.remove(key);
            if (this.assertFound && oldval == null) {
                throw new AssertionError((Object)("No entry: " + BytesUtil.toString(key)));
            }
            if (!returnOldValues) continue;
            ret[i] = oldval;
        }
        switch (this.returnWhat) {
            case MutationCount: {
                return (long)mutationCount;
            }
            case OldValues: {
                return new AbstractKeyArrayIndexProcedure.ResultBuffer(n, (byte[][])ret, ndx.getIndexMetadata().getTupleSerializer().getLeafValuesCoder());
            }
            case BitMask: {
                return new AbstractKeyArrayIndexProcedure.ResultBitBuffer(n, modified, mutationCount);
            }
        }
        throw new AssertionError();
    }

    @Override
    protected IResultHandler<Object, Object> newAggregator() {
        switch (this.returnWhat) {
            case MutationCount: {
                return new LongAggregator();
            }
            case OldValues: {
                return new AbstractKeyArrayIndexProcedure.ResultBufferHandler(this.getKeys().size(), this.getValuesCoder());
            }
            case BitMask: {
                return new AbstractKeyArrayIndexProcedure.ResultBitBufferHandler(this.getKeys().size());
            }
        }
        throw new AssertionError();
    }

    @Override
    protected void readMetadata(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readMetadata(in);
        this.assertFound = in.readBoolean();
        this.returnWhat = ReturnWhatEnum.valueOf(in.readByte());
    }

    @Override
    protected void writeMetadata(ObjectOutput out) throws IOException {
        super.writeMetadata(out);
        out.writeBoolean(this.assertFound);
        out.writeByte((byte)this.returnWhat.getValue());
    }

    public static class BatchRemoveConstructor
    extends AbstractKeyArrayIndexProcedureConstructor<BatchRemove> {
        public static final BatchRemoveConstructor RETURN_OLD_VALUES = new BatchRemoveConstructor(false, ReturnWhatEnum.OldValues);
        public static final BatchRemoveConstructor RETURN_MUTATION_COUNT = new BatchRemoveConstructor(false, ReturnWhatEnum.MutationCount);
        public static final BatchRemoveConstructor RETURN_BIT_MASK = new BatchRemoveConstructor(false, ReturnWhatEnum.BitMask);
        public static final BatchRemoveConstructor ASSERT_FOUND_RETURN_NO_VALUES = new BatchRemoveConstructor(true, ReturnWhatEnum.BitMask);
        private final boolean assertFound;
        private final ReturnWhatEnum returnWhat;

        @Override
        public final boolean sendValues() {
            return false;
        }

        private BatchRemoveConstructor(boolean assertFound, ReturnWhatEnum returnWhat) {
            this.assertFound = assertFound;
            this.returnWhat = returnWhat;
        }

        @Override
        public BatchRemove newInstance(IRabaCoder keySer, IRabaCoder valSer, int fromIndex, int toIndex, byte[][] keys, byte[][] vals) {
            if (vals != null) {
                throw new IllegalArgumentException("values must be null");
            }
            return new BatchRemove(keySer, valSer, fromIndex, toIndex, keys, this.assertFound, this.returnWhat);
        }
    }

    private static enum ReturnWhatEnum {
        MutationCount(0),
        OldValues(1),
        BitMask(2);

        private final int w;

        private ReturnWhatEnum(int w) {
            this.w = w;
        }

        public int getValue() {
            return this.w;
        }

        public static ReturnWhatEnum valueOf(int w) {
            switch (w) {
                case 0: {
                    return MutationCount;
                }
                case 1: {
                    return OldValues;
                }
                case 2: {
                    return BitMask;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

