/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.raba;

import com.bigdata.btree.raba.AbstractKeyBuffer;
import com.bigdata.btree.raba.AbstractRaba;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.util.BytesUtil;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;

public class MutableKeyBuffer
extends AbstractKeyBuffer {
    public int nkeys;
    public final byte[][] keys;
    private static final transient byte[] EMPTY_PREFIX = new byte[0];

    public MutableKeyBuffer(int capacity) {
        this.nkeys = 0;
        this.keys = new byte[capacity][];
    }

    public MutableKeyBuffer(int nkeys, byte[][] keys) {
        assert (nkeys >= 0);
        assert (keys != null);
        assert (keys.length >= nkeys);
        this.nkeys = nkeys;
        this.keys = keys;
    }

    public MutableKeyBuffer(MutableKeyBuffer src) {
        assert (src != null);
        this.nkeys = src.nkeys;
        this.keys = new byte[src.keys.length][];
        for (int i = 0; i < this.nkeys; ++i) {
            this.keys[i] = src.keys[i];
        }
    }

    public MutableKeyBuffer(int capacity, IRaba src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (capacity < src.capacity()) {
            throw new IllegalArgumentException();
        }
        this.nkeys = src.size();
        assert (this.nkeys >= 0);
        this.keys = new byte[capacity][];
        int i = 0;
        for (byte[] a : src) {
            this.keys[i++] = a;
        }
    }

    @Override
    public final byte[] get(int index) {
        return this.keys[index];
    }

    @Override
    public final int length(int index) {
        assert (index >= 0 && index < this.nkeys);
        byte[] tmp = this.keys[index];
        if (tmp == null) {
            throw new NullPointerException();
        }
        return tmp.length;
    }

    @Override
    public final int copy(int index, OutputStream out) {
        assert (index >= 0 && index < this.nkeys) : "index=" + index + " not in [0:" + this.nkeys + "]";
        byte[] tmp = this.keys[index];
        try {
            out.write(tmp, 0, tmp.length);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return tmp.length;
    }

    @Override
    public final boolean isNull(int index) {
        assert (index >= 0 && index < this.keys.length);
        return index >= this.nkeys;
    }

    @Override
    public final boolean isEmpty() {
        return this.nkeys == 0;
    }

    @Override
    public final int size() {
        return this.nkeys;
    }

    @Override
    public final int capacity() {
        return this.keys.length;
    }

    @Override
    public final boolean isFull() {
        return this.nkeys == this.keys.length;
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public final boolean isKeys() {
        return true;
    }

    @Override
    public final void set(int index, byte[] key) {
        assert (index >= 0 && index < this.nkeys);
        this.keys[index] = key;
    }

    @Override
    public final int add(byte[] key) {
        assert (this.nkeys < this.keys.length);
        this.keys[this.nkeys++] = key;
        return this.nkeys;
    }

    @Override
    public final int add(byte[] key, int off, int len) {
        assert (this.nkeys < this.keys.length);
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = key[off + i];
        }
        this.keys[this.nkeys++] = b;
        return this.nkeys;
    }

    @Override
    public int add(DataInput in, int len) throws IOException {
        assert (this.nkeys < this.keys.length);
        byte[] b = new byte[len];
        in.readFully(b, 0, len);
        this.keys[this.nkeys++] = b;
        return this.nkeys;
    }

    public final int insert(int index, byte[] key) {
        assert (index >= 0 && index <= this.nkeys);
        if (index == this.nkeys) {
            return this.add(key);
        }
        int count = this.nkeys - index;
        assert (count >= 1);
        System.arraycopy(this.keys, index, this.keys, index + 1, 1);
        this.keys[index] = key;
        return ++this.nkeys;
    }

    public final int remove(int index) {
        assert (index >= 0 && index < this.nkeys);
        int length = this.nkeys - index - 1;
        if (length > 0) {
            System.arraycopy(this.keys, index + 1, this.keys, index, length);
        }
        this.keys[--this.nkeys] = null;
        return this.nkeys;
    }

    public String toString() {
        return AbstractRaba.toString(this);
    }

    @Override
    public final int search(byte[] searchKey) {
        if (searchKey == null) {
            throw new IllegalArgumentException("searchKey is null");
        }
        if (this.nkeys == 0) {
            return -1;
        }
        int prefixLength = this.getPrefixLength();
        int insertPosition = this._prefixMatchLength(prefixLength, searchKey);
        if (insertPosition < 0) {
            return insertPosition;
        }
        if (this.nkeys < 16) {
            return this._linearSearch(prefixLength, searchKey);
        }
        return this._binarySearch(prefixLength, searchKey);
    }

    @Override
    protected final int _prefixMatchLength(int prefixLength, byte[] searchKey) {
        int searchKeyLen = searchKey.length;
        int compareLen = searchKeyLen <= prefixLength ? searchKeyLen : prefixLength;
        int ret = BytesUtil.compareBytesWithLenAndOffset(0, compareLen, searchKey, 0, compareLen, this.keys[0]);
        if (ret < 0) {
            return -1;
        }
        if (ret > 0) {
            return -this.nkeys - 1;
        }
        if (searchKeyLen < prefixLength) {
            return -1;
        }
        return 0;
    }

    @Override
    protected final int _linearSearch(int searchKeyOffset, byte[] searchKey) {
        int searchKeyLen = searchKey.length - searchKeyOffset;
        assert (searchKeyLen >= 0);
        for (int i = 0; i < this.nkeys; ++i) {
            byte[] key = this.keys[i];
            int keyLen = key.length - searchKeyOffset;
            assert (keyLen >= 0);
            int ret = BytesUtil.compareBytesWithLenAndOffset(searchKeyOffset, keyLen, key, searchKeyOffset, searchKeyLen, searchKey);
            if (ret == 0) {
                return i;
            }
            if (ret <= 0) continue;
            return -(i + 1);
        }
        return -(this.nkeys + 1);
    }

    @Override
    protected final int _binarySearch(int searchKeyOffset, byte[] searchKey) {
        int searchKeyLen = searchKey.length - searchKeyOffset;
        assert (searchKeyLen >= 0);
        int low = 0;
        int high = this.nkeys - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            byte[] key = this.keys[mid];
            int keyLen = key.length - searchKeyOffset;
            assert (keyLen >= 0);
            int ret = BytesUtil.compareBytesWithLenAndOffset(searchKeyOffset, keyLen, key, searchKeyOffset, searchKeyLen, searchKey);
            if (ret < 0) {
                low = mid + 1;
                continue;
            }
            if (ret > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public final void assertKeysMonotonic() {
        int i;
        for (i = 1; i < this.nkeys; ++i) {
            if (BytesUtil.compareBytes(this.keys[i], this.keys[i - 1]) <= 0) {
                throw new AssertionError((Object)("Keys out of order at index=" + i + ", keys=" + this.toString()));
            }
        }
        for (i = this.nkeys; i < this.keys.length; ++i) {
            if (this.keys[i] != null) {
                throw new AssertionError((Object)("Expecting null at index=" + i));
            }
        }
    }

    @Override
    public int getPrefixLength() {
        if (this.nkeys == 0) {
            return 0;
        }
        if (this.nkeys == 1) {
            return this.keys[0].length;
        }
        return BytesUtil.getPrefixLength(this.keys[0], this.keys[this.nkeys - 1]);
    }

    @Override
    public byte[] getPrefix() {
        if (this.nkeys == 0) {
            return EMPTY_PREFIX;
        }
        if (this.nkeys == 1) {
            return this.keys[0];
        }
        return BytesUtil.getPrefix(this.keys[0], this.keys[this.nkeys - 1]);
    }
}

