/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.raba.codec;

import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.AbstractCodedRaba;
import com.bigdata.btree.raba.codec.ICodedRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.util.BytesUtil;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.compression.CanonicalFast64CodeWordDecoder;
import it.unimi.dsi.compression.Decoder;
import it.unimi.dsi.compression.HuffmanCodec;
import it.unimi.dsi.compression.PrefixCoder;
import it.unimi.dsi.fastutil.bytes.Byte2IntOpenHashMap;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class CanonicalHuffmanRabaCoder
implements IRabaCoder,
Externalizable {
    protected static final Logger log = Logger.getLogger(CanonicalHuffmanRabaCoder.class);
    private static final transient boolean debug = log.isDebugEnabled();
    private static final long serialVersionUID = -9207148905767204181L;
    protected static final transient byte VERSION0 = 0;
    public static final transient CanonicalHuffmanRabaCoder INSTANCE = new CanonicalHuffmanRabaCoder();

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public final boolean isKeyCoder() {
        return true;
    }

    @Override
    public final boolean isValueCoder() {
        return true;
    }

    protected void writeSymbolTable(Symbol2Byte symbol2byte, OutputBitStream obs) throws IOException {
        assert (symbol2byte != null);
        assert (obs != null);
        int nsymbols = symbol2byte.getSymbolCount();
        assert (nsymbols <= 256);
        for (int i = 0; i < nsymbols; ++i) {
            obs.writeInt(symbol2byte.symbol2byte(i), 8);
        }
    }

    protected static void writeDecoderInputs(HuffmanCodec.DecoderInputs decoderInputs, OutputBitStream obs, StringBuilder sb) throws IOException {
        if (decoderInputs == null) {
            throw new IllegalArgumentException();
        }
        if (obs == null) {
            throw new IllegalArgumentException();
        }
        int[] length = decoderInputs.getLengths();
        int[] symbol = decoderInputs.getSymbols();
        if (length == null) {
            throw new IllegalArgumentException();
        }
        if (symbol == null) {
            throw new IllegalArgumentException();
        }
        if (length.length != symbol.length) {
            throw new IllegalArgumentException();
        }
        int nsymbols = length.length;
        int min = length[0];
        int max = length[nsymbols - 1];
        int nsizes = max - min + 1;
        assert (nsizes >= 0);
        if (sb != null) {
            sb.append("min=" + min + ", max=" + max + "\n");
        }
        obs.writeNibble(min);
        obs.writeNibble(max);
        int lastSize = min;
        int sizeCount = 0;
        int nextSymbol = 0;
        for (int i = 0; i < nsymbols; ++i) {
            int thisSize = length[i];
            assert (thisSize >= lastSize);
            if (thisSize == lastSize) {
                ++sizeCount;
                continue;
            }
            while (thisSize >= lastSize + 1) {
                assert (thisSize >= lastSize + 1);
                assert (sizeCount >= 0);
                if (sb != null) {
                    sb.append("codeSize=" + lastSize + ", sizeCount=" + sizeCount + ", symbols=[");
                }
                obs.writeNibble(sizeCount);
                for (int j = nextSymbol; j < i; ++j) {
                    if (sb != null) {
                        sb.append(" " + symbol[j]);
                    }
                    obs.writeNibble(symbol[j]);
                }
                if (sb != null) {
                    sb.append("]\n");
                }
                sizeCount = thisSize == lastSize + 1 ? 1 : 0;
                nextSymbol = i;
                ++lastSize;
            }
        }
        if (sizeCount > 0) {
            if (sb != null) {
                sb.append("codeSize=" + lastSize + ", sizeCount=" + sizeCount + ", symbols=[");
            }
            obs.writeNibble(sizeCount);
            for (int j = nextSymbol; j < nsymbols; ++j) {
                if (sb != null) {
                    sb.append(" " + symbol[j]);
                }
                obs.writeNibble(symbol[j]);
            }
            if (sb != null) {
                sb.append(" ]\n");
            }
        }
        assert (lastSize == max);
        obs.write(decoderInputs.getShortestCodeWord().iterator());
        if (sb != null) {
            sb.append("shortestCodeWord=" + decoderInputs.getShortestCodeWord() + "\n");
        }
    }

    protected static HuffmanCodec.DecoderInputs readDecoderInputs(int nsymbols, InputBitStream ibs, StringBuilder sb) throws IOException {
        int min = ibs.readNibble();
        int max = ibs.readNibble();
        if (sb != null) {
            sb.append("min=" + min + ", max=" + max + "\n");
        }
        int[] length = new int[nsymbols];
        int[] symbol = new int[nsymbols];
        int lastSymbol = 0;
        for (int codeSize = min; codeSize <= max; ++codeSize) {
            int sizeCount = ibs.readNibble();
            if (sb != null) {
                sb.append("codeSize=" + codeSize + ", sizeCount=" + sizeCount + ", symbols=[");
            }
            int i = 0;
            while (i < sizeCount) {
                int tmp = ibs.readNibble();
                if (sb != null) {
                    sb.append(" " + tmp);
                }
                length[lastSymbol] = codeSize;
                symbol[lastSymbol] = tmp;
                ++i;
                ++lastSymbol;
            }
            if (sb == null) continue;
            sb.append(" ]\n");
        }
        int shortestCodeWordLength = length[0];
        LongArrayBitVector shortestCodeWord = LongArrayBitVector.getInstance().length(shortestCodeWordLength);
        for (int i = shortestCodeWordLength - 1; i >= 0; --i) {
            shortestCodeWord.set((long)i, ibs.readBit());
        }
        if (sb != null) {
            sb.append("shortestCodeWord=" + shortestCodeWord + "\n");
        }
        return new HuffmanCodec.DecoderInputs(shortestCodeWord, length, symbol);
    }

    protected long getSumCodedValueBitLengths(BitVector[] codeWords, IRaba raba, Byte2Symbol byte2symbol) {
        int nvalues = raba.size();
        long sumCodedValueBitLengths = 0L;
        for (int i = 0; i < nvalues; ++i) {
            byte[] a = raba.get(i);
            long codeLength = 0L;
            if (a != null) {
                for (byte b : a) {
                    codeLength += codeWords[byte2symbol.byte2symbol(b)].length();
                }
            }
            sumCodedValueBitLengths += codeLength;
        }
        return sumCodedValueBitLengths;
    }

    protected long writeCodedValues(PrefixCoder coder, IRaba raba, Byte2Symbol byte2symbol, long[] codedValueOffset, OutputBitStream obs) throws IOException {
        int nvalues = raba.size();
        if (codedValueOffset != null && codedValueOffset.length != nvalues + 1) {
            throw new IllegalArgumentException();
        }
        long bitsWritten = 0L;
        for (int i = 0; i < nvalues; ++i) {
            byte[] a;
            if (codedValueOffset != null) {
                codedValueOffset[i] = bitsWritten;
            }
            if ((a = raba.get(i)) == null) continue;
            for (byte b : a) {
                int symbol = byte2symbol.byte2symbol(b);
                if (symbol == -1) {
                    throw new UnsupportedOperationException("Can not code value: " + b);
                }
                bitsWritten += (long)coder.encode(symbol, obs);
            }
        }
        if (codedValueOffset != null) {
            codedValueOffset[nvalues] = bitsWritten;
        }
        if (log.isDebugEnabled()) {
            log.debug("codedValueOffset[]=" + Arrays.toString(codedValueOffset));
        }
        return bitsWritten;
    }

    @Override
    public AbstractFixedByteArrayBuffer encode(IRaba raba, DataOutputBuffer buf) {
        return this.encodeLive(raba, buf).data();
    }

    @Override
    public ICodedRaba encodeLive(IRaba raba, DataOutputBuffer buf) {
        RabaCodingSetup setup = new RabaCodingSetup(raba);
        StringBuilder sb = debug ? new StringBuilder("\n") : null;
        int size = raba.size();
        int nsymbols = ((AbstractCodingSetup)setup).getSymbolCount();
        long sumCodedValueBitLengths = nsymbols == 0 ? 0L : this.getSumCodedValueBitLengths(((AbstractCodingSetup)setup).codec().codeWords(), raba, setup);
        int codedValueOffsetBits = nsymbols == 0 ? 0 : Fast.mostSignificantBit(sumCodedValueBitLengths) + 1;
        int initialCapacity = (int)(512L + sumCodedValueBitLengths + (long)((size + 1) * codedValueOffsetBits));
        buf.ensureCapacity(initialCapacity);
        int O_origin = buf.pos();
        if (debug) {
            sb.append("O_origin=" + O_origin + "\n");
        }
        try {
            long decoderInputsBitLength;
            boolean version = false;
            OutputBitStream obs = buf.getOutputBitStream();
            obs.writeInt(0, 8);
            if (debug) {
                sb.append("version=0\n");
            }
            obs.writeBit(raba.isKeys());
            boolean isSymbolTable = ((AbstractCodingSetup)setup).getSymbolCount() != 256;
            obs.writeBit(isSymbolTable);
            boolean isOffsetArray = true;
            obs.writeBit(true);
            boolean isByteAlignedOffsets = false;
            obs.writeBit(false);
            obs.writeInt(0, 4);
            if (debug) {
                sb.append("isKeys=" + raba.isKeys() + "\n");
                sb.append("isSymbolTable=" + isSymbolTable + "\n");
                sb.append("isOffsetArray=true\n");
                sb.append("isByteAlignedOffsets=false\n");
            }
            obs.writeInt(size, 31);
            if (debug) {
                sb.append("size=" + size + "\n");
            }
            obs.writeInt(nsymbols, 9);
            assert (obs.writtenBits() == 56L);
            if (debug) {
                sb.append("nsymbols=" + nsymbols + "\n");
            }
            if (isSymbolTable) {
                this.writeSymbolTable(setup, obs);
            }
            assert (obs.writtenBits() % 8L == 0L);
            assert (obs.writtenBits() == 56L + (long)(isSymbolTable ? nsymbols * 8 : 0));
            long O_codedValueOffsetBits = obs.writtenBits();
            obs.writeInt(codedValueOffsetBits, 8);
            if (debug) {
                sb.append("O_codedValueOffsetBits=" + O_codedValueOffsetBits + "\n");
                sb.append("codedValueOffsetBits=" + codedValueOffsetBits + "\n");
            }
            if (codedValueOffsetBits != 0) {
                obs.writeLong(sumCodedValueBitLengths, 32);
                if (debug) {
                    sb.append("sumCodedValueBitLengths=" + sumCodedValueBitLengths + "\n");
                }
            }
            long O_nulls = obs.writtenBits();
            assert (O_nulls == O_codedValueOffsetBits + 8L + (long)(codedValueOffsetBits == 0 ? 0 : 32));
            if (!raba.isKeys()) {
                if (debug) {
                    sb.append("O_nulls=" + O_nulls + "\n");
                }
                for (int i = 0; i < size; ++i) {
                    boolean isNull = raba.isNull(i);
                    obs.writeBit(isNull);
                    if (!debug) continue;
                    sb.append("null[" + i + "]=" + isNull + "\n");
                }
            }
            if (nsymbols == 0) {
                decoderInputsBitLength = 0L;
            } else {
                long O_decoderInputs = obs.writtenBits();
                if (debug) {
                    sb.append("O_decoderInputs=" + O_decoderInputs + "\n");
                }
                CanonicalHuffmanRabaCoder.writeDecoderInputs(((AbstractCodingSetup)setup).decoderInputs(), obs, sb);
                long O_codedValues = obs.writtenBits();
                decoderInputsBitLength = O_codedValues - O_decoderInputs;
                if (debug) {
                    sb.append("O_codedValues=" + O_codedValues + "\n");
                }
                long[] codedValueOffset = codedValueOffsetBits == 0 ? null : new long[size + 1];
                long sumCodedValueBitLengths2 = this.writeCodedValues(((AbstractCodingSetup)setup).codec().coder(), raba, setup, codedValueOffset, obs);
                assert (sumCodedValueBitLengths == sumCodedValueBitLengths2) : "sumCodedValueBitLengths=" + sumCodedValueBitLengths + " != sumCodedValueBitLengths2=" + sumCodedValueBitLengths2;
                if (codedValueOffset != null) assert (codedValueOffset[size] == sumCodedValueBitLengths);
                if (codedValueOffsetBits != 0) {
                    long O_codedValueOffsets = obs.writtenBits();
                    assert (O_codedValueOffsets == O_codedValues + sumCodedValueBitLengths);
                    if (debug) {
                        sb.append("O_codedValueOffsets=" + O_codedValueOffsets + "\n");
                    }
                    for (int i = 0; i < codedValueOffset.length; ++i) {
                        long offset = codedValueOffset[i];
                        obs.writeLong(offset, codedValueOffsetBits);
                        if (!debug) continue;
                        sb.append("codedValueOffsets[" + i + "]=" + offset + "\n");
                    }
                } else {
                    long O_codedValueOffsets = 0L;
                }
            }
            obs.flush();
            if (debug) {
                sb.append("bytesWritten=" + (buf.pos() - O_origin) + "\n");
                log.debug(sb.toString());
            }
            AbstractFixedByteArrayBuffer slice = buf.slice(O_origin, buf.pos() - O_origin);
            if (nsymbols == 0) {
                return new CodedRabaImpl(slice, null, 0L);
            }
            return new CodedRabaImpl(slice, ((AbstractCodingSetup)setup).codec().decoder(), decoderInputsBitLength);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ICodedRaba decode(AbstractFixedByteArrayBuffer data) {
        return new CodedRabaImpl(data);
    }

    @Override
    public boolean isDuplicateKeys() {
        return false;
    }

    public static class CodedRabaImpl
    extends AbstractCodedRaba {
        private static final int BYTE_O_symbols = 7;
        private static final long O_symbols = 56L;
        private final int size;
        private final boolean isKeys;
        private final boolean isSymbolTable;
        private final AbstractFixedByteArrayBuffer data;
        private final int aoff;
        private final Decoder decoder;
        private final int nsymbols;
        private final long O_nulls;
        private final long O_codedValues;
        private final int codedValueOffsetBits;
        private final long O_codedValueOffsets;

        public CodedRabaImpl(AbstractFixedByteArrayBuffer data) {
            this(data, null, 0L);
        }

        public CodedRabaImpl(AbstractFixedByteArrayBuffer data, Decoder decoder, long decoderInputsBitLength) {
            if (data == null) {
                throw new IllegalArgumentException();
            }
            if (decoder != null && decoderInputsBitLength == 0L) {
                throw new IllegalArgumentException();
            }
            this.data = data;
            this.aoff = data.off();
            StringBuilder sb = debug ? new StringBuilder("\n") : null;
            InputBitStream ibs = data.getInputBitStream();
            try {
                int version = ibs.readInt(8);
                if (version != 0) {
                    throw new IOException("Unknown version: " + version);
                }
                if (debug) {
                    sb.append("version=" + version + "\n");
                }
                this.isKeys = ibs.readBit() != 0;
                this.isSymbolTable = ibs.readBit() != 0;
                boolean isOffsetArray = ibs.readBit() != 0;
                boolean isByteAlignedOffsets = ibs.readBit() != 0;
                ibs.readInt(4);
                if (debug) {
                    sb.append("isKeys=" + this.isKeys + "\n");
                    sb.append("isSymbolTable=" + this.isSymbolTable + "\n");
                    sb.append("isOffsetArray=" + isOffsetArray + "\n");
                    sb.append("isByteAlignedOffsets=" + isByteAlignedOffsets + "\n");
                }
                this.size = ibs.readInt(31);
                if (debug) {
                    sb.append("size=" + this.size + "\n");
                }
                if (this.size < 0) {
                    throw new IOException();
                }
                this.nsymbols = ibs.readInt(9);
                if (debug) {
                    sb.append("nsymbols=" + this.nsymbols + "\n");
                }
                assert (ibs.readBits() == 56L);
                if (this.isSymbolTable) {
                    ibs.skip((long)this.nsymbols * 8L);
                    assert (ibs.readBits() == 56L + (long)this.nsymbols * 8L);
                }
                long O_codedValueOffsetBits = ibs.readBits();
                this.codedValueOffsetBits = ibs.readInt(8);
                if (debug) {
                    sb.append("O_codedValueOffsetBits=" + O_codedValueOffsetBits + "\n");
                    sb.append("codedValueOffsetBits=" + this.codedValueOffsetBits + "\n");
                }
                long sumCodedValueBitLengths = this.codedValueOffsetBits != 0 ? (long)ibs.readInt(32) : 0L;
                if (debug) {
                    sb.append("sumCodedValueBitLengths=" + sumCodedValueBitLengths + "\n");
                }
                this.O_nulls = ibs.readBits();
                assert (this.O_nulls == O_codedValueOffsetBits + 8L + (long)(this.codedValueOffsetBits == 0 ? 0 : 32));
                if (!this.isKeys) {
                    if (debug) {
                        sb.append("O_nulls=" + this.O_nulls + "\n");
                        for (int i = 0; i < this.size; ++i) {
                            boolean isNull = ibs.readBit() != 0;
                            sb.append("null[" + i + "]=" + isNull + "\n");
                            assert (isNull == data.getBit(this.O_nulls + (long)i)) : "index=" + i;
                        }
                    } else {
                        ibs.skip((long)this.size);
                    }
                }
                if (this.nsymbols == 0) {
                    this.decoder = null;
                    this.O_codedValues = -1L;
                    this.O_codedValueOffsets = -1L;
                    return;
                }
                long O_decoderInputs = ibs.readBits();
                if (debug) {
                    sb.append("O_decoderInputs=" + O_decoderInputs + "\n");
                }
                assert (O_decoderInputs == this.O_nulls + (long)(this.isKeys ? 0 : this.size));
                HuffmanCodec.DecoderInputs decoderInputs = CanonicalHuffmanRabaCoder.readDecoderInputs(this.nsymbols, ibs, sb);
                this.decoder = decoder == null ? new CanonicalFast64CodeWordDecoder(decoderInputs.getLengths(), decoderInputs.getSymbols()) : decoder;
                this.O_codedValues = ibs.readBits();
                if (debug) {
                    sb.append("O_codedValues=" + this.O_codedValues + "\n");
                }
                ibs.skip(sumCodedValueBitLengths);
                long l = this.O_codedValueOffsets = this.codedValueOffsetBits == 0 ? 0L : this.O_codedValues + sumCodedValueBitLengths;
                if (debug) {
                    sb.append("O_codedValueOffsets=" + this.O_codedValueOffsets + "\n");
                    if (this.O_codedValueOffsets != 0L) {
                        ibs.position(this.O_codedValueOffsets);
                        for (int i = 0; i <= this.size; ++i) {
                            sb.append("codedValueOffsets[" + i + "]=" + ibs.readInt(this.codedValueOffsetBits) + "\n");
                        }
                    }
                }
                if (debug) {
                    log.debug(sb.toString());
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        public final int capacity() {
            return this.size;
        }

        @Override
        public final boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public final boolean isFull() {
            return true;
        }

        @Override
        public final boolean isKeys() {
            return this.isKeys;
        }

        @Override
        public AbstractFixedByteArrayBuffer data() {
            return this.data;
        }

        @Override
        public boolean isNull(int index) {
            if (index < 0 || index >= this.size) {
                throw new IllegalArgumentException();
            }
            if (this.isKeys) {
                return false;
            }
            return this.data.getBit(this.O_nulls + (long)index);
        }

        @Override
        public int length(int index) {
            boolean isNull;
            if (index < 0 || index >= this.size) {
                throw new IllegalArgumentException();
            }
            if (!this.isKeys && (isNull = this.data.getBit(this.O_nulls + (long)index))) {
                throw new NullPointerException();
            }
            if (this.nsymbols == 0) {
                return 0;
            }
            InputBitStream ibs = this.data.getInputBitStream();
            try {
                ibs.position(this.O_codedValueOffsets + (long)index * (long)this.codedValueOffsetBits);
                long O_from = ibs.readLong(this.codedValueOffsetBits);
                ibs.position(this.O_codedValueOffsets + ((long)index + 1L) * (long)this.codedValueOffsetBits);
                long O_to = ibs.readLong(this.codedValueOffsetBits);
                long codeLength = O_to - O_from;
                ibs.position(O_from + this.O_codedValues);
                ibs.readBits(0L);
                int nsymbols = 0;
                while (ibs.readBits() < codeLength) {
                    this.decoder.decode(ibs);
                    ++nsymbols;
                }
                return nsymbols;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public byte[] get(int index) {
            boolean isNull;
            if (index < 0 || index >= this.size) {
                throw new IllegalArgumentException();
            }
            if (!this.isKeys && (isNull = this.data.getBit(this.O_nulls + (long)index))) {
                return null;
            }
            if (this.nsymbols == 0) {
                return BytesUtil.EMPTY;
            }
            InputBitStream ibs = this.data.getInputBitStream();
            try {
                ibs.position(this.O_codedValueOffsets + (long)index * (long)this.codedValueOffsetBits);
                long O_from = ibs.readLong(this.codedValueOffsetBits);
                ibs.position(this.O_codedValueOffsets + ((long)index + 1L) * (long)this.codedValueOffsetBits);
                long O_to = ibs.readLong(this.codedValueOffsetBits);
                long codeLength = O_to - O_from;
                assert (codeLength >= 0L) : "index=" + index + ", codeLength=" + codeLength;
                ibs.position(O_from + this.O_codedValues);
                ibs.readBits(0L);
                int nsymbols = 0;
                while (ibs.readBits() < codeLength) {
                    this.decoder.decode(ibs);
                    ++nsymbols;
                }
                ibs.position(O_from + this.O_codedValues);
                return this.getFrom(ibs, nsymbols);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        private byte[] getFrom(InputBitStream ibs, int nsymbols) throws IOException {
            byte[] a = new byte[nsymbols];
            if (!this.isSymbolTable) {
                for (int i = 0; i < nsymbols; ++i) {
                    int symbol = this.decoder.decode(ibs);
                    a[i] = KeyBuilder.encodeByte(symbol);
                }
                return a;
            }
            byte[] array = this.data.array();
            int aoff = this.aoff + 7;
            for (int i = 0; i < nsymbols; ++i) {
                int symbol = this.decoder.decode(ibs);
                a[i] = array[aoff + symbol];
            }
            return a;
        }

        @Override
        public int copy(int index, OutputStream os) {
            boolean isNull;
            if (index < 0 || index >= this.size) {
                throw new IllegalArgumentException();
            }
            if (!this.isKeys && (isNull = this.data.getBit(this.O_nulls + (long)index))) {
                throw new NullPointerException();
            }
            if (this.nsymbols == 0) {
                return 0;
            }
            InputBitStream ibs = this.data.getInputBitStream();
            try {
                ibs.position(this.O_codedValueOffsets + (long)index * (long)this.codedValueOffsetBits);
                long O_from = ibs.readLong(this.codedValueOffsetBits);
                ibs.position(this.O_codedValueOffsets + ((long)index + 1L) * (long)this.codedValueOffsetBits);
                long O_to = ibs.readLong(this.codedValueOffsetBits);
                long codeLength = O_to - O_from;
                assert (codeLength >= 0L) : "codeLength=" + codeLength;
                ibs.position(O_from + this.O_codedValues);
                return this.copyFrom(ibs, codeLength, os);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        private int copyFrom(InputBitStream ibs, long codeLength, OutputStream os) throws IOException {
            int nsymbols = 0;
            ibs.readBits(0L);
            if (!this.isSymbolTable) {
                while (ibs.readBits() < codeLength) {
                    int symbol = this.decoder.decode(ibs);
                    byte b = KeyBuilder.encodeByte(symbol);
                    os.write(b);
                    ++nsymbols;
                }
                return nsymbols;
            }
            byte[] array = this.data.array();
            int aoff = this.aoff + 7;
            while (ibs.readBits() < codeLength) {
                int symbol = this.decoder.decode(ibs);
                byte b = array[aoff + symbol];
                os.write(b);
                ++nsymbols;
            }
            return nsymbols;
        }

        @Override
        public Iterator<byte[]> iterator() {
            final ByteArrayBuffer tmp = new ByteArrayBuffer(128);
            return new Iterator<byte[]>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < CodedRabaImpl.this.size();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public byte[] next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        boolean isNull;
                        if (!CodedRabaImpl.this.isKeys && (isNull = CodedRabaImpl.this.data.getBit(CodedRabaImpl.this.O_nulls + (long)this.i))) {
                            byte[] byArray = null;
                            return byArray;
                        }
                        tmp.reset();
                        CodedRabaImpl.this.copy(this.i, tmp);
                        byte[] byArray = tmp.toByteArray();
                        return byArray;
                    }
                    finally {
                        ++this.i;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int search(byte[] probe) {
            if (probe == null) {
                throw new IllegalArgumentException();
            }
            if (!this.isKeys()) {
                throw new UnsupportedOperationException();
            }
            InputBitStream ibs = this.data.getInputBitStream();
            try {
                return this.binarySearch(ibs, probe);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        private final int binarySearch(InputBitStream ibs, byte[] key) throws IOException {
            byte[] array = this.data.array();
            int nmem = this.size;
            boolean base = false;
            int low = 0;
            int high = nmem - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                int offset = 0 + mid;
                int tmp = this.compare(ibs, offset, key, array);
                if (tmp > 0) {
                    low = mid + 1;
                    continue;
                }
                if (tmp < 0) {
                    high = mid - 1;
                    continue;
                }
                return offset;
            }
            int offset = 0 + low;
            return -(offset + 1);
        }

        private int compare(InputBitStream ibs, int index, byte[] key, byte[] array) throws IOException {
            int nsymbols;
            if (this.nsymbols == 0) {
                return BytesUtil.compareBytes(key, BytesUtil.EMPTY);
            }
            ibs.position(this.O_codedValueOffsets + (long)index * (long)this.codedValueOffsetBits);
            long O_from = ibs.readLong(this.codedValueOffsetBits);
            ibs.position(this.O_codedValueOffsets + ((long)index + 1L) * (long)this.codedValueOffsetBits);
            long O_to = ibs.readLong(this.codedValueOffsetBits);
            long codeLength = O_to - O_from;
            assert (codeLength >= 0L);
            ibs.position(O_from + this.O_codedValues);
            ibs.readBits(0L);
            int aoff = this.aoff + 7;
            for (nsymbols = 0; ibs.readBits() < codeLength && nsymbols < key.length; ++nsymbols) {
                assert (this.decoder != null);
                int symbol = this.decoder.decode(ibs);
                byte a = key[nsymbols];
                byte b = !this.isSymbolTable ? KeyBuilder.encodeByte(symbol) : array[aoff + symbol];
                int ret = (a & 0xFF) - (b & 0xFF);
                if (ret == 0) continue;
                return ret;
            }
            if (nsymbols == key.length && ibs.readBits() < codeLength) {
                return -1;
            }
            return key.length - nsymbols;
        }
    }

    protected static class RabaCodingSetup
    extends AbstractCodingSetup {
        final int nsymbols;
        private final int[] packedFrequency;
        private final HuffmanCodec.DecoderInputs decoderInputs;
        private final HuffmanCodec codec;
        private final Byte2IntOpenHashMap byte2symbol;
        private final byte[] symbol2byte;

        @Override
        public HuffmanCodec.DecoderInputs decoderInputs() {
            return this.decoderInputs;
        }

        @Override
        public HuffmanCodec codec() {
            return this.codec;
        }

        @Override
        public final int getSymbolCount() {
            return this.nsymbols;
        }

        @Override
        public final int byte2symbol(byte b) {
            return this.byte2symbol.get(b);
        }

        @Override
        public final byte symbol2byte(int symbol) {
            return this.symbol2byte[symbol];
        }

        public RabaCodingSetup(IRaba raba) {
            int i;
            if (raba == null) {
                throw new IllegalArgumentException();
            }
            int size = raba.size();
            int[] frequency = new int[256];
            int nsymbols = 0;
            byte lastByte = 0;
            for (i = 0; i < size; ++i) {
                byte[] a = raba.get(i);
                if (a == null) continue;
                for (byte b : a) {
                    int n = b - -128;
                    int n2 = frequency[n];
                    frequency[n] = n2 + 1;
                    if (n2 != 0) continue;
                    lastByte = b;
                    ++nsymbols;
                }
            }
            if (nsymbols == 1) {
                int fakeByteIndex = lastByte == 0 ? 1 : 0;
                frequency[fakeByteIndex] = 1;
                ++nsymbols;
            }
            this.nsymbols = nsymbols;
            this.packedFrequency = new int[nsymbols];
            this.symbol2byte = new byte[nsymbols];
            this.byte2symbol = new Byte2IntOpenHashMap(nsymbols);
            this.byte2symbol.defaultReturnValue(-1);
            i = frequency.length;
            int k = nsymbols;
            while (i-- != 0) {
                byte b;
                if (frequency[i] == 0) continue;
                this.packedFrequency[--k] = frequency[i];
                this.symbol2byte[k] = b = (byte)(i + -128);
                this.byte2symbol.put(b, k);
            }
            this.byte2symbol.trim();
            if (this.nsymbols > 0) {
                this.decoderInputs = new HuffmanCodec.DecoderInputs();
                this.codec = new HuffmanCodec(this.packedFrequency, this.decoderInputs);
                if (log.isDebugEnabled()) {
                    log.debug("\n" + RabaCodingSetup.printCodeBook(this.codec.codeWords(), this));
                }
            } else {
                this.decoderInputs = null;
                this.codec = null;
            }
        }
    }

    protected static abstract class AbstractCodingSetup
    implements Byte2Symbol,
    Symbol2Byte {
        protected AbstractCodingSetup() {
        }

        @Override
        public abstract int getSymbolCount();

        public abstract HuffmanCodec codec();

        public abstract HuffmanCodec.DecoderInputs decoderInputs();

        protected static String printCodeBook(BitVector[] codeWords, Symbol2Byte symbol2byte) {
            StringBuilder sb = new StringBuilder();
            int symbol = 0;
            for (BitVector v : codeWords) {
                byte b = symbol2byte.symbol2byte(symbol);
                sb.append("codeWord: " + v + ", symbol=" + symbol + ", value=" + b + (b >= 32 && b < 127 ? " (" + (char)b + ")" : "") + "\n");
                ++symbol;
            }
            return sb.toString();
        }

        protected int[] getPackedFrequencyCount(IRaba raba) {
            int[] frequency = new int[256];
            int size = raba.size();
            int nsymbols = 0;
            for (int i = 0; i < size; ++i) {
                byte[] a = raba.get(i);
                if (a == null) continue;
                for (byte b : a) {
                    int n = b - -128;
                    int n2 = frequency[n];
                    frequency[n] = n2 + 1;
                    if (n2 != 1) continue;
                    ++nsymbols;
                }
            }
            int[] packedFreq = new int[nsymbols];
            int j = 0;
            for (int i = 0; i < frequency.length; ++i) {
                if (frequency[i] == 0) continue;
                packedFreq[j++] = frequency[i];
            }
            return frequency;
        }

        protected int[] getFrequencyCount(IRaba raba) {
            int[] frequency = new int[256];
            int size = raba.size();
            for (int i = 0; i < size; ++i) {
                byte[] a = raba.get(i);
                if (a == null) continue;
                for (byte b : a) {
                    int n = b - -128;
                    frequency[n] = frequency[n] + 1;
                }
            }
            return frequency;
        }

        protected int getSymbolCount(int[] frequency) {
            if (frequency == null) {
                throw new IllegalArgumentException();
            }
            if (frequency.length != 256) {
                throw new IllegalArgumentException();
            }
            int count = 0;
            int i = frequency.length;
            while (i-- != 0) {
                if (frequency[i] == 0) continue;
                ++count;
            }
            return count;
        }

        protected Byte2IntOpenHashMap buildSymbolTable(int[] frequency, int[] packedFrequency, byte[] symbol2byte) {
            assert (frequency.length == 256);
            assert (packedFrequency.length == symbol2byte.length);
            int nsymbols = packedFrequency.length;
            Byte2IntOpenHashMap byte2symbol = new Byte2IntOpenHashMap(nsymbols);
            byte2symbol.defaultReturnValue(-1);
            int i = frequency.length;
            int k = nsymbols;
            while (i-- != 0) {
                byte b;
                if (frequency[i] == 0) continue;
                packedFrequency[--k] = frequency[i];
                symbol2byte[k] = b = (byte)(i + -128);
                byte2symbol.put(b, k);
            }
            byte2symbol.trim();
            return byte2symbol;
        }
    }

    static interface Symbol2Byte {
        public int getSymbolCount();

        public byte symbol2byte(int var1);
    }

    static interface Byte2Symbol {
        public int byte2symbol(byte var1);
    }
}

