/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.BigdataStatics;
import com.bigdata.cache.HardReferenceQueue;
import com.bigdata.cache.HardReferenceQueueWithBatchingUpdates;
import com.bigdata.cache.IBatchedUpdateListener;
import com.bigdata.cache.IConcurrentWeakValueCache;
import com.bigdata.cache.IHardReferenceQueue;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class ConcurrentWeakValueCacheWithBatchedUpdates<K, V>
implements IConcurrentWeakValueCache<K, V> {
    private static final transient Logger log = Logger.getLogger(ConcurrentWeakValueCacheWithBatchedUpdates.class);
    private static final transient boolean DEBUG = log.isDebugEnabled();
    private final ConcurrentHashMap<K, WeakReference<V>> map;
    private final HardReferenceQueueWithBatchingUpdates<V> queue;
    private final ReferenceQueue<V> referenceQueue;

    public boolean isRemoveClearedReferences() {
        return this.referenceQueue != null;
    }

    @Override
    public int size() {
        this.removeClearedEntries();
        return this.map.size();
    }

    @Override
    public int capacity() {
        return this.queue.capacity();
    }

    @Override
    public void clear() {
        this.queue.clear(true);
        this.map.clear();
        this.removeClearedEntries();
    }

    public ConcurrentWeakValueCacheWithBatchedUpdates() {
        this(16);
    }

    public ConcurrentWeakValueCacheWithBatchedUpdates(int queueCapacity) {
        this(queueCapacity, 0.75f, 16);
    }

    public ConcurrentWeakValueCacheWithBatchedUpdates(int queueCapacity, float loadFactor, int concurrencyLevel) {
        this(queueCapacity, loadFactor, concurrencyLevel, true);
    }

    public ConcurrentWeakValueCacheWithBatchedUpdates(int queueCapacity, float loadFactor, int concurrencyLevel, boolean removeClearedReferences) {
        this(new HardReferenceQueue(null, queueCapacity), loadFactor, concurrencyLevel, removeClearedReferences);
    }

    public ConcurrentWeakValueCacheWithBatchedUpdates(IHardReferenceQueue<V> queue, float loadFactor, int concurrencyLevel, boolean removeClearedReferences) {
        this(queue, Math.max(16, queue.capacity() / 2), loadFactor, concurrencyLevel, removeClearedReferences);
    }

    public ConcurrentWeakValueCacheWithBatchedUpdates(IHardReferenceQueue<V> queue, int initialCapacity, float loadFactor, int concurrencyLevel, boolean removeClearedReferences) {
        if (queue == null) {
            throw new IllegalArgumentException();
        }
        this.queue = new HardReferenceQueueWithBatchingUpdates<V>(BigdataStatics.threadLocalBuffers, 16, queue, 10, 64, 32, new IBatchedUpdateListener<V>(){

            @Override
            public void didBatchUpdates() {
                ConcurrentWeakValueCacheWithBatchedUpdates.this.removeClearedEntries();
            }
        });
        this.map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        this.referenceQueue = removeClearedReferences ? new ReferenceQueue() : null;
    }

    @Override
    public V get(K k) {
        Object v;
        WeakReference<V> ref = this.map.get(k);
        if (ref != null && (v = ref.get()) != null) {
            this.queue.add(v);
            return (V)v;
        }
        return null;
    }

    @Override
    public boolean containsKey(K k) {
        Object v;
        WeakReference<V> ref = this.map.get(k);
        if (ref != null && (v = ref.get()) != null) {
            this.queue.add(v);
            return true;
        }
        return false;
    }

    @Override
    public V put(K k, V v) {
        V oldVal;
        WeakReference<V> ref = this.newWeakRef(k, v, this.referenceQueue);
        WeakReference<V> oldRef = this.map.put(k, ref);
        V v2 = oldVal = oldRef == null ? null : (V)oldRef.get();
        if (this.queue.add(v) && DEBUG) {
            log.debug("put: key=" + k + ", val=" + v);
        }
        this.didUpdate(k, ref, oldRef);
        return oldVal;
    }

    @Override
    public V putIfAbsent(K k, V v) {
        V oldVal;
        WeakReference<V> ref = this.newWeakRef(k, v, this.referenceQueue);
        WeakReference<V> oldRef = this.map.putIfAbsent(k, ref);
        V v2 = oldVal = oldRef == null ? null : (V)oldRef.get();
        if (oldRef != null && oldVal == null && this.map.replace(k, oldRef, ref)) {
            if (this.queue.add(v) && DEBUG) {
                log.debug("put: key=" + k + ", val=" + v);
            }
            this.didUpdate(k, ref, oldRef);
            return null;
        }
        if (oldVal == null) {
            if (this.queue.add(v) && DEBUG) {
                log.debug("put: key=" + k + ", val=" + v);
            }
            this.didUpdate(k, ref, null);
            return null;
        }
        return oldVal;
    }

    protected void didUpdate(K k, WeakReference<V> newRef, WeakReference<V> oldRef) {
    }

    @Override
    public V remove(K k) {
        WeakReference<V> ref = this.removeMapEntry(k);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    protected void removeClearedEntries() {
        if (this.referenceQueue == null) {
            return;
        }
        int counter = 0;
        Reference<V> ref = this.referenceQueue.poll();
        while (ref != null) {
            Object k = ((WeakRef)ref).k;
            if (this.map.get(k) == ref) {
                if (DEBUG) {
                    log.debug("Removing cleared reference: key=" + k);
                }
                this.removeMapEntry(k);
                ++counter;
            }
            ref = this.referenceQueue.poll();
        }
        if (counter > 1 && log.isInfoEnabled()) {
            log.info("Removed " + counter + " cleared references");
        }
    }

    protected WeakReference<V> removeMapEntry(K k) {
        return this.map.remove(k);
    }

    @Override
    public Iterator<WeakReference<V>> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Iterator<Map.Entry<K, WeakReference<V>>> entryIterator() {
        return this.map.entrySet().iterator();
    }

    protected WeakReference<V> newWeakRef(K k, V v, ReferenceQueue<V> referenceQueue) {
        if (referenceQueue == null) {
            return new WeakReference<V>(v);
        }
        return new WeakRef<K, V>(k, v, referenceQueue);
    }

    protected static class WeakRef<K, V>
    extends WeakReference<V> {
        private final K k;

        public WeakRef(K k, V v, ReferenceQueue<V> queue) {
            super(v, queue);
            this.k = k;
        }
    }
}

