/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.cache.ICacheEntry;
import com.bigdata.cache.ICacheListener;
import com.bigdata.cache.ICachePolicy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public class LRUCache<K, T>
implements ICachePolicy<K, T> {
    protected static final Logger log = Logger.getLogger(LRUCache.class);
    protected static final boolean INFO = log.isInfoEnabled();
    private final int capacity;
    private final Map<K, Entry<K, T>> map;
    private Entry<K, T> first = null;
    private Entry<K, T> last = null;
    private final float loadFactor;
    private long highTide = 0L;
    private long ninserts = 0L;
    private long ntests = 0L;
    private long nsuccess = 0L;
    private ICacheListener<K, T> _listener = null;
    private int reentrantPutCounter = 0;
    private CopyOnWriteArraySet<ICacheOrderChangeListener<K, T>> _cacheOrderChangeListeners = null;

    public double getHitRatio() {
        return (double)this.nsuccess / (double)this.ntests;
    }

    public long getInsertCount() {
        return this.ninserts;
    }

    public long getTestCount() {
        return this.ntests;
    }

    public long getSuccessCount() {
        return this.nsuccess;
    }

    public LRUCache(int capacity) {
        this(capacity, 0.75f);
    }

    public LRUCache(int capacity, float loadFactor) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.loadFactor = loadFactor;
        this.map = new HashMap<K, Entry<K, T>>(capacity, loadFactor);
    }

    @Override
    public void setListener(ICacheListener<K, T> listener) {
        this._listener = listener;
    }

    @Override
    public ICacheListener<K, T> getCacheListener() {
        return this._listener;
    }

    @Override
    public Iterator<T> iterator() {
        return new LRUIterator(this, true);
    }

    @Override
    public Iterator<ICacheEntry<K, T>> entryIterator() {
        return new LRUIterator(this, false);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.last = null;
        this.first = null;
        this.resetStatistics();
    }

    public void resetStatistics() {
        this.nsuccess = 0L;
        this.ntests = 0L;
        this.ninserts = 0L;
        this.highTide = 0L;
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    protected void finalize() throws Throwable {
        if (INFO) {
            log.info(this.getStatistics());
        }
    }

    public String getStatistics() {
        return "LRUCache: capacity=" + this.capacity + ", loadFactor=" + this.loadFactor + ", highTide=" + this.highTide + ", ninserts=" + this.ninserts + ", ntests=" + this.ntests + ", nsuccess=" + this.nsuccess + ", hitRatio=" + (double)this.nsuccess / (double)this.ntests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void put(K key, T obj, boolean dirty) {
        assert (key != null);
        ++this.reentrantPutCounter;
        try {
            Entry<K, T> entry = this.map.get(key);
            if (entry == null) {
                if (this.map.size() >= this.capacity && this.reentrantPutCounter == 1) {
                    while (this.map.size() >= this.capacity) {
                        entry = this.first;
                        if (this._listener != null) {
                            this._listener.objectEvicted(entry);
                        }
                        this.removeEntry(entry);
                        this.map.remove(((Entry)entry).key);
                    }
                    ((Entry)entry).key = key;
                    ((Entry)entry).obj = obj;
                    ((Entry)entry).dirty = dirty;
                    this.map.put(key, entry);
                    this.addEntry(entry);
                } else {
                    entry = new Entry<K, T>(key, obj, dirty);
                    this.map.put(key, entry);
                    this.addEntry(entry);
                    int count = this.map.size();
                    if ((long)count > this.highTide) {
                        this.highTide = count;
                    }
                }
                ++this.ninserts;
            } else {
                if (((Entry)entry).obj != obj) {
                    throw new IllegalStateException("can not change object under key");
                }
                this.touchEntry(entry);
                ((Entry)entry).dirty = dirty;
            }
        }
        finally {
            --this.reentrantPutCounter;
        }
    }

    @Override
    public synchronized T get(K key) {
        assert (key != null);
        ++this.ntests;
        Entry<K, T> entry = this.map.get(key);
        if (entry == null) {
            return null;
        }
        this.touchEntry(entry);
        ++this.nsuccess;
        return entry.getObject();
    }

    @Override
    public synchronized T remove(K key) {
        assert (key != null);
        Entry<K, T> entry = this.map.remove(key);
        if (entry == null) {
            return null;
        }
        this.removeEntry(entry);
        return entry.getObject();
    }

    protected synchronized void addCacheOrderChangeListener(ICacheOrderChangeListener<K, T> l) {
        if (this._cacheOrderChangeListeners == null) {
            this._cacheOrderChangeListeners = new CopyOnWriteArraySet();
        }
        this._cacheOrderChangeListeners.add(l);
    }

    protected synchronized void removeCacheOrderChangeListener(ICacheOrderChangeListener<K, T> l) {
        if (this._cacheOrderChangeListeners == null) {
            return;
        }
        this._cacheOrderChangeListeners.remove(l);
        if (this._cacheOrderChangeListeners.size() == 0) {
            this._cacheOrderChangeListeners = null;
        }
    }

    private void fireCacheOrderChangeEvent(boolean removed, ICacheEntry<K, T> entry) {
        if (this._cacheOrderChangeListeners.size() == 0) {
            return;
        }
        for (ICacheOrderChangeListener<K, T> l : this._cacheOrderChangeListeners) {
            if (removed) {
                l.willRemove(entry);
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    private void addEntry(Entry<K, T> entry) {
        if (this.first == null) {
            this.first = entry;
            this.last = entry;
        } else {
            ((Entry)this.last).next = (Entry)entry;
            ((Entry)entry).prior = (Entry)this.last;
            this.last = entry;
        }
    }

    private void removeEntry(Entry<K, T> entry) {
        if (this._cacheOrderChangeListeners != null) {
            this.fireCacheOrderChangeEvent(true, entry);
        }
        Entry prior = ((Entry)entry).prior;
        Entry next = ((Entry)entry).next;
        if (entry == this.first) {
            this.first = next;
        }
        if (this.last == entry) {
            this.last = prior;
        }
        if (prior != null) {
            prior.next = next;
        }
        if (next != null) {
            next.prior = prior;
        }
        ((Entry)entry).prior = null;
        ((Entry)entry).next = null;
    }

    private void touchEntry(Entry<K, T> entry) {
        if (this.last == entry) {
            return;
        }
        this.removeEntry(entry);
        this.addEntry(entry);
    }

    static class LRUIterator<K, T>
    implements Iterator,
    ICacheOrderChangeListener<K, T> {
        private final LRUCache<K, T> cache;
        private final boolean resolveObjects;
        private Entry<K, T> next;
        private Entry<K, T> lastVisited = null;

        LRUIterator(LRUCache<K, T> cache, boolean resolveObjects) {
            this.cache = cache;
            this.next = ((LRUCache)cache).first;
            this.resolveObjects = resolveObjects;
            cache.addCacheOrderChangeListener(this);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                this.removeListener();
                throw new NoSuchElementException();
            }
            Object ret = this.resolveObjects ? ((Entry)this.next).obj : this.next;
            this.lastVisited = this.next;
            this.next = ((Entry)this.next).next;
            if (this.next == null) {
                this.removeListener();
            }
            return ret;
        }

        @Override
        public void remove() {
            if (this.lastVisited == null) {
                throw new IllegalStateException();
            }
            ((LRUCache)this.cache).map.remove(((Entry)this.lastVisited).key);
            ((LRUCache)this.cache).removeEntry(this.lastVisited);
        }

        @Override
        public void willRemove(ICacheEntry entry) {
            if (entry == this.next) {
                this.next = ((Entry)this.next).next;
            }
        }

        private void removeListener() {
            this.cache.removeCacheOrderChangeListener(this);
        }
    }

    static final class Entry<K, T>
    implements ICacheEntry<K, T> {
        private K key;
        private T obj;
        private boolean dirty;
        private Entry<K, T> prior;
        private Entry<K, T> next;

        Entry(K key, T obj, boolean dirty) {
            this.key = key;
            this.obj = obj;
            this.dirty = dirty;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public T getObject() {
            return this.obj;
        }

        public Entry<K, T> getPrior() {
            return this.prior;
        }

        public Entry<K, T> getNext() {
            return this.next;
        }

        public String toString() {
            return "Entry{key=" + this.key + ",obj=" + this.obj + ",dirty=" + this.dirty + ",prior=" + (this.prior == null ? "N/A" : "" + this.prior.key) + ",next=" + (this.next == null ? "N/A" : "" + this.next.key) + "}";
        }
    }

    protected static interface ICacheOrderChangeListener<K, T> {
        public void willRemove(ICacheEntry<K, T> var1);
    }
}

