/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.cache;

import com.bigdata.cache.HardReferenceQueue;
import com.bigdata.cache.HardReferenceQueueEvictionListener;
import com.bigdata.cache.IHardReferenceQueue;
import com.bigdata.util.DaemonThreadFactory;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class SynchronizedHardReferenceQueueWithTimeout<T>
implements IHardReferenceQueue<T> {
    private static final Logger log = Logger.getLogger(SynchronizedHardReferenceQueueWithTimeout.class);
    private final InnerHardReferenceQueue<ValueAge<T>> queue;
    private static final ScheduledExecutorService cleanerService = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("StaleReferenceCleaner"));
    private static ConcurrentLinkedQueue<WeakReference<SynchronizedHardReferenceQueueWithTimeout>> queues;

    final HardReferenceQueue<IRef<T>> getQueue() {
        return this.queue;
    }

    public SynchronizedHardReferenceQueueWithTimeout(int capacity, long timeoutNanos) {
        this(capacity, 10, timeoutNanos);
    }

    public SynchronizedHardReferenceQueueWithTimeout(int capacity, int nscan, long timeoutNanos) {
        this(null, capacity, nscan, timeoutNanos);
    }

    SynchronizedHardReferenceQueueWithTimeout(HardReferenceQueueEvictionListener<IRef<T>> listener, int capacity, int nscan, long timeoutNanos) {
        this.queue = new InnerHardReferenceQueue<IRef<T>>(listener, capacity, nscan, timeoutNanos);
        if (((InnerHardReferenceQueue)this.queue).timeout > 0L) {
            queues.add(new WeakReference<SynchronizedHardReferenceQueueWithTimeout>(this));
        }
    }

    public final long timeout() {
        return ((InnerHardReferenceQueue)this.queue).timeout;
    }

    @Override
    public final int capacity() {
        return this.queue.capacity();
    }

    @Override
    public final int nscan() {
        return this.queue.nscan();
    }

    @Override
    public synchronized boolean add(T ref) {
        if (ref == null) {
            throw new IllegalArgumentException();
        }
        return this.queue.add(new ValueAge<T>(ref));
    }

    @Override
    public synchronized void clear(boolean clearRefs) {
        this.queue.clear(clearRefs);
    }

    @Override
    public synchronized boolean evict() {
        return this.queue.evict();
    }

    @Override
    public synchronized void evictAll(boolean clearRefs) {
        this.queue.evictAll(clearRefs);
    }

    @Override
    public synchronized T peek() {
        ValueAge age = (ValueAge)this.queue.peek();
        return age == null ? null : (T)age.ref;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public synchronized boolean isFull() {
        return this.queue.isFull();
    }

    @Override
    public synchronized int size() {
        return this.queue.size();
    }

    public static final void stopStaleReferenceCleaner() {
        cleanerService.shutdownNow();
    }

    static {
        cleanerService.scheduleWithFixedDelay(new Cleaner(), 5000L, 5000L, TimeUnit.MILLISECONDS);
        queues = new ConcurrentLinkedQueue();
    }

    static class ValueAge<T>
    implements IRef<T> {
        final T ref;
        final long ts = System.nanoTime();

        @Override
        public T get() {
            return this.ref;
        }

        public ValueAge(T ref) {
            this.ref = ref;
        }
    }

    public static interface IRef<T> {
        public T get();
    }

    private static class Cleaner
    implements Runnable {
        private Cleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int ncleared = 0;
                int nqueues = 0;
                Iterator itr = queues.iterator();
                while (itr.hasNext()) {
                    WeakReference ref = (WeakReference)itr.next();
                    SynchronizedHardReferenceQueueWithTimeout queue = (SynchronizedHardReferenceQueueWithTimeout)ref.get();
                    if (queue == null) {
                        itr.remove();
                        continue;
                    }
                    SynchronizedHardReferenceQueueWithTimeout synchronizedHardReferenceQueueWithTimeout = queue;
                    synchronized (synchronizedHardReferenceQueueWithTimeout) {
                        ncleared += queue.queue.evictStaleRefs();
                    }
                    ++nqueues;
                }
                if (ncleared > 0 && log.isInfoEnabled()) {
                    log.info("Cleared " + ncleared + " stale references from " + nqueues + " queues");
                }
            }
            catch (Throwable t) {
                log.error(t, t);
            }
        }
    }

    private static class InnerHardReferenceQueue<T extends ValueAge<?>>
    extends HardReferenceQueue<T> {
        private final long timeout;

        public InnerHardReferenceQueue(HardReferenceQueueEvictionListener<T> listener, int capacity, int nscan, long timeout) {
            super(listener, capacity, nscan);
            if (timeout < 0L) {
                throw new IllegalArgumentException();
            }
            this.timeout = timeout;
        }

        int evictStaleRefs(long timeout) {
            ValueAge x;
            int size0 = this.size();
            if (size0 == 0) {
                return 0;
            }
            long now = System.nanoTime();
            long maxAge = now - ((ValueAge)this.peek()).ts;
            long age = 0L;
            int ncleared = 0;
            while ((x = (ValueAge)this.peek()) != null && (age = now - x.ts) >= timeout) {
                this.evict();
                if (log.isTraceEnabled()) {
                    log.trace("Evicting: " + x.ref + " : timeout=" + TimeUnit.NANOSECONDS.toMillis(timeout) + "ms, age=" + TimeUnit.NANOSECONDS.toMillis(age) + "ms, size=" + this.size + ", ncleared=" + ncleared);
                }
                ++ncleared;
            }
            if (log.isDebugEnabled() && ncleared > 3) {
                log.debug("#ncleared=" + ncleared + ", size=" + this.size() + ", timeout=" + TimeUnit.NANOSECONDS.toMillis(timeout) + ", maxAge=" + TimeUnit.NANOSECONDS.toMillis(maxAge) + ", age=" + TimeUnit.NANOSECONDS.toMillis(age));
            }
            return ncleared;
        }

        public int evictStaleRefs() {
            if (this.timeout != 0L) {
                return this.evictStaleRefs(this.timeout);
            }
            return 0;
        }

        @Override
        public final boolean scanHead(int nscan, T ref) {
            if (nscan <= 0) {
                throw new IllegalArgumentException();
            }
            if (ref == null) {
                throw new IllegalArgumentException();
            }
            int head = this.getHeadIndex();
            int count = this.size;
            Object o1 = ((ValueAge)ref).get();
            for (int i = 0; i < nscan && count > 0; --count, ++i) {
                head = head == 0 ? this.capacity - 1 : head - 1;
                Object o2 = ((ValueAge)this._get(head)).get();
                if (o1 != o2) continue;
                return true;
            }
            return false;
        }
    }
}

