/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public class FutureTaskMon<T>
extends FutureTask<T> {
    private static final transient Logger log = Logger.getLogger(FutureTaskMon.class);
    private volatile boolean didStart = false;

    public FutureTaskMon(Callable<T> callable) {
        super(callable);
    }

    public FutureTaskMon(Runnable runnable, T result) {
        super(runnable, result);
    }

    @Override
    public void run() {
        this.didStart = true;
        super.run();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean didStart = this.didStart;
        boolean ret = super.cancel(mayInterruptIfRunning);
        if (didStart && mayInterruptIfRunning && ret && log.isDebugEnabled()) {
            log.debug("May have interrupted running task", new RuntimeException("Stack trace of cancel() invocation"));
        }
        return ret;
    }
}

