/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.concurrent;

import com.bigdata.concurrent.HorridTaskDeath;
import com.bigdata.concurrent.LockManager;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class LockManagerTask<R extends Comparable<R>, T>
implements Callable<T> {
    protected static final Logger log = Logger.getLogger(LockManagerTask.class);
    protected static final boolean INFO = log.isInfoEnabled();
    private final LockManager<R> lockManager;
    private final R[] resource;
    private final Callable<T> target;
    private int maxLockTries = 1;
    private long lockTimeout = 0L;
    private long nanoTime_lockLatency;

    public LockManager<R> getLockManager() {
        return this.lockManager;
    }

    public R[] getResource() {
        return this.resource;
    }

    public int setMaxLockTries(int newValue) {
        if (newValue < 1) {
            throw new IllegalArgumentException();
        }
        int t = this.maxLockTries;
        this.maxLockTries = newValue;
        return t;
    }

    public long getLockLatency() {
        return this.nanoTime_lockLatency;
    }

    public int getMaxLockTries() {
        return this.maxLockTries;
    }

    public long setLockTimeout(long newValue) {
        long t = this.lockTimeout;
        this.lockTimeout = newValue;
        return t;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public LockManagerTask(LockManager<R> lockManager, R[] resource, Callable<T> target) {
        if (lockManager == null) {
            throw new NullPointerException();
        }
        if (resource == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < resource.length; ++i) {
            if (resource[i] != null) continue;
            throw new NullPointerException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        this.lockManager = lockManager;
        this.resource = resource;
        this.target = target;
    }

    /*
     * Exception decompiling
     */
    private void acquireLocks() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T call() throws Exception {
        long nanoTime_beforeLock = System.nanoTime();
        this.lockManager.didStart(this);
        try {
            this.acquireLocks();
            if (INFO) {
                log.info("Acquired locks");
            }
        }
        catch (Exception ex) {
            this.lockManager.didAbort(this, ex, true);
            throw ex;
        }
        catch (Throwable t) {
            this.lockManager.didAbort(this, t, true);
            throw new RuntimeException(t);
        }
        finally {
            this.nanoTime_lockLatency = System.nanoTime() - nanoTime_beforeLock;
        }
        try {
            T ret;
            if (INFO) {
                log.info(this.toString() + ": run - start");
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            long nrunning = this.lockManager.nrunning.incrementAndGet();
            this.lockManager.maxrunning.set(Math.max(this.lockManager.maxrunning.get(), nrunning));
            try {
                ret = this.target.call();
            }
            finally {
                this.lockManager.nrunning.decrementAndGet();
            }
            if (INFO) {
                log.info(this.toString() + ": run - end");
            }
            this.lockManager.didSucceed(this);
            return ret;
        }
        catch (Throwable t) {
            if (t instanceof HorridTaskDeath) {
                this.lockManager.didAbort(this, t, false);
                throw (HorridTaskDeath)t;
            }
            this.lockManager.didAbort(this, t, false);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new RuntimeException(t);
        }
    }

    public String toString() {
        return super.toString() + " resources=" + Arrays.toString(this.resource);
    }
}

