/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.concurrent;

import com.bigdata.concurrent.DeadlockException;
import com.bigdata.concurrent.MultiprogrammingCapacityExceededException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TxDag {
    protected static final Logger log = Logger.getLogger(TxDag.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    private final int _capacity;
    private final boolean[][] W;
    private final int[][] M;
    private final int[][] M1;
    final int[] inbound;
    final int[] outbound;
    final Object[] transactions;
    private int[] _order = null;
    private final int[] EMPTY = new int[0];
    public static boolean sortOrder = false;
    public static boolean sortOrderForDisplay = true;
    public static boolean cacheOrder = false;
    public static final int UNKNOWN = -1;
    private final List<Integer> indices = new LinkedList<Integer>();
    private final Map<Object, Integer> mapping = new HashMap<Object, Integer>();

    public int capacity() {
        return this._capacity;
    }

    public synchronized int size() {
        return this.mapping.size();
    }

    public synchronized boolean isFull() {
        return this.size() == this._capacity;
    }

    public TxDag(int capacity) {
        int n = capacity;
        if (n < 2) {
            throw new IllegalArgumentException();
        }
        this._capacity = n;
        this.W = new boolean[n][n];
        this.M = new int[n][n];
        this.M1 = new int[n][n];
        this.inbound = new int[n];
        this.outbound = new int[n];
        this.transactions = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.indices.add(i);
            this.inbound[i] = 0;
            this.outbound[i] = 0;
            this.transactions[i] = null;
            for (int j = 0; j < n; ++j) {
                this.W[i][j] = false;
                this.M[i][j] = 0;
                this.M1[i][j] = 0;
            }
        }
    }

    synchronized int lookup(Object tx, boolean insert) {
        if (tx == null) {
            throw new IllegalArgumentException("transaction object is null");
        }
        Integer index = this.mapping.get(tx);
        if (index == null) {
            if (insert) {
                int capacity = this.capacity();
                int nvertices = this.mapping.size();
                if (nvertices == capacity) {
                    throw new MultiprogrammingCapacityExceededException("capacity=" + capacity + ", nvertices=" + nvertices);
                }
                index = this.indices.remove(0);
                this.mapping.put(tx, index);
                int ndx = index;
                if (this.transactions[ndx] != null) {
                    throw new AssertionError();
                }
                this.transactions[ndx] = tx;
            } else {
                return -1;
            }
        }
        return index;
    }

    public synchronized boolean releaseVertex(Object tx) {
        Integer index = this.mapping.remove(tx);
        if (index == null) {
            if (INFO) {
                log.info("Not a vertex: " + tx);
            }
            return false;
        }
        this.indices.add(index);
        int ndx = index;
        if (this.transactions[ndx] == null) {
            throw new AssertionError();
        }
        this.transactions[ndx] = null;
        return true;
    }

    final synchronized int getPathCount(int u, int v) {
        return this.M[u][v];
    }

    final synchronized int[][] getPathCountMatrix() {
        return (int[][])this.M.clone();
    }

    public synchronized void addEdge(Object blocked, Object running) throws DeadlockException {
        if (running == blocked) {
            throw new IllegalArgumentException("may not wait for self");
        }
        int dst = this.lookup(running, true);
        int src = this.lookup(blocked, true);
        if (src == dst) {
            throw new IllegalArgumentException("may not wait for self.");
        }
        if (this.W[src][dst]) {
            throw new IllegalStateException("edge exists");
        }
        if (DEBUG) {
            log.debug(this.toString());
        }
        int[] order = this.getOrder();
        this.backup(order);
        try {
            if (!this.updateClosure(src, dst, true)) {
                log.warn("Deadlock");
                this.restore(order);
                if (DEBUG) {
                    log.debug(this.toString());
                }
                throw new DeadlockException("deadlock");
            }
        }
        catch (DeadlockException ex) {
            throw ex;
        }
        catch (Throwable t) {
            log.error(t);
            this.restore(order);
            throw new RuntimeException(t);
        }
        this.W[src][dst] = true;
        int n = src;
        this.outbound[n] = this.outbound[n] + 1;
        int n2 = dst;
        this.inbound[n2] = this.inbound[n2] + 1;
        if (this.outbound[src] == 1 || this.inbound[dst] == 1) {
            this.resetOrder();
        }
        if (DEBUG) {
            log.debug(this.toString());
        }
    }

    final synchronized void backup(int[] order) {
        int n = order.length;
        for (int i = 0; i < n; ++i) {
            int oi = order[i];
            for (int j = 0; j < n; ++j) {
                int oj = order[j];
                this.M1[oi][oj] = this.M[oi][oj];
            }
        }
    }

    final synchronized void restore(int[] order) {
        int n = order.length;
        for (int i = 0; i < n; ++i) {
            int oi = order[i];
            for (int j = 0; j < n; ++j) {
                int oj = order[j];
                this.M[oi][oj] = this.M1[oi][oj];
            }
        }
    }

    final synchronized boolean updateClosure(int t, int u, boolean insert) {
        int os;
        int s;
        int[] order = insert ? this.getOrder(t, u) : this.getOrder();
        int n = order.length;
        if (DEBUG) {
            log.debug("W:: t(" + t + ") -> u(" + u + "), insert=" + insert + ", size=" + n);
        }
        int max = Integer.MAX_VALUE;
        for (s = 0; s < n; ++s) {
            os = order[s];
            if (os == t) continue;
            for (int v = 0; v < n; ++v) {
                int ov = order[v];
                if (ov == u) continue;
                if (DEBUG) {
                    log.debug("M[s=" + os + ",v=" + ov + "] := " + "M[s=" + os + ",v=" + ov + "](" + this.M[os][ov] + ") +/- " + "M[s=" + os + ",t=" + t + "](" + this.M[os][t] + ") . " + "M[u=" + u + ",v=" + ov + "](" + this.M[u][ov] + ")");
                }
                if (insert) {
                    long val = this.M[os][ov] + this.M[os][t] * this.M[u][ov];
                    if (val > Integer.MAX_VALUE) {
                        throw new ArithmeticException("overflow");
                    }
                    this.M[os][ov] = (int)val;
                    continue;
                }
                int[] nArray = this.M[os];
                int n2 = ov;
                nArray[n2] = nArray[n2] - this.M[os][t] * this.M[u][ov];
            }
            if (DEBUG) {
                log.debug("M[s=" + os + ",u=" + u + "] := " + "M[s=" + os + ",u=" + u + "](" + this.M[os][u] + ") +/- " + "M[s=" + os + ",t=" + t + "](" + this.M[os][t] + ")");
            }
            if (insert) {
                long val = this.M[os][u] + this.M[os][t];
                if (val > Integer.MAX_VALUE) {
                    throw new ArithmeticException("overflow");
                }
                this.M[os][u] = (int)val;
                continue;
            }
            int[] nArray = this.M[os];
            int n3 = u;
            nArray[n3] = nArray[n3] - this.M[os][t];
        }
        for (int v = 0; v < n; ++v) {
            int ov = order[v];
            if (ov == u) continue;
            if (DEBUG) {
                log.debug("M[t=" + t + ",v=" + ov + "] := " + "M[t=" + t + ",v=" + ov + "](" + this.M[t][ov] + ") +/- " + "M[u=" + u + ",v=" + ov + "](" + this.M[t][ov] + ")");
            }
            if (insert) {
                long val = this.M[t][ov] + this.M[u][ov];
                if (val > Integer.MAX_VALUE) {
                    throw new ArithmeticException("overflow");
                }
                this.M[t][ov] = (int)val;
                continue;
            }
            int[] nArray = this.M[t];
            int n4 = ov;
            nArray[n4] = nArray[n4] - this.M[u][ov];
        }
        if (DEBUG) {
            log.debug("M[t=" + t + ",u=" + u + "] := " + "M[t=" + t + ",u=" + u + "](" + this.M[t][u] + ") +/- 1");
        }
        if (insert) {
            if (this.M[t][u] == Integer.MAX_VALUE) {
                throw new ArithmeticException("overflow");
            }
            int[] nArray = this.M[t];
            int n5 = u;
            nArray[n5] = nArray[n5] + 1;
        } else {
            int[] nArray = this.M[t];
            int n6 = u;
            nArray[n6] = nArray[n6] - 1;
        }
        for (s = 0; s < n; ++s) {
            os = order[s];
            if (this.M[os][os] <= 0) continue;
            if (DEBUG) {
                log.debug("deadlock: M[" + os + "," + os + "]=" + this.M[os][os]);
            }
            return false;
        }
        return true;
    }

    public synchronized String toString() {
        int oi;
        int i;
        int[] order;
        if (sortOrderForDisplay) {
            order = (int[])this.getOrder().clone();
            Arrays.sort(order);
        } else {
            order = this.getOrder();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("TxDag::\ncapacity=" + this.capacity() + ", size=" + this.size() + "\n");
        sb.append("index\t#in\t#out\n");
        for (i = 0; i < order.length; ++i) {
            oi = order[i];
            sb.append("" + order[i] + "\t" + this.inbound[oi] + "\t" + this.outbound[oi] + "\n");
        }
        for (i = 0; i < order.length; ++i) {
            oi = order[i];
            for (int j = 0; j < order.length; ++j) {
                int oj = order[j];
                if (!this.W[oi][oj]) continue;
                sb.append("\t" + this.transactions[oi] + " -> " + this.transactions[oj] + "\n");
            }
        }
        sb.append("index");
        for (int j = 0; j < order.length; ++j) {
            sb.append("\t" + order[j]);
        }
        sb.append("\n");
        boolean deadlock = false;
        for (int i2 = 0; i2 < order.length; ++i2) {
            int oi2 = order[i2];
            sb.append("" + oi2);
            for (int j = 0; j < order.length; ++j) {
                int oj = order[j];
                int count = this.M[oi2][oj];
                if (count != 0) {
                    sb.append("\t" + count);
                } else {
                    sb.append("\t-");
                }
                if (oi2 != oj || count <= 0) continue;
                deadlock = true;
            }
            sb.append("\t" + this.transactions[oi2] + "\n");
        }
        for (int j = 0; j < order.length; ++j) {
            sb.append("\t" + this.transactions[order[j]]);
        }
        sb.append("\n");
        sb.append("deadlock=" + deadlock + "\n");
        return sb.toString();
    }

    synchronized int[] getOrder() {
        if (cacheOrder && this._order != null) {
            return this._order;
        }
        int n = this.size();
        if (n == 0) {
            this._order = this.EMPTY;
            return this._order;
        }
        int[] tmp = new int[n];
        int nnzero = 0;
        for (int index : this.mapping.values()) {
            if (this.inbound[index] <= 0 && this.outbound[index] <= 0) continue;
            tmp[nnzero++] = index;
        }
        if (nnzero == 0) {
            this._order = this.EMPTY;
            return this._order;
        }
        this._order = new int[nnzero];
        System.arraycopy(tmp, 0, this._order, 0, nnzero);
        if (sortOrder) {
            Arrays.sort(this._order);
        }
        return this._order;
    }

    final synchronized int[] getOrder(int t, int u) {
        if (t == u) {
            throw new IllegalArgumentException();
        }
        if (!(this.inbound[t] <= 0 && this.outbound[t] <= 0 || this.inbound[u] <= 0 && this.outbound[u] <= 0)) {
            return this.getOrder();
        }
        int n = this.size();
        int[] tmp = new int[n];
        int nnzero = 0;
        for (int index : this.mapping.values()) {
            if (index != t && index != u && this.inbound[index] <= 0 && this.outbound[index] <= 0) continue;
            tmp[nnzero++] = index;
        }
        if (nnzero == 0) {
            return this.EMPTY;
        }
        int[] order = new int[nnzero];
        System.arraycopy(tmp, 0, order, 0, nnzero);
        if (sortOrder) {
            Arrays.sort(order);
        }
        return order;
    }

    final synchronized void resetOrder() {
        this._order = null;
    }

    public synchronized void addEdges(Object blocked, Object[] running) throws DeadlockException {
        if (running == blocked) {
            throw new IllegalArgumentException("transaction may not wait for self");
        }
        if (running == null) {
            throw new IllegalArgumentException("running is null");
        }
        if (running.length == 0) {
            return;
        }
        int src = this.lookup(blocked, true);
        int[] dst = new int[running.length];
        for (int i = 0; i < running.length; ++i) {
            dst[i] = this.lookup(running[i], true);
            if (dst[i] == src) {
                throw new IllegalArgumentException("transaction may not wait for self");
            }
            if (!this.W[src][dst[i]]) continue;
            throw new IllegalStateException("edge exists");
        }
        if (DEBUG) {
            log.debug(this.toString());
        }
        int[] order = this.getOrder();
        this.backup(order);
        try {
            for (int i = 0; i < dst.length; ++i) {
                if (this.updateClosure(src, dst[i], true)) continue;
                log.warn("deadlock");
                if (DEBUG) {
                    log.debug(this.toString());
                }
                this.restore(order);
                throw new DeadlockException("deadlock");
            }
        }
        catch (DeadlockException ex) {
            throw ex;
        }
        catch (Throwable t) {
            log.error(t);
            this.restore(order);
            throw new RuntimeException(t);
        }
        boolean reset = false;
        for (int i = 0; i < dst.length; ++i) {
            int tgt = dst[i];
            this.W[src][tgt] = true;
            int n = src;
            this.outbound[n] = this.outbound[n] + 1;
            int n2 = tgt;
            this.inbound[n2] = this.inbound[n2] + 1;
            if (this.outbound[src] != 1 && this.inbound[tgt] != 1) continue;
            reset = true;
        }
        if (reset) {
            this.resetOrder();
        }
        if (DEBUG) {
            log.debug(this.toString());
        }
    }

    public synchronized boolean hasEdge(Object blocked, Object running) {
        if (running == blocked) {
            throw new IllegalArgumentException("transaction may not wait for itself");
        }
        int dst = this.lookup(running, true);
        int src = this.lookup(blocked, true);
        if (src == dst) {
            throw new IllegalArgumentException("transaction may not wait for itself");
        }
        return this.W[src][dst];
    }

    public synchronized Edge[] getEdges(boolean closure) {
        int[] order = this.getOrder();
        int n = order.length;
        Vector<Edge> v = new Vector<Edge>();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (this.W[order[i]][order[j]]) {
                    v.add(new Edge(this.transactions[order[i]], this.transactions[order[j]], true));
                    continue;
                }
                if (!closure || this.M[order[i]][order[j]] <= 0) continue;
                v.add(new Edge(this.transactions[order[i]], this.transactions[order[j]], false));
            }
        }
        return v.toArray(new Edge[0]);
    }

    public synchronized void removeEdge(Object blocked, Object running) {
        int src = this.lookup(blocked, false);
        if (src == -1) {
            throw new IllegalStateException("unknown transaction: tx1=" + blocked);
        }
        int tgt = this.lookup(running, false);
        if (tgt == -1) {
            throw new IllegalStateException("unknown transaction: tx2=" + running);
        }
        if (src == tgt) {
            throw new IllegalArgumentException();
        }
        if (!this.W[src][tgt]) {
            throw new IllegalStateException("edge does not exist: src=" + blocked + ", tgt=" + running);
        }
        if (DEBUG) {
            log.debug(this.toString());
        }
        this.updateClosure(src, tgt, false);
        this.W[src][tgt] = false;
        int n = src;
        this.outbound[n] = this.outbound[n] - 1;
        int n2 = tgt;
        this.inbound[n2] = this.inbound[n2] - 1;
        if (this.outbound[src] == 0 || this.inbound[tgt] == 0) {
            this.resetOrder();
        }
        if (this.outbound[src] < 0) {
            throw new AssertionError();
        }
        if (this.inbound[tgt] < 0) {
            throw new AssertionError();
        }
        if (DEBUG) {
            log.debug(this.toString());
        }
    }

    private synchronized void removeEdge(int src, int tgt) {
        if (src == tgt) {
            throw new IllegalArgumentException();
        }
        if (!this.W[src][tgt]) {
            throw new IllegalStateException("edge does not exist: src=" + src + ", tgt=" + tgt);
        }
        this.updateClosure(src, tgt, false);
        this.W[src][tgt] = false;
        int n = src;
        this.outbound[n] = this.outbound[n] - 1;
        int n2 = tgt;
        this.inbound[n2] = this.inbound[n2] - 1;
        if (this.outbound[src] == 0 || this.inbound[tgt] == 0) {
            this.resetOrder();
        }
        if (this.outbound[src] < 0) {
            throw new AssertionError();
        }
        if (this.inbound[tgt] < 0) {
            throw new AssertionError();
        }
    }

    public synchronized void removeEdges(Object tx, boolean waiting) {
        int tgt = this.lookup(tx, false);
        if (tgt == -1) {
            return;
        }
        if (DEBUG) {
            log.debug(this.toString());
        }
        if (!waiting) {
            int[] order = this.getOrder();
            for (int i = 0; i < order.length; ++i) {
                int oi = order[i];
                if (this.W[tgt][oi]) {
                    int n = oi;
                    this.inbound[n] = this.inbound[n] - 1;
                    if (this.inbound[oi] < 0) {
                        throw new AssertionError();
                    }
                }
                if (this.W[oi][tgt]) {
                    int n = oi;
                    this.outbound[n] = this.outbound[n] - 1;
                    if (this.outbound[oi] < 0) {
                        throw new AssertionError();
                    }
                }
                this.M[tgt][oi] = 0;
                this.M[oi][tgt] = 0;
                this.W[tgt][oi] = false;
                this.W[oi][tgt] = false;
            }
            this.inbound[tgt] = 0;
            this.outbound[tgt] = 0;
            this.resetOrder();
        } else {
            int[] order = this.getOrder();
            for (int i = 0; i < order.length; ++i) {
                int oi = order[i];
                if (this.W[oi][tgt]) {
                    this.removeEdge(oi, tgt);
                }
                if (!this.W[tgt][oi]) continue;
                this.removeEdge(tgt, oi);
            }
        }
        if (!this.releaseVertex(tx)) {
            throw new AssertionError((Object)("Unknown vertex=" + tx));
        }
        if (DEBUG) {
            log.debug(this.toString());
        }
    }

    public static class Edge {
        public final Object src;
        final Object tgt;
        final boolean explicit;

        Edge(Object src, Object tgt, boolean explicit) {
            if (src == null || tgt == null || src == tgt) {
                throw new IllegalArgumentException();
            }
            this.src = src;
            this.tgt = tgt;
            this.explicit = explicit;
        }

        public String toString() {
            return "" + this.src + " -> " + this.tgt + (this.explicit ? "" : " (inferred)");
        }

        public Object getSource() {
            return this.src;
        }

        public Object getTarget() {
            return this.tgt;
        }

        public boolean isExplicit() {
            return this.explicit;
        }
    }
}

