/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.config;

import com.bigdata.config.ConfigurationException;
import com.bigdata.config.IValidator;
import com.bigdata.journal.IIndexManager;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IDataService;
import com.bigdata.util.NV;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;

public class Configuration {
    protected static final transient Logger log = Logger.getLogger(Configuration.class);
    public static final transient String NAMESPACE = "com.bigdata.namespace";
    public static final transient char DOT = '.';

    public static String getProperty(IIndexManager indexManagerIsIgnored, Properties properties, String namespace, String propertyName, String defaultValue) {
        NV nv = Configuration.getProperty2(indexManagerIsIgnored, properties, namespace, propertyName, defaultValue);
        if (nv == null) {
            return null;
        }
        return nv.getValue();
    }

    public static NV getProperty2(IIndexManager indexManagerIsIgnored, Properties properties, String namespace, String globalName, String defaultValue) {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        if (globalName == null) {
            throw new IllegalArgumentException();
        }
        String key = null;
        String val = null;
        String localName = globalName;
        if (namespace != null) {
            StringBuilder sb = new StringBuilder(NAMESPACE.length() + 1 + namespace.length() + 1 + localName.length());
            String prefix = namespace;
            while (prefix.length() > 0) {
                int lastIndexOf;
                sb.setLength(0);
                sb.append(NAMESPACE);
                sb.append('.');
                sb.append(prefix);
                sb.append('.');
                sb.append(localName);
                key = sb.toString();
                val = properties.getProperty(key);
                if (val != null) break;
                if (log.isDebugEnabled()) {
                    log.debug("No match: " + key);
                }
                if ((lastIndexOf = prefix.lastIndexOf(46)) == -1) break;
                prefix = prefix.substring(0, lastIndexOf);
            }
        }
        if (val == null && (val = properties.getProperty(key = globalName)) == null) {
            val = defaultValue;
        }
        if (log.isInfoEnabled()) {
            log.info(key + "=" + val);
        }
        return new NV(key, val);
    }

    public static <E> E getProperty(IIndexManager indexManager, Properties properties, String namespace, String globalName, String defaultValue, IValidator<E> validator) throws ConfigurationException {
        if (validator == null) {
            throw new IllegalArgumentException();
        }
        NV nv = Configuration.getProperty2(indexManager, properties, namespace, globalName, defaultValue);
        if (nv == null) {
            return null;
        }
        E e = validator.parse(nv.getName(), nv.getValue());
        validator.accept(nv.getName(), nv.getValue(), e);
        return e;
    }

    protected static UUID resolveDataService(IIndexManager indexManager, String val) {
        if (indexManager == null) {
            return null;
        }
        if (val == null) {
            throw new IllegalArgumentException();
        }
        if (!(indexManager instanceof IBigdataFederation)) {
            return null;
        }
        IBigdataFederation fed = (IBigdataFederation)indexManager;
        try {
            return UUID.fromString(val);
        }
        catch (IllegalArgumentException ex) {
            IDataService dataService = fed.getDataServiceByName(val);
            if (dataService != null) {
                try {
                    return dataService.getServiceUUID();
                }
                catch (IOException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            log.warn("Could not resolve: " + val);
            return null;
        }
    }

    public static String getOverrideProperty(String namespace, String property) {
        String override = "com.bigdata.namespace." + namespace + '.' + property;
        if (log.isInfoEnabled()) {
            log.info("namespace=" + namespace + ", property=" + property + ", override=" + override);
        }
        return override;
    }
}

