/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import com.bigdata.Banner;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.IStatisticsCollector;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.counters.httpd.CounterSetHTTPD;
import com.bigdata.counters.linux.StatisticsCollectorForLinux;
import com.bigdata.counters.osx.StatisticsCollectorForOSX;
import com.bigdata.counters.win.StatisticsCollectorForWindows;
import com.bigdata.io.DirectBufferPool;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.system.SystemUtil;

public abstract class AbstractStatisticsCollector
implements IStatisticsCollector {
    protected static final String ps = "/";
    protected static final Logger log = Logger.getLogger(AbstractStatisticsCollector.class);
    public static final String fullyQualifiedHostName = Banner.getFullyqualifiedhostname();
    public static final String hostPathPrefix = "/" + fullyQualifiedHostName + "/";
    protected final int interval;
    private final String processName;
    private CounterSet countersRoot;

    @Override
    public int getInterval() {
        return this.interval;
    }

    public String getProcessName() {
        return this.processName;
    }

    protected AbstractStatisticsCollector(int interval, String processName) {
        if (interval <= 0) {
            throw new IllegalArgumentException();
        }
        if (processName == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info("interval=" + interval);
        }
        this.interval = interval;
        this.processName = processName;
    }

    @Override
    public synchronized CounterSet getCounters() {
        if (this.countersRoot == null) {
            this.countersRoot = new CounterSet();
            this.countersRoot.addCounter(hostPathPrefix + "Info/Architecture", new OneShotInstrument<String>(System.getProperty("os.arch")));
            this.countersRoot.addCounter(hostPathPrefix + "Info/Operating System Name", new OneShotInstrument<String>(System.getProperty("os.name")));
            this.countersRoot.addCounter(hostPathPrefix + "Info/Operating System Version", new OneShotInstrument<String>(System.getProperty("os.version")));
            this.countersRoot.addCounter(hostPathPrefix + "Info/Number of Processors", new OneShotInstrument<Integer>(SystemUtil.numProcessors()));
            this.countersRoot.addCounter(hostPathPrefix + "Info/Processor Info", new OneShotInstrument<String>(SystemUtil.cpuInfo()));
        }
        return this.countersRoot;
    }

    public static void addBasicServiceOrClientCounters(CounterSet serviceRoot, String serviceName, Class serviceIface, Properties properties) {
        CounterSet serviceInfoSet = serviceRoot.makePath("Info");
        serviceInfoSet.addCounter("Service Type", new OneShotInstrument<String>(serviceIface.getName()));
        serviceInfoSet.addCounter("Service Name", new OneShotInstrument<String>(serviceName));
        AbstractStatisticsCollector.addServiceProperties(serviceInfoSet, properties);
        serviceRoot.attach(AbstractStatisticsCollector.getMemoryCounterSet());
    }

    public static CounterSet getMemoryCounterSet() {
        CounterSet serviceRoot = new CounterSet();
        serviceRoot.addCounter("Memory/Runtime Max Memory", new OneShotInstrument<Long>(Runtime.getRuntime().maxMemory()));
        serviceRoot.addCounter("Memory/Runtime Free Memory", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(Runtime.getRuntime().freeMemory());
            }
        });
        serviceRoot.addCounter("Memory/Runtime Total Memory", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(Runtime.getRuntime().totalMemory());
            }
        });
        AbstractStatisticsCollector.addGarbageCollectorMXBeanCounters(serviceRoot.makePath("Memory/Garbage Collectors"));
        AbstractStatisticsCollector.addMemoryPoolMXBeanCounters(serviceRoot.makePath("Memory/Memory Pools"));
        serviceRoot.makePath("Memory/DirectBufferPool").attach(DirectBufferPool.getCounters());
        return serviceRoot;
    }

    public static void addServiceProperties(CounterSet serviceInfoSet, Properties properties) {
        CounterSet ptmp = serviceInfoSet.makePath("Properties");
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String value;
            String name;
            try {
                name = (String)e.nextElement();
                value = properties.getProperty(name);
            }
            catch (ClassCastException ex) {
                log.warn(ex.getMessage());
                continue;
            }
            if (value == null) continue;
            ptmp.addCounter(name, new OneShotInstrument<String>(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGarbageCollectorMXBeanCounters(CounterSet counterSet) {
        String name_pools = "Memory Pool Names";
        String name_count = "Collection Count";
        String name_time = "Cumulative Collection Time";
        CounterSet counterSet2 = counterSet;
        synchronized (counterSet2) {
            List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
            for (final GarbageCollectorMXBean bean : list) {
                CounterSet tmp;
                String name = bean.getName();
                CounterSet counterSet3 = tmp = counterSet.makePath(name);
                synchronized (counterSet3) {
                    if (tmp.getChild("Memory Pool Names") == null) {
                        tmp.addCounter("Memory Pool Names", new Instrument<String>(){

                            @Override
                            protected void sample() {
                                this.setValue(Arrays.toString(bean.getMemoryPoolNames()));
                            }
                        });
                    }
                    if (tmp.getChild("Collection Count") == null) {
                        tmp.addCounter("Collection Count", new Instrument<Long>(){

                            @Override
                            protected void sample() {
                                this.setValue(bean.getCollectionCount());
                            }
                        });
                    }
                    if (tmp.getChild("Cumulative Collection Time") == null) {
                        tmp.addCounter("Cumulative Collection Time", new Instrument<Long>(){

                            @Override
                            protected void sample() {
                                this.setValue(bean.getCollectionTime());
                            }
                        });
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMemoryPoolMXBeanCounters(CounterSet counterSet) {
        String name_pool = "Memory Pool";
        String name_max = "Maximum Usage";
        String name_used = "Current Usage";
        CounterSet counterSet2 = counterSet;
        synchronized (counterSet2) {
            List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
            for (final MemoryPoolMXBean bean : list) {
                CounterSet tmp;
                String name = bean.getName();
                CounterSet counterSet3 = tmp = counterSet.makePath(name);
                synchronized (counterSet3) {
                    if (tmp.getChild("Memory Pool") == null) {
                        tmp.addCounter("Memory Pool", new Instrument<String>(){

                            @Override
                            protected void sample() {
                                this.setValue(bean.getName());
                            }
                        });
                    }
                    if (tmp.getChild("Maximum Usage") == null) {
                        tmp.addCounter("Maximum Usage", new Instrument<Long>(){

                            @Override
                            protected void sample() {
                                MemoryUsage u = bean.getUsage();
                                this.setValue(u.getMax());
                            }
                        });
                    }
                    if (tmp.getChild("Current Usage") == null) {
                        tmp.addCounter("Current Usage", new Instrument<Long>(){

                            @Override
                            protected void sample() {
                                MemoryUsage u = bean.getUsage();
                                this.setValue(u.getUsed());
                            }
                        });
                    }
                }
            }
        }
    }

    @Override
    public void start() {
        if (log.isInfoEnabled()) {
            log.info("Starting collection.");
        }
        this.installShutdownHook();
    }

    @Override
    public void stop() {
        if (log.isInfoEnabled()) {
            log.info("Stopping collection.");
        }
    }

    protected void installShutdownHook() {
        Thread t = new Thread(){

            @Override
            public void run() {
                AbstractStatisticsCollector.this.stop();
            }
        };
        t.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(t);
    }

    public static AbstractStatisticsCollector newInstance(Properties properties) {
        int interval = Integer.parseInt(properties.getProperty(Options.PERFORMANCE_COUNTERS_SAMPLE_INTERVAL, "60"));
        if (interval <= 0) {
            throw new IllegalArgumentException();
        }
        String processName = properties.getProperty(Options.PROCESS_NAME);
        if (processName == null) {
            throw new IllegalArgumentException("Required option not specified: " + Options.PROCESS_NAME);
        }
        if (SystemUtil.isLinux()) {
            return new StatisticsCollectorForLinux(interval, processName);
        }
        if (SystemUtil.isWindows()) {
            return new StatisticsCollectorForWindows(interval, processName);
        }
        if (SystemUtil.isOSX()) {
            return new StatisticsCollectorForOSX(interval, processName);
        }
        throw new UnsupportedOperationException("No implementation available on " + System.getProperty("os.getname"));
    }

    public static void main(String[] args) throws InterruptedException {
        int count;
        int interval;
        Banner.banner();
        int DEFAULT_COUNT = 10;
        int nargs = args.length;
        if (nargs == 0) {
            interval = Integer.parseInt("60");
            count = 10;
        } else if (nargs == 1) {
            interval = Integer.parseInt(args[0]);
            count = 10;
        } else if (nargs == 2) {
            interval = Integer.parseInt(args[0]);
            count = Integer.parseInt(args[1]);
        } else {
            throw new RuntimeException("usage: [interval [count]]");
        }
        if (interval <= 0) {
            throw new RuntimeException("interval must be positive");
        }
        if (count < 0) {
            throw new RuntimeException("count must be non-negative");
        }
        Properties properties = new Properties(System.getProperties());
        if (nargs != 0) {
            properties.setProperty(Options.PERFORMANCE_COUNTERS_SAMPLE_INTERVAL, "" + interval);
        }
        if (properties.getProperty(Options.PROCESS_NAME) == null) {
            properties.setProperty(Options.PROCESS_NAME, "testService");
        }
        AbstractStatisticsCollector client = AbstractStatisticsCollector.newInstance(properties);
        CounterSet counterSet = client.getCounters();
        counterSet.attach(AbstractStatisticsCollector.getMemoryCounterSet());
        System.out.println(counterSet.toString());
        System.err.println("Starting performance counter collection: interval=" + client.interval + ", count=" + count);
        client.start();
        CounterSetHTTPD httpd = null;
        int port = 9999;
        try {
            httpd = new CounterSetHTTPD(9999, client);
        }
        catch (IOException e) {
            log.warn("Could not start httpd: port=9999 : " + e);
        }
        long begin = System.currentTimeMillis();
        for (int n = 0; count == 0 || n < count; ++n) {
            Thread.sleep(client.interval * 1000);
            long elapsed = System.currentTimeMillis() - begin;
            System.err.println("Report #" + n + " after " + elapsed / 1000L + " seconds ");
            System.out.println(client.getCounters().toString());
        }
        System.err.println("Stopping performance counter collection");
        client.stop();
        if (httpd != null) {
            httpd.shutdown();
        }
        System.err.println("Done");
    }

    public static Double kb2b(String kb) {
        double d = Double.parseDouble(kb);
        double x = d * 1024.0;
        return x;
    }

    static {
        if (log.isInfoEnabled()) {
            log.info("FQDN      : " + fullyQualifiedHostName);
            log.info("hostPrefix: " + hostPathPrefix);
        }
    }

    public static interface Options {
        public static final String PERFORMANCE_COUNTERS_SAMPLE_INTERVAL = AbstractStatisticsCollector.class.getPackage().getName() + ".interval";
        public static final String DEFAULT_PERFORMANCE_COUNTERS_SAMPLE_INTERVAL = "60";
        public static final String PROCESS_NAME = AbstractStatisticsCollector.class.getPackage().getName() + ".processName";
    }
}

