/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import com.bigdata.counters.AbstractCounterSet;
import com.bigdata.counters.Counter;
import com.bigdata.counters.ICounter;
import com.bigdata.counters.ICounterNode;
import com.bigdata.counters.ICounterSet;
import com.bigdata.counters.IInstrument;
import com.bigdata.counters.XMLUtility;
import com.bigdata.util.StackInfoReport;
import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.SingleValueIterator;
import cutthecrap.utils.striterators.Sorter;
import cutthecrap.utils.striterators.Striterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class CounterSet
extends AbstractCounterSet
implements ICounterSet {
    private static final Logger log = Logger.getLogger(CounterSet.class);
    private final Map<String, ICounterNode> children = new ConcurrentHashMap<String, ICounterNode>();

    public CounterSet() {
        this("", null);
    }

    private CounterSet(String name, CounterSet parent) {
        super(name, parent);
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public synchronized void attach(ICounterNode src) {
        this.attach(src, false);
    }

    public synchronized void attach(ICounterNode src, boolean replace) {
        if (src.isRoot()) {
            Iterator<ICounterNode> itr = ((CounterSet)src).children.values().iterator();
            while (itr.hasNext()) {
                this.attach2(itr.next(), replace);
            }
        } else {
            this.attach2(src, replace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attach2(ICounterNode src, boolean replace) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (this.children.containsKey(src.getName())) {
            ICounterNode existingChild = this.getChild(src.getName());
            if (existingChild.isCounter() && !replace) {
                if (log.isInfoEnabled()) {
                    log.info("Will not replace existing counter: " + existingChild.getPath());
                }
                return;
            }
            if (src.isCounterSet()) {
                Iterator<ICounterNode> itr = ((CounterSet)src).children.values().iterator();
                while (itr.hasNext()) {
                    ((CounterSet)existingChild).attach2(itr.next(), replace);
                }
                return;
            }
        }
        ICounterNode iCounterNode = src;
        synchronized (iCounterNode) {
            String name = src.getName();
            CounterSet oldParent = (CounterSet)src.getParent();
            assert (oldParent != null);
            if (oldParent.children.remove(name) == null) {
                throw new AssertionError();
            }
            if (src.isCounterSet()) {
                ((CounterSet)src).parent = this;
            } else {
                ((Counter)src).parent = this;
            }
            this.children.put(name, src);
        }
    }

    public synchronized ICounterNode detach(String path) {
        ICounterNode node = this.getPath(path);
        if (node != null && !node.isRoot()) {
            CounterSet p = (CounterSet)node.getParent();
            p.children.remove(node.getName());
            if (node.isCounterSet()) {
                ((CounterSet)node).parent = null;
            } else {
                ((Counter)node).parent = null;
            }
        }
        return node;
    }

    public Iterator<ICounter> counterIterator(final Pattern filter) {
        Striterator src = new Striterator(this.directChildIterator(true, ICounter.class));
        if (filter != null) {
            src.addFilter(new Filter(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isValid(Object val) {
                    ICounter counter = (ICounter)val;
                    String path = counter.getPath();
                    Matcher matcher = filter.matcher(path);
                    boolean matched = matcher.matches();
                    return matched;
                }
            });
        }
        return src;
    }

    public Iterator<ICounterNode> getNodes(final Pattern filter) {
        IStriterator src = ((IStriterator)this.postOrderIterator()).addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator expand(Object val) {
                CounterSet c = (CounterSet)val;
                return new Striterator(new SingleValueIterator<CounterSet>(c)).append(c.counterIterator(filter));
            }
        });
        return src;
    }

    @Override
    public Iterator<ICounter> getCounters(final Pattern filter) {
        IStriterator src = ((IStriterator)this.postOrderIterator()).addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator expand(Object val) {
                CounterSet c = (CounterSet)val;
                return c.counterIterator(filter);
            }
        });
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator directChildIterator(boolean sorted, Class<? extends ICounterNode> type) {
        ICounterNode[] a;
        CounterSet counterSet = this;
        synchronized (counterSet) {
            a = this.children.values().toArray(new ICounterNode[0]);
        }
        Striterator itr = new Striterator(Arrays.asList(a).iterator());
        if (type != null) {
            itr.addTypeFilter(type);
        }
        if (sorted) {
            itr.addFilter(new Sorter(){
                private static final long serialVersionUID = 1L;

                @Override
                public int compare(Object arg0, Object arg1) {
                    return ((ICounterNode)arg0).getName().compareTo(((ICounterNode)arg1).getName());
                }
            });
        }
        return itr;
    }

    public Iterator<ICounterSet> counterSetIterator() {
        return this.directChildIterator(true, ICounterSet.class);
    }

    public Iterator postOrderIterator() {
        return new Striterator(this.postOrderIterator1()).append(new SingleValueIterator<CounterSet>(this));
    }

    public Iterator preOrderIterator() {
        return new Striterator(new SingleValueIterator<CounterSet>(this)).append(this.preOrderIterator1());
    }

    private Iterator<ICounterSet> preOrderIterator1() {
        return new Striterator(this.counterSetIterator()).addTypeFilter(ICounterSet.class).addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator expand(Object childObj) {
                ICounterSet child = (ICounterSet)childObj;
                Striterator itr = new Striterator(new SingleValueIterator<ICounterSet>(child));
                itr.append(((CounterSet)child).preOrderIterator1());
                return itr;
            }
        });
    }

    private Iterator<ICounterSet> postOrderIterator1() {
        return new Striterator(this.counterSetIterator()).addTypeFilter(ICounterSet.class).addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator expand(Object childObj) {
                ICounterSet child = (ICounterSet)childObj;
                Striterator itr = new Striterator(((CounterSet)child).postOrderIterator1());
                itr.append(new SingleValueIterator<ICounterSet>(child));
                return itr;
            }
        });
    }

    @Override
    public ICounterNode getChild(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.children.get(name);
    }

    @Override
    public synchronized CounterSet makePath(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (path.equals("/")) {
            return (CounterSet)this.getRoot();
        }
        if (path.contains("//")) {
            throw new IllegalArgumentException(path);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
            if (this.parent != null) {
                return (CounterSet)this.getRoot().makePath(path);
            }
        }
        String[] a = path.split("/");
        CounterSet p = this;
        for (int i = 0; i < a.length; ++i) {
            String name = a[i];
            ICounterNode t = p.getChild(name);
            if (t == null) {
                t = new CounterSet(name, p);
                p.children.put(name, t);
            } else if (t instanceof ICounter) {
                throw new IllegalArgumentException("path identifies a counter");
            }
            p = (CounterSet)t;
        }
        return p;
    }

    public synchronized ICounter addCounter(String path, IInstrument instrument) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        int indexOf = path.lastIndexOf("/");
        if (indexOf == -1) {
            return this.addCounter2(path, instrument);
        }
        String name = path.substring(indexOf + 1, path.length());
        String ppath = path.substring(0, indexOf);
        CounterSet parent = this.makePath(ppath);
        return parent.addCounter2(name, instrument);
    }

    private ICounter addCounter2(String name, IInstrument instrument) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (instrument == null) {
            throw new IllegalArgumentException();
        }
        Counter counter = this.children.get(name);
        if (counter != null) {
            if (counter instanceof ICounter) {
                log.error(new StackInfoReport("Exists: path=" + this.getPath() + ", name=" + name));
                return counter;
            }
            throw new IllegalStateException("Node exists: path=" + this.getPath() + ", name=" + name);
        }
        counter = new Counter(this, name, instrument);
        if (log.isInfoEnabled()) {
            log.info("parent=" + this.getPath() + ", name=" + name);
        }
        this.children.put(name, counter);
        return counter;
    }

    @Override
    public void asXML(Writer w, Pattern filter) throws IOException {
        XMLUtility.INSTANCE.writeXML(this, w, filter);
    }

    @Override
    public void readXML(InputStream is, ICounterSet.IInstrumentFactory instrumentFactory, Pattern filter) throws IOException, ParserConfigurationException, SAXException {
        XMLUtility.INSTANCE.readXML(this, is, instrumentFactory, filter);
    }
}

