/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import com.bigdata.counters.History;
import com.bigdata.counters.IHistoryEntry;
import com.bigdata.counters.IInstrument;
import com.bigdata.counters.PeriodEnum;
import org.apache.log4j.Logger;

public class HistoryInstrument<T>
implements IInstrument<T> {
    protected static Logger log = Logger.getLogger(HistoryInstrument.class);
    public final History<T> minutes;
    public final History<T> hours;
    public final History<T> days;

    public History<T> getHistory() {
        return this.minutes;
    }

    public History<T> getHistory(PeriodEnum basePeriod) {
        switch (basePeriod) {
            case Minutes: {
                return this.minutes;
            }
            case Hours: {
                return this.hours;
            }
            case Days: {
                return this.days;
            }
        }
        throw new AssertionError();
    }

    public HistoryInstrument(History<T> minutes) {
        if (minutes == null) {
            throw new IllegalArgumentException();
        }
        this.minutes = minutes;
        if (minutes.getSink() != null) {
            this.hours = minutes.getSink();
            this.days = this.hours.getSink() != null ? this.hours.getSink() : null;
        } else {
            this.days = null;
            this.hours = null;
        }
    }

    @Override
    public T getValue() {
        IHistoryEntry<T> sample = this.minutes.getSample();
        if (sample == null) {
            return null;
        }
        return sample.getValue();
    }

    @Override
    public long lastModified() {
        IHistoryEntry<T> sample = this.minutes.getSample();
        if (sample == null) {
            return -1L;
        }
        return sample.lastModified();
    }

    public void add(long timestamp, T value) {
        if (log.isInfoEnabled()) {
            log.info("timestamp=" + timestamp + ", value=" + value);
        }
        this.minutes.add(timestamp, value);
    }

    @Override
    public void setValue(T value, long timestamp) {
        this.add(timestamp, value);
    }

    public String toString() {
        return this.minutes.toString();
    }
}

