/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import com.bigdata.counters.IInstrument;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class Instrument<T>
implements IInstrument<T> {
    protected static Logger log = Logger.getLogger(Instrument.class);
    protected static final transient String NA = "N/A";
    protected T value;
    protected long lastModified;

    public final String nanosToPerSec(long counter, long nanos) {
        long secs = TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS);
        if (secs == 0L) {
            return NA;
        }
        return "" + counter / secs;
    }

    protected abstract void sample();

    public final void setValue(T value) {
        this.setValue(value, System.currentTimeMillis());
    }

    @Override
    public final void setValue(T value, long timestamp) {
        if (log.isInfoEnabled()) {
            log.info("value=" + value + ", timestamp=" + timestamp);
        }
        this.value = value;
        this.lastModified = timestamp;
    }

    @Override
    public final T getValue() {
        this.sample();
        return this.value;
    }

    public T getCurrentValue() {
        return this.value;
    }

    @Override
    public final long lastModified() {
        return this.lastModified;
    }
}

