/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.system.SystemUtil;

public class PIDUtil {
    private static final Logger log = Logger.getLogger(PIDUtil.class);
    private static final Pattern pidPattern = Pattern.compile("^([0-9]+)@");

    public static int getLinuxPIDWithBash() {
        Process pr;
        LinkedList<String> commands = new LinkedList<String>();
        try {
            commands.add("/bin/bash");
            commands.add("-c");
            commands.add("echo $PPID");
            ProcessBuilder pb = new ProcessBuilder(commands);
            pr = pb.start();
            pr.waitFor();
        }
        catch (Exception ex) {
            throw new RuntimeException("Problem running command: [" + commands + "]", ex);
        }
        if (pr.exitValue() == 0) {
            String val;
            BufferedReader outReader = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            try {
                val = outReader.readLine();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                try {
                    outReader.close();
                }
                catch (IOException ex) {
                    log.error(ex, ex);
                }
            }
            if (val == null) {
                throw new RuntimeException("Nothing read.");
            }
            if (log.isInfoEnabled()) {
                log.info("read: [" + val + "]");
            }
            int pid = Integer.parseInt(val.trim());
            return pid;
        }
        throw new RuntimeException("Could not get PID: exitValue=" + pr.exitValue());
    }

    public static int getPIDWithRuntimeMXBean() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        Matcher matcher = pidPattern.matcher(name);
        if (!matcher.find()) {
            throw new UnsupportedOperationException("Could not extract pid from [" + name + "]");
        }
        int pid = Integer.parseInt(matcher.group(1));
        if (log.isInfoEnabled()) {
            log.info("pid=" + pid);
        }
        return pid;
    }

    public static int getPID() {
        try {
            if (!SystemUtil.operatingSystem().toLowerCase().startsWith("win")) {
                return PIDUtil.getLinuxPIDWithBash();
            }
        }
        catch (Throwable t) {
            log.warn(t);
        }
        return PIDUtil.getPIDWithRuntimeMXBean();
    }

    public static void main(String[] args) throws InterruptedException {
        System.out.println("pid=" + PIDUtil.getPID());
        Thread.sleep(5000L);
    }
}

