/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import com.bigdata.counters.AbstractCounterSet;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.History;
import com.bigdata.counters.HistoryInstrument;
import com.bigdata.counters.ICounter;
import com.bigdata.counters.ICounterNode;
import com.bigdata.counters.ICounterSet;
import com.bigdata.counters.IInstrument;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.util.HTMLUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtility {
    protected static final Logger log = Logger.getLogger(XMLUtility.class);
    public static final XMLUtility INSTANCE = new XMLUtility();
    private static final transient String NAMESPACE_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final transient String xsd = "xs:";
    private static final transient String xsd_anyType = "xs:anyType";
    private static final transient String xsd_long = "xs:long";
    private static final transient String xsd_int = "xs:int";
    private static final transient String xsd_double = "xs:double";
    private static final transient String xsd_float = "xs:float";
    private static final transient String xsd_string = "xs:string";
    private static final transient String xsd_boolean = "xs:boolean";

    private XMLUtility() {
    }

    public void writeXML(CounterSet root, Writer w, Pattern filter) throws IOException {
        w.write("<counters");
        w.write(" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"");
        w.write("\n>");
        Iterator itr = root.postOrderIterator();
        while (itr.hasNext()) {
            CounterSet counterSet = (CounterSet)itr.next();
            Iterator<ICounter> itr2 = counterSet.counterIterator(filter);
            if (!itr2.hasNext()) continue;
            w.write("<cs");
            w.write(" path=\"" + counterSet.getPath() + "\"");
            w.write("\n>");
            while (itr2.hasNext()) {
                Object value;
                ICounter counter = itr2.next();
                String name = counter.getName();
                try {
                    value = counter.getValue();
                }
                catch (Throwable t) {
                    log.error("Could not read counter value (skipped): " + counter.getPath(), t);
                    continue;
                }
                long time = counter.lastModified();
                if (time == 0L || value == null) {
                    if (!log.isInfoEnabled()) continue;
                    log.info("Ignoring counter: name=" + name + ", timestamp=" + time + ", value=" + value);
                    continue;
                }
                String type = this.getXSDType(value);
                if (time < 0L) {
                    log.warn("Ignoring counter with invalid timestamp: name=" + name + ", timestamp=" + time + ", value=" + value);
                    continue;
                }
                w.write("<c");
                w.write(" name=\"" + name + "\"");
                w.write(" type=\"" + type + "\"");
                w.write(" time=\"" + time + "\"");
                w.write(" value=\"" + HTMLUtility.escapeForXHTML(value.toString()) + "\"");
                w.write(">");
                if (counter.getInstrument() instanceof HistoryInstrument) {
                    HistoryInstrument inst = (HistoryInstrument)counter.getInstrument();
                    this.writeHistory(w, inst.getHistory(), "minutes");
                }
                w.write("</c\n>");
            }
            w.write("</cs\n>");
        }
        w.write("</counters\n>");
        w.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHistory(Writer w, History h, String units) throws IOException {
        History history = h;
        synchronized (history) {
            w.write("<h");
            w.write(" units=\"" + units + "\"");
            w.write("\n>");
            History.SampleIterator itr = h.iterator();
            while (itr.hasNext()) {
                Object entry = itr.next();
                w.write("<v");
                w.write(" time=\"" + entry.lastModified() + "\"");
                w.write(" value=\"" + HTMLUtility.escapeForXHTML(entry.getValue().toString()) + "\"");
                w.write("></v\n>");
            }
            w.write("</h\n>");
        }
    }

    public void readXML(CounterSet root, InputStream is, ICounterSet.IInstrumentFactory instrumentFactory, Pattern filter) throws IOException, ParserConfigurationException, SAXException {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        if (instrumentFactory == null) {
            throw new IllegalArgumentException();
        }
        SAXParserFactory f = SAXParserFactory.newInstance();
        f.setNamespaceAware(true);
        SAXParser p = f.newSAXParser();
        MyHandler handler = new MyHandler(root, instrumentFactory, filter);
        p.parse(is, (DefaultHandler)handler);
    }

    private String getXSDType(Object value) {
        if (value == null) {
            return xsd_anyType;
        }
        Class<?> c = value.getClass();
        if (c.equals(Long.class)) {
            return xsd_long;
        }
        if (c.equals(Integer.class)) {
            return xsd_int;
        }
        if (c.equals(Double.class)) {
            return xsd_double;
        }
        if (c.equals(Float.class)) {
            return xsd_float;
        }
        if (c.equals(String.class)) {
            return xsd_string;
        }
        if (c.equals(Boolean.class)) {
            return xsd_boolean;
        }
        return xsd_anyType;
    }

    private static class MyHandler
    extends DefaultHandler {
        protected static final Logger log = Logger.getLogger(MyHandler.class);
        private final AbstractCounterSet root;
        private final ICounterSet.IInstrumentFactory instrumentFactory;
        private final Pattern filter;
        private String path;
        private ICounter counter;
        private History history;
        private final String cs = "cs";
        private final String c = "c";
        private final String h = "h";
        private final String v = "v";
        private StringBuilder cdata = new StringBuilder();

        public MyHandler(AbstractCounterSet root, ICounterSet.IInstrumentFactory instrumentFactory, Pattern filter) {
            if (root == null) {
                throw new IllegalArgumentException();
            }
            if (instrumentFactory == null) {
                throw new IllegalArgumentException();
            }
            this.root = root;
            this.instrumentFactory = instrumentFactory;
            this.filter = filter;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (log.isDebugEnabled()) {
                log.debug("uri=" + uri + ",localName=" + localName + ", qName=" + qName);
            }
            if (qName.equals("counters")) return;
            if (qName.equals("cs")) {
                this.path = attributes.getValue("path");
                if (!log.isInfoEnabled()) return;
                log.info("path=" + this.path);
                return;
            } else if (qName.equals("c")) {
                Class typ;
                ICounter counter;
                String fqn;
                String name = attributes.getValue("name");
                if (this.filter != null && !this.filter.matcher(fqn = this.path + "/" + name).matches()) {
                    if (log.isInfoEnabled()) {
                        log.info("Does not match filter: " + fqn);
                    }
                    this.counter = null;
                    return;
                }
                String type = attributes.getValue("type");
                long time = Long.parseLong(attributes.getValue("time"));
                String value = attributes.getValue("value");
                if (log.isInfoEnabled()) {
                    log.info("path=" + this.path + ", name=" + name + ", type=" + type + ", value=" + value + ", time=" + time);
                }
                if ((counter = this.getCounter(this.path, name, typ = MyHandler.getType(type))) == null) {
                    log.warn("Conflict: path=" + this.path + ", name=" + name);
                } else {
                    MyHandler.setValue(counter, typ, value, time);
                }
                this.counter = counter;
                this.history = null;
                return;
            } else if (qName.equals("h")) {
                this.history = null;
                if (this.counter == null) {
                    return;
                }
                if (!(this.counter.getInstrument() instanceof HistoryInstrument)) {
                    log.warn("Ignoring history: inst=" + this.counter.getInstrument().getClass().getName() + ", path" + this.counter);
                    return;
                }
                HistoryInstrument inst = (HistoryInstrument)this.counter.getInstrument();
                String units = attributes.getValue("units");
                if (units == null) {
                    throw new SAXException("No units");
                }
                if (units.equals("minutes")) {
                    this.history = inst.minutes;
                    return;
                } else if (units.equals("hours")) {
                    this.history = inst.hours;
                    return;
                } else {
                    if (!units.equals("days")) throw new SAXException("Bad units: " + units);
                    this.history = inst.days;
                }
                return;
            } else {
                if (!qName.equals("v")) throw new SAXException("Unknown start tag: " + qName);
                if (this.counter == null || this.history == null) {
                    return;
                }
                long time = Long.parseLong(attributes.getValue("time"));
                String value = attributes.getValue("value");
                if (log.isInfoEnabled()) {
                    log.info("counter=" + this.counter + ", time=" + time + ", value=" + value);
                }
                MyHandler.addValue(this.history, time, value);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.cdata.append(ch, start, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.cdata.setLength(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ICounter getCounter(String path, String name, Class typ) {
            ICounter counter;
            AbstractCounterSet abstractCounterSet = this.root;
            synchronized (abstractCounterSet) {
                ICounterNode node = this.root.getPath(path.equals("/") ? name : path + "/" + name);
                if (node == null) {
                    IInstrument inst = this.instrumentFactory.newInstance(typ);
                    counter = ((CounterSet)this.root.makePath(path)).addCounter(name, inst);
                } else if (node.isCounter()) {
                    counter = (ICounter)node;
                } else {
                    return null;
                }
            }
            return counter;
        }

        protected static Class getType(String type) {
            String localType = type.substring(type.lastIndexOf("#") + 1);
            Class typ = localType.equals(XMLUtility.xsd_int) || localType.equals(XMLUtility.xsd_long) ? Long.class : (localType.equals(XMLUtility.xsd_float) || localType.equals(XMLUtility.xsd_double) ? Double.class : String.class);
            return typ;
        }

        protected static void setValue(ICounter counter, Class typ, String text, long time) {
            IInstrument inst = counter.getInstrument();
            if (inst instanceof OneShotInstrument) {
                log.warn(OneShotInstrument.class.getName() + " : ignoring update: path=" + counter.getPath() + ", value=" + text);
                return;
            }
            try {
                if (typ == Long.class) {
                    counter.setValue(Long.parseLong(text), time);
                } else if (typ == Double.class) {
                    counter.setValue(Double.parseDouble(text), time);
                } else {
                    counter.setValue(text, time);
                }
            }
            catch (Exception ex) {
                log.warn("Could not set counter value: path=" + counter.getPath() + " : " + ex, ex);
            }
        }

        protected static void addValue(History history, long time, String text) {
            Class typ = history.getValueType();
            if (typ == Long.class) {
                history.add(time, Long.parseLong(text));
            } else if (typ == Double.class) {
                history.add(time, Double.parseDouble(text));
            } else {
                history.add(time, text);
            }
        }
    }
}

