/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.ganglia;

import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounter;
import com.bigdata.ganglia.GangliaMunge;
import com.bigdata.ganglia.IGangliaMetricsCollector;
import com.bigdata.ganglia.IGangliaMetricsReporter;
import java.util.Iterator;
import java.util.regex.Pattern;

public class ServiceMetricsCollector
implements IGangliaMetricsCollector {
    protected final AbstractStatisticsCollector statisticsCollector;
    protected final Pattern filter;

    public ServiceMetricsCollector(AbstractStatisticsCollector statisticsCollector, Pattern filter) {
        if (statisticsCollector == null) {
            throw new IllegalArgumentException();
        }
        this.statisticsCollector = statisticsCollector;
        this.filter = filter;
    }

    @Override
    public void collect(IGangliaMetricsReporter reporter) {
        String basePrefix = "/" + AbstractStatisticsCollector.fullyQualifiedHostName + "/";
        String pathPrefix = basePrefix + this.statisticsCollector.getProcessName();
        CounterSet counters = (CounterSet)this.statisticsCollector.getCounters().getPath(pathPrefix);
        Iterator<ICounter> itr = counters.getCounters(this.filter);
        while (itr.hasNext()) {
            ICounter c = itr.next();
            Object value = c.getInstrument().getValue();
            String path = c.getPath();
            String s = path.substring(basePrefix.length());
            String metricName = GangliaMunge.munge(s).replace('/', '.');
            reporter.setMetric(metricName, value);
        }
    }
}

