/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.httpd;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.query.CounterSetSelector;
import com.bigdata.counters.query.URLQueryModel;
import com.bigdata.counters.render.IRenderer;
import com.bigdata.counters.render.RendererFactory;
import com.bigdata.service.IService;
import com.bigdata.util.httpd.AbstractHTTPD;
import com.bigdata.util.httpd.NanoHTTPD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CounterSetHTTPD
extends AbstractHTTPD {
    private static final Logger log = Logger.getLogger(CounterSetHTTPD.class);
    private final ICounterSetAccess accessor;
    private final IService service;
    private final long minUpdateLatency = 5000L;
    private volatile CounterSet counterSet = null;
    private volatile long lastTimestamp = 0L;
    private final Map<String, DeclaredResource> allowedClassPathResources;

    protected final IService getService() {
        return this.service;
    }

    public CounterSetHTTPD(int port, ICounterSetAccess accessor) throws IOException {
        this(port, accessor, null);
    }

    public CounterSetHTTPD(int port, ICounterSetAccess accessor, IService service) throws IOException {
        super(port);
        if (accessor == null) {
            throw new IllegalArgumentException();
        }
        this.accessor = accessor;
        this.service = service;
        HashMap<String, DeclaredResource> map = new HashMap<String, DeclaredResource>();
        map.put("/jquery.js", new DeclaredResource("jquery.js", "text/javascript; charset='UTF-8'"));
        map.put("/jquery.flot.js", new DeclaredResource("jquery.flot.js", "text/javascript; charset='UTF-8'"));
        map.put("/excanvas.pack.js", new DeclaredResource("excanvas.pack.js", "text/javascript; charset='UTF-8'"));
        this.allowedClassPathResources = Collections.unmodifiableMap(Collections.synchronizedMap(map));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NanoHTTPD.Response doGet(NanoHTTPD.Request req) throws Exception {
        CounterSetSelector counterSelector;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        String charset = "UTF-8";
        DeclaredResource decl = this.allowedClassPathResources.get(req.uri);
        if (decl != null) {
            return this.sendClasspathResource(decl);
        }
        CounterSetHTTPD counterSetHTTPD = this;
        synchronized (counterSetHTTPD) {
            long now = System.currentTimeMillis();
            long elapsed = now - this.lastTimestamp;
            if (this.counterSet == null || elapsed > 5000L) {
                this.counterSet = this.accessor.getCounters();
            }
            counterSelector = new CounterSetSelector(this.counterSet);
        }
        String mimeType = "text/html";
        URLQueryModel model = URLQueryModel.getInstance(this.getService(), req.uri, req.params, req.headers);
        IRenderer renderer = RendererFactory.get(model, counterSelector, "text/html");
        OutputStreamWriter w = new OutputStreamWriter(baos);
        renderer.render(w);
        w.flush();
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        NanoHTTPD.Response r = new NanoHTTPD.Response("200 OK", "text/html; charset='UTF-8'", is);
        r.addHeader("Cache-Control", "max-age=60, must-revalidate, public");
        return r;
    }

    private final NanoHTTPD.Response sendClasspathResource(DeclaredResource decl) throws IOException {
        if (decl == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info("Serving: " + decl.localResource + " as " + decl.mimeType);
        }
        NanoHTTPD.Response r = new NanoHTTPD.Response("200 OK", decl.mimeType, decl.getInputStream());
        return r;
    }

    private static class DeclaredResource {
        final String localResource;
        final String mimeType;

        public DeclaredResource(String localResource, String mimeType) throws IOException {
            this.localResource = localResource;
            this.mimeType = mimeType;
            if (localResource == null) {
                throw new IllegalArgumentException();
            }
            if (mimeType == null) {
                throw new IllegalArgumentException();
            }
            InputStream is = this.getInputStream();
            is.close();
        }

        public InputStream getInputStream() throws IOException {
            InputStream is = this.getClass().getResourceAsStream(this.localResource);
            if (is == null) {
                throw new IOException("Resource not on classpath: " + this.localResource);
            }
            return is;
        }
    }
}

