/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.httpd;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.PeriodEnum;
import com.bigdata.counters.httpd.CounterSetHTTPD;
import com.bigdata.counters.httpd.DummyEventReportingService;
import com.bigdata.counters.query.QueryUtil;
import com.bigdata.counters.render.XHTMLRenderer;
import com.bigdata.service.IService;
import com.bigdata.util.InnerCause;
import com.bigdata.util.httpd.AbstractHTTPD;
import com.bigdata.util.httpd.NanoHTTPD;
import java.io.File;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class CounterSetHTTPDServer
implements Runnable {
    protected static final transient Logger log = Logger.getLogger(NanoHTTPD.class);
    private AbstractHTTPD httpd;

    public static void main(String[] args) throws Exception {
        int port = 9999;
        int unitsToRetain = 1000;
        PeriodEnum unit = PeriodEnum.Minutes;
        final CounterSet counterSet = new CounterSet();
        ICounterSetAccess access = new ICounterSetAccess(){

            @Override
            public CounterSet getCounters() {
                return counterSet;
            }
        };
        DummyEventReportingService service = new DummyEventReportingService();
        LinkedList<String> filter = new LinkedList<String>();
        LinkedList<String> regex = new LinkedList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if (arg.equals("-p")) {
                    port = Integer.parseInt(args[++i]);
                    System.out.println("port: " + port);
                    continue;
                }
                if (arg.equals("-d")) {
                    Level level = Level.toLevel(args[++i]);
                    System.out.println("Setting server and service log levels: " + level);
                    try {
                        log.setLevel(level);
                        Logger.getLogger(XHTMLRenderer.class).setLevel(level);
                        Logger.getLogger(NanoHTTPD.class).setLevel(level);
                        continue;
                    }
                    catch (Throwable t) {
                        if (InnerCause.isInnerCause(t, NoSuchMethodException.class)) {
                            log.error("Could not set log level : " + AbstractBTree.dumpLog.getName());
                            continue;
                        }
                        throw new RuntimeException(t);
                    }
                }
                if (arg.equals("-events")) {
                    QueryUtil.readEvents(service, new File(args[++i]));
                    continue;
                }
                if (arg.equals("-filter")) {
                    filter.add(args[++i]);
                    continue;
                }
                if (arg.equals("-regex")) {
                    regex.add(args[++i]);
                    continue;
                }
                System.err.println("Unknown option: " + arg);
                System.exit(1);
                continue;
            }
            Pattern pattern = QueryUtil.getPattern(filter, regex);
            QueryUtil.readCountersFromFile(new File(arg), counterSet, pattern, 1000, unit);
        }
        System.out.println("Starting httpd server on port=" + port);
        CounterSetHTTPDServer server = new CounterSetHTTPDServer(port, access, service);
        server.run();
    }

    public CounterSetHTTPDServer(int port, ICounterSetAccess counterSet, IService service) throws Exception {
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
        this.httpd = new CounterSetHTTPD(port, counterSet, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object keepAlive;
        Object object = keepAlive = new Object();
        synchronized (object) {
            try {
                keepAlive.wait();
            }
            catch (InterruptedException ex) {
                if (log.isInfoEnabled()) {
                    log.info(ex);
                }
            }
            finally {
                this.shutdownNow();
            }
        }
    }

    public synchronized void shutdownNow() {
        if (log.isInfoEnabled()) {
            log.info("begin");
        }
        if (this.httpd != null) {
            this.httpd.shutdownNow();
            this.httpd = null;
        }
        if (log.isInfoEnabled()) {
            log.info("done");
        }
    }

    static class ShutdownThread
    extends Thread {
        final CounterSetHTTPDServer server;

        public ShutdownThread(CounterSetHTTPDServer httpd) {
            if (httpd == null) {
                throw new IllegalArgumentException();
            }
            this.server = httpd;
        }

        @Override
        public void run() {
            try {
                if (log.isInfoEnabled()) {
                    log.info("Running shutdown.");
                }
                this.server.shutdownNow();
            }
            catch (Exception ex) {
                log.error("While shutting down service: " + ex, ex);
            }
        }
    }
}

