/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.linux;

import com.bigdata.counters.AbstractProcessCollector;
import com.bigdata.counters.AbstractProcessReader;
import com.bigdata.counters.ActiveProcess;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterHierarchy;
import com.bigdata.counters.IInstrument;
import com.bigdata.counters.IProcessCounters;
import com.bigdata.counters.ProcessReaderHelper;
import com.bigdata.counters.linux.KernelVersion;
import com.bigdata.counters.linux.SysstatUtil;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class PIDStatCollector
extends AbstractProcessCollector
implements ICounterHierarchy,
IProcessCounters {
    protected final int pid;
    protected final boolean perProcessIOData;
    private final AtomicLong lastModified = new AtomicLong(System.currentTimeMillis());
    private final Map<String, Object> vals = new ConcurrentHashMap<String, Object>();

    public PIDStatCollector(int pid, int interval, KernelVersion kernelVersion) {
        super(interval);
        if (interval <= 0) {
            throw new IllegalArgumentException();
        }
        if (kernelVersion == null) {
            throw new IllegalArgumentException();
        }
        this.pid = pid;
        this.perProcessIOData = kernelVersion.version > 2 || kernelVersion.version == 2 && kernelVersion.major >= 6 && kernelVersion.minor >= 20;
    }

    @Override
    public List<String> getCommand() {
        LinkedList<String> command = new LinkedList<String>();
        command.add(SysstatUtil.getPath("pidstat").getPath());
        command.add("-p");
        command.add("" + this.pid);
        command.add("-u");
        command.add("-I");
        if (this.perProcessIOData) {
            command.add("-d");
        }
        command.add("-r");
        command.add("" + this.getInterval());
        return command;
    }

    @Override
    public CounterSet getCounters() {
        LinkedList<AbstractInst> inst = new LinkedList<AbstractInst>();
        inst.add(new ID("CPU/% User Time", 0.01));
        inst.add(new ID("CPU/% System Time", 0.01));
        inst.add(new ID("CPU/% Processor Time", 0.01));
        inst.add(new ID("Memory/Minor Faults per Second", 1.0));
        inst.add(new ID("Memory/Major Faults per Second", 1.0));
        inst.add(new IL("Memory/Virtual Size", 1024L));
        inst.add(new IL("Memory/Resident Set Size", 1024L));
        inst.add(new ID("Memory/Percent Memory Size", 0.01));
        inst.add(new ID("PhysicalDisk/Bytes Read per Second", 1024.0));
        inst.add(new ID("PhysicalDisk/Bytes Written per Second", 1024.0));
        CounterSet root = new CounterSet();
        for (AbstractInst i : inst) {
            root.addCounter(i.getPath(), i);
        }
        return root;
    }

    @Override
    protected void setEnvironment(Map<String, String> env) {
        super.setEnvironment(env);
        env.put("S_TIME_FORMAT", "ISO");
    }

    @Override
    public AbstractProcessReader getProcessReader() {
        return new PIDStatReader();
    }

    protected class PIDStatReader
    extends ProcessReaderHelper {
        private static final String PIDSTAT_FIELD_CPU_PERCENT_USR = "%usr";
        private static final String PIDSTAT_FIELD_CPU_PERCENT = "%CPU";
        private static final String PIDSTAT_FIELD_CPU_PERCENT_SYSTEM = "%system";
        private static final String PIDSTAT_FIELD_MEM_MINOR_FAULTS_PERS = "minflt/s";
        private static final String PIDSTAT_FIELD_MEM_MAJOR_FAULTS_PERS = "majflt/s";
        private static final String PIDSTAT_FIELD_MEM_VIRTUAL_SIZE = "VSZ";
        private static final String PIDSTAT_FIELD_MEM_RESIDENT_SET_SIZE = "RSS";
        private static final String PIDSTAT_FIELD_MEM_SIZE_PERCENT = "%MEM";
        private static final String PIDSTAT_FIELD_DISK_KB_READ_PERS = "kB_rd/s";
        private static final String PIDSTAT_FIELD_DISK_KB_WRITTEN_PERS = "kB_wr/s";

        @Override
        protected ActiveProcess getActiveProcess() {
            if (PIDStatCollector.this.activeProcess == null) {
                throw new IllegalStateException();
            }
            return PIDStatCollector.this.activeProcess;
        }

        @Override
        protected void readProcess() throws IOException, InterruptedException {
            if (log.isInfoEnabled()) {
                log.info("begin");
            }
            for (int i = 0; i < 10 && !this.getActiveProcess().isAlive(); ++i) {
                if (log.isInfoEnabled()) {
                    log.info("waiting for the readerFuture to be set.");
                }
                Thread.sleep(100L);
            }
            if (log.isInfoEnabled()) {
                log.info("running");
            }
            String banner = this.readLine();
            if (log.isInfoEnabled()) {
                log.info("banner: " + banner);
            }
            long n = 0L;
            while (true) {
                block14: {
                    String blank = this.readLine();
                    assert (blank.trim().length() == 0) : "Expecting a blank line";
                    String header = this.readLine();
                    String data = this.readLine();
                    try {
                        PIDStatCollector.this.lastModified.set(System.currentTimeMillis());
                        Map<String, String> fields = SysstatUtil.getDataMap(header, data);
                        if (log.isInfoEnabled()) {
                            StringBuilder sb = new StringBuilder();
                            for (Map.Entry<String, String> e : fields.entrySet()) {
                                sb.append(e.getKey());
                                sb.append("=");
                                sb.append(e.getValue());
                                sb.append(", ");
                            }
                            log.info(sb.toString());
                            log.info(header + ";" + data);
                        }
                        if (fields.containsKey(PIDSTAT_FIELD_CPU_PERCENT)) {
                            PIDStatCollector.this.vals.put("CPU/% User Time", Double.parseDouble(fields.get(PIDSTAT_FIELD_CPU_PERCENT_USR)));
                            PIDStatCollector.this.vals.put("CPU/% System Time", Double.parseDouble(fields.get(PIDSTAT_FIELD_CPU_PERCENT_SYSTEM)));
                            PIDStatCollector.this.vals.put("CPU/% Processor Time", Double.parseDouble(fields.get(PIDSTAT_FIELD_CPU_PERCENT)));
                            break block14;
                        }
                        if (fields.containsKey(PIDSTAT_FIELD_MEM_RESIDENT_SET_SIZE)) {
                            PIDStatCollector.this.vals.put("Memory/Minor Faults per Second", Double.parseDouble(fields.get(PIDSTAT_FIELD_MEM_MINOR_FAULTS_PERS)));
                            PIDStatCollector.this.vals.put("Memory/Major Faults per Second", Double.parseDouble(fields.get(PIDSTAT_FIELD_MEM_MAJOR_FAULTS_PERS)));
                            PIDStatCollector.this.vals.put("Memory/Virtual Size", Long.parseLong(fields.get(PIDSTAT_FIELD_MEM_VIRTUAL_SIZE)));
                            PIDStatCollector.this.vals.put("Memory/Resident Set Size", Long.parseLong(fields.get(PIDSTAT_FIELD_MEM_RESIDENT_SET_SIZE)));
                            PIDStatCollector.this.vals.put("Memory/Percent Memory Size", Double.parseDouble(fields.get(PIDSTAT_FIELD_MEM_SIZE_PERCENT)));
                            break block14;
                        }
                        if (PIDStatCollector.this.perProcessIOData && header.contains(PIDSTAT_FIELD_DISK_KB_READ_PERS)) {
                            PIDStatCollector.this.vals.put("PhysicalDisk/Bytes Read per Second", Double.parseDouble(fields.get(PIDSTAT_FIELD_DISK_KB_READ_PERS)));
                            PIDStatCollector.this.vals.put("PhysicalDisk/Bytes Written per Second", Double.parseDouble(fields.get(PIDSTAT_FIELD_DISK_KB_WRITTEN_PERS)));
                            break block14;
                        }
                        log.warn("Could not identify event type from header: [" + header + "]");
                        continue;
                    }
                    catch (Exception ex) {
                        log.warn(ex.getMessage() + "\nheader: " + header + "\n  data: " + data);
                    }
                }
                ++n;
            }
        }
    }

    class ID
    extends AbstractInst<Double> {
        protected final double scale;

        public ID(String path, double scale) {
            super(path);
            this.scale = scale;
        }

        @Override
        public Double getValue() {
            Double value = (Double)PIDStatCollector.this.vals.get(this.path);
            if (value == null) {
                return 0.0;
            }
            double d = value * this.scale;
            return d;
        }
    }

    class IL
    extends AbstractInst<Long> {
        protected final long scale;

        public IL(String path, long scale) {
            super(path);
            this.scale = scale;
        }

        @Override
        public Long getValue() {
            Long value = (Long)PIDStatCollector.this.vals.get(this.path);
            if (value == null) {
                return 0L;
            }
            long v = value * this.scale;
            return v;
        }
    }

    abstract class AbstractInst<T>
    implements IInstrument<T> {
        protected final String path;

        public final String getPath() {
            return this.path;
        }

        protected AbstractInst(String path) {
            if (path == null) {
                throw new IllegalArgumentException();
            }
            this.path = path;
        }

        @Override
        public final long lastModified() {
            return PIDStatCollector.this.lastModified.get();
        }

        @Override
        public final void setValue(T value, long timestamp) {
            throw new UnsupportedOperationException();
        }
    }
}

