/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.linux;

import com.bigdata.counters.AbstractProcessCollector;
import com.bigdata.counters.AbstractProcessReader;
import com.bigdata.counters.ActiveProcess;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterHierarchy;
import com.bigdata.counters.IHostCounters;
import com.bigdata.counters.IInstrument;
import com.bigdata.counters.IRequiredHostCounters;
import com.bigdata.counters.ProcessReaderHelper;
import com.bigdata.counters.linux.KernelVersion;
import com.bigdata.counters.linux.SysstatUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SarCpuUtilizationCollector
extends AbstractProcessCollector
implements ICounterHierarchy,
IRequiredHostCounters,
IHostCounters {
    private final Map<String, Object> vals = new ConcurrentHashMap<String, Object>();
    private final AtomicLong lastModified = new AtomicLong(System.currentTimeMillis());

    public SarCpuUtilizationCollector(int interval, KernelVersion kernelVersion) {
        super(interval);
    }

    @Override
    public List<String> getCommand() {
        LinkedList<String> command = new LinkedList<String>();
        command.add(SysstatUtil.getPath("sar").getPath());
        command.add("-u");
        command.add("" + this.getInterval());
        command.add("0");
        return command;
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        LinkedList<DI> inst = new LinkedList<DI>();
        inst.add(new DI("CPU/% Processor Time", 0.01));
        inst.add(new DI("CPU/% User Time", 0.01));
        inst.add(new DI("CPU/% System Time", 0.01));
        inst.add(new DI("CPU/% IO Wait", 0.01));
        for (I i : inst) {
            root.addCounter(i.getPath(), i);
        }
        return root;
    }

    @Override
    protected void setEnvironment(Map<String, String> env) {
        super.setEnvironment(env);
        env.put("S_TIME_FORMAT", "ISO");
    }

    @Override
    public AbstractProcessReader getProcessReader() {
        return new SarReader();
    }

    private class SarReader
    extends ProcessReaderHelper {
        @Override
        protected ActiveProcess getActiveProcess() {
            if (SarCpuUtilizationCollector.this.activeProcess == null) {
                throw new IllegalStateException();
            }
            return SarCpuUtilizationCollector.this.activeProcess;
        }

        @Override
        protected void readProcess() throws Exception {
            if (log.isInfoEnabled()) {
                log.info("begin");
            }
            for (int i = 0; i < 10 && !this.getActiveProcess().isAlive(); ++i) {
                if (log.isInfoEnabled()) {
                    log.info("waiting for the readerFuture to be set.");
                }
                Thread.sleep(100L);
            }
            if (log.isInfoEnabled()) {
                log.info("running");
            }
            String banner = this.readLine();
            if (log.isInfoEnabled()) {
                log.info("banner: " + banner);
            }
            String blank = this.readLine();
            assert (blank.trim().length() == 0) : "Expecting a blank line";
            String header = this.readLine();
            if (log.isInfoEnabled()) {
                log.info("header: " + header);
            }
            while (true) {
                String data;
                if ((data = this.readLine()).trim().length() == 0) {
                    header = this.readLine();
                    if (!log.isInfoEnabled()) continue;
                    log.info("header: " + header);
                    continue;
                }
                try {
                    SarCpuUtilizationCollector.this.lastModified.set(System.currentTimeMillis());
                    String[] fields = SysstatUtil.splitDataLine(data);
                    String user = fields[2];
                    String system = fields[4];
                    String iowait = fields[5];
                    String idle = fields[7];
                    if (log.isInfoEnabled()) {
                        log.info("\n%user=" + user + ", %system=" + system + ", iowait=" + iowait + ", idle=" + idle + "\n" + header + "\n" + data);
                    }
                    SarCpuUtilizationCollector.this.vals.put("CPU/% User Time", Double.parseDouble(user));
                    SarCpuUtilizationCollector.this.vals.put("CPU/% System Time", Double.parseDouble(system));
                    SarCpuUtilizationCollector.this.vals.put("CPU/% IO Wait", Double.parseDouble(iowait));
                    SarCpuUtilizationCollector.this.vals.put("CPU/% Processor Time", 100.0 - Double.parseDouble(idle));
                    continue;
                }
                catch (Exception ex) {
                    log.warn(ex.getMessage() + "\nheader: " + header + "\n  data: " + data, ex);
                    continue;
                }
                break;
            }
        }
    }

    class DI
    extends I<Double> {
        protected final double scale;

        DI(String path, double scale) {
            super(path);
            this.scale = scale;
        }

        @Override
        public Double getValue() {
            Double value = (Double)SarCpuUtilizationCollector.this.vals.get(this.path);
            if (value == null) {
                return 0.0;
            }
            double d = value * this.scale;
            return d;
        }
    }

    abstract class I<T>
    implements IInstrument<T> {
        protected final String path;

        public String getPath() {
            return this.path;
        }

        public I(String path) {
            if (path == null) {
                throw new IllegalArgumentException();
            }
            this.path = path;
        }

        @Override
        public long lastModified() {
            return SarCpuUtilizationCollector.this.lastModified.get();
        }

        @Override
        public void setValue(T value, long timestamp) {
            throw new UnsupportedOperationException();
        }
    }
}

