/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.linux;

import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.PIDUtil;
import com.bigdata.counters.linux.KernelVersion;
import com.bigdata.counters.linux.PIDStatCollector;
import com.bigdata.counters.linux.SarCpuUtilizationCollector;
import com.bigdata.counters.linux.VMStatCollector;

public class StatisticsCollectorForLinux
extends AbstractStatisticsCollector {
    protected static int pid = PIDUtil.getLinuxPIDWithBash();
    protected static KernelVersion kernelVersion = KernelVersion.get();
    protected final String processName;
    protected SarCpuUtilizationCollector sar1;
    protected VMStatCollector vmstat;
    protected PIDStatCollector pidstat;

    @Override
    public void start() {
        if (log.isInfoEnabled()) {
            log.info("starting collectors");
        }
        super.start();
        if (this.sar1 != null) {
            try {
                this.sar1.start();
            }
            catch (Throwable t) {
                log.error(t, t);
            }
        }
        if (this.vmstat != null) {
            try {
                this.vmstat.start();
            }
            catch (Throwable t) {
                log.error(t, t);
            }
        }
        if (this.pidstat != null) {
            try {
                this.pidstat.start();
            }
            catch (Throwable t) {
                log.error(t, t);
            }
        }
    }

    @Override
    public void stop() {
        if (log.isInfoEnabled()) {
            log.info("stopping collectors");
        }
        super.stop();
        if (this.sar1 != null) {
            try {
                this.sar1.stop();
            }
            catch (Throwable t) {
                log.error(t, t);
            }
        }
        if (this.vmstat != null) {
            try {
                this.vmstat.stop();
            }
            catch (Throwable t) {
                log.error(t, t);
            }
        }
        if (this.pidstat != null) {
            try {
                this.pidstat.stop();
            }
            catch (Throwable t) {
                log.error(t, t);
            }
        }
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = super.getCounters();
        if (this.sar1 != null) {
            root.makePath(fullyQualifiedHostName).attach(this.sar1.getCounters());
        }
        if (this.vmstat != null) {
            root.makePath(fullyQualifiedHostName).attach(this.vmstat.getCounters());
        }
        if (this.pidstat != null) {
            root.makePath(fullyQualifiedHostName + "/" + this.processName).attach(this.pidstat.getCounters());
        }
        return root;
    }

    public StatisticsCollectorForLinux(int interval, String processName) {
        super(interval, processName);
        if (processName == null) {
            throw new IllegalArgumentException();
        }
        this.processName = processName;
        boolean collectCPUStatsWithSAR = false;
        this.sar1 = null;
        this.vmstat = new VMStatCollector(interval, true);
        this.pidstat = new PIDStatCollector(pid, interval, kernelVersion);
    }
}

