/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.linux;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SysstatUtil {
    private static final Logger log = Logger.getLogger(SysstatUtil.class);

    public static final File getPath(String cmd) {
        File f;
        File path;
        File configuredPath = path = new File(System.getProperty("com.bigdata.counters.linux.sysstat.path", "/usr/bin"));
        if (log.isInfoEnabled()) {
            log.info("com.bigdata.counters.linux.sysstat.path=" + configuredPath);
        }
        if (!(f = new File(path, cmd)).exists()) {
            log.warn("Not found: " + f);
            path = new File("/usr/bin");
            f = new File(path, cmd);
            if (!f.exists()) {
                log.warn("Not found: " + f);
                path = new File("/usr/local/bin");
                f = new File(path, cmd);
                if (!f.exists()) {
                    log.warn("Not found: " + f);
                    log.error("Could not locate: '" + cmd + "'. Set '-D" + "com.bigdata.counters.linux.sysstat.path" + "=<dir>'");
                    path = configuredPath;
                }
            }
        }
        if (configuredPath != path) {
            log.warn("Using effective path: com.bigdata.counters.linux.sysstat.path=" + path);
        }
        return new File(path, cmd);
    }

    public static String[] splitDataLine(String data) {
        Object[] fields = data.trim().split("\\s+");
        if (log.isDebugEnabled()) {
            log.debug("fields=" + Arrays.toString(fields));
        }
        return fields;
    }

    public static Map<String, String> getDataMap(String header, String data) {
        String[] data_fields;
        HashMap<String, String> fields = new HashMap<String, String>();
        String[] header_fields = SysstatUtil.splitDataLine(header);
        if (header_fields.length != (data_fields = SysstatUtil.splitDataLine(data)).length) {
            throw new IllegalArgumentException("Different fields count in header and data");
        }
        for (int i = 0; i < header_fields.length; ++i) {
            fields.put(header_fields[i], data_fields[i]);
        }
        return fields;
    }

    public static DateFormat newDateFormat() {
        return new SimpleDateFormat("hh:mm:ss aa");
    }

    public static interface Options {
        public static final String PATH = "com.bigdata.counters.linux.sysstat.path";
        public static final String DEFAULT_PATH = "/usr/bin";
    }
}

