/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.osx;

import com.bigdata.counters.AbstractProcessCollector;
import com.bigdata.counters.AbstractProcessReader;
import com.bigdata.counters.ActiveProcess;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterHierarchy;
import com.bigdata.counters.IHostCounters;
import com.bigdata.counters.IInstrument;
import com.bigdata.counters.IRequiredHostCounters;
import com.bigdata.counters.ProcessReaderHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public class IOStatCollector
extends AbstractProcessCollector
implements ICounterHierarchy,
IRequiredHostCounters,
IHostCounters {
    private final Map<String, Object> vals = new ConcurrentHashMap<String, Object>();
    private final AtomicLong lastModified = new AtomicLong(System.currentTimeMillis());
    static final Pattern pattern = Pattern.compile("\\s+");
    private final boolean cpuStats;

    public IOStatCollector(int interval, boolean cpuStats) {
        super(interval);
        this.cpuStats = cpuStats;
    }

    @Override
    public List<String> getCommand() {
        LinkedList<String> command = new LinkedList<String>();
        command.add("/usr/sbin/iostat");
        command.add("-d");
        command.add("-n");
        command.add("999");
        command.add("-C");
        command.add("-w");
        command.add("" + this.getInterval());
        return command;
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        LinkedList<DI> inst = new LinkedList<DI>();
        inst.add(new DI("PhysicalDisk/Bytes Per Second", 1048576.0));
        inst.add(new DI("PhysicalDisk/Transfers Per Second"));
        if (this.cpuStats) {
            inst.add(new DI("CPU/% Processor Time", 0.01));
            inst.add(new DI("CPU/% User Time", 0.01));
            inst.add(new DI("CPU/% System Time", 0.01));
        }
        for (I i : inst) {
            root.addCounter(i.getPath(), i);
        }
        return root;
    }

    @Override
    public AbstractProcessReader getProcessReader() {
        return new IOStatReader();
    }

    private static void assertField(int index, String[] fields, String expected) {
        if (!expected.equals(fields[index])) {
            throw new RuntimeException("Expecting '" + expected + "', found: '" + fields[0] + "'");
        }
    }

    protected class IOStatReader
    extends ProcessReaderHelper {
        public static final int IOSTAT_CPU_FIELDS_NUM = 3;
        public static final String IOSTAT_FIELD_KB_T = "KB/t";
        public static final String IOSTAT_FIELD_TPS = "tps";
        public static final String IOSTAT_FIELD_MB_S = "MB/s";
        public static final String IOSTAT_FIELD_CPU_US = "us";
        public static final String IOSTAT_FIELD_CPU_SY = "sy";
        public static final String IOSTAT_FIELD_CPU_ID = "id";

        @Override
        protected ActiveProcess getActiveProcess() {
            if (IOStatCollector.this.activeProcess == null) {
                throw new IllegalStateException();
            }
            return IOStatCollector.this.activeProcess;
        }

        @Override
        protected void readProcess() throws Exception {
            int i;
            String h1;
            if (log.isInfoEnabled()) {
                log.info("begin");
            }
            for (int i2 = 0; i2 < 10 && !this.getActiveProcess().isAlive(); ++i2) {
                if (log.isInfoEnabled()) {
                    log.info("waiting for the readerFuture to be set.");
                }
                Thread.sleep(100L);
            }
            if (log.isInfoEnabled()) {
                log.info("running");
            }
            int ncpuFields = IOStatCollector.this.cpuStats ? 3 : 0;
            HashMap<String, Integer> deviceFields = new HashMap<String, Integer>();
            HashMap<String, Integer> cpuFields = new HashMap<String, Integer>();
            String header1 = null;
            String h0 = this.readLine();
            if (log.isInfoEnabled()) {
                log.info("header: " + h0);
            }
            header1 = h1 = this.readLine();
            if (log.isInfoEnabled()) {
                log.info("header: " + h1);
            }
            int ndevices = pattern.split(h0.trim(), 0).length - 1;
            String[] fields = pattern.split(h1.trim(), 0);
            int nfields = fields.length;
            int ndeviceFields = fields.length - 3;
            int nfieldsPerDevice = ndeviceFields / ndevices;
            for (i = 0; i < nfieldsPerDevice; ++i) {
                deviceFields.put(fields[i], i);
            }
            for (i = ndeviceFields; i < nfields; ++i) {
                cpuFields.put(fields[i], i - ndeviceFields);
            }
            if (log.isInfoEnabled()) {
                log.info("ndevices=" + ndevices);
            }
            boolean first = true;
            block5: while (true) {
                String s;
                if ((s = this.readLine()).contains("disk") || s.contains("cpu")) {
                    header1 = s = this.readLine();
                    s = this.readLine();
                    if (log.isInfoEnabled()) {
                        log.info("Skipped headers.");
                    }
                }
                String data = s;
                if (first) {
                    first = false;
                    continue;
                }
                try {
                    IOStatCollector.this.lastModified.set(System.currentTimeMillis());
                    String[] fields2 = pattern.split(data.trim(), 0);
                    int nfields2 = fields2.length;
                    int ndeviceFields2 = fields2.length - 3;
                    int ndevices2 = ndeviceFields2 / nfieldsPerDevice;
                    if (IOStatCollector.this.cpuStats) {
                        String us = fields2[nfields2 - 3 + (Integer)cpuFields.get(IOSTAT_FIELD_CPU_US)];
                        String sy = fields2[nfields2 - 3 + (Integer)cpuFields.get(IOSTAT_FIELD_CPU_SY)];
                        String id = fields2[nfields2 - 3 + (Integer)cpuFields.get(IOSTAT_FIELD_CPU_ID)];
                        IOStatCollector.this.vals.put("CPU/% User Time", Double.parseDouble(us));
                        IOStatCollector.this.vals.put("CPU/% System Time", Double.parseDouble(sy));
                        IOStatCollector.this.vals.put("CPU/% Processor Time", 100.0 - Double.parseDouble(id));
                    }
                    double totalKBPerXFer = 0.0;
                    double totalxferPerSec = 0.0;
                    double totalMBPerSec = 0.0;
                    int i3 = 0;
                    while (true) {
                        if (i3 >= ndevices2) continue block5;
                        int off = i3 * nfieldsPerDevice;
                        String kbPerXfer = fields2[off + (Integer)deviceFields.get(IOSTAT_FIELD_KB_T)];
                        String xferPerSec = fields2[off + (Integer)deviceFields.get(IOSTAT_FIELD_TPS)];
                        String mbPerSec = fields2[off + (Integer)deviceFields.get(IOSTAT_FIELD_MB_S)];
                        double _kbPerXFer = Double.parseDouble(kbPerXfer);
                        double _xferPerSec = Double.parseDouble(xferPerSec);
                        double _mbPerSec = Double.parseDouble(mbPerSec);
                        totalKBPerXFer += _kbPerXFer;
                        totalxferPerSec += _xferPerSec;
                        totalMBPerSec += _mbPerSec;
                        if (log.isInfoEnabled()) {
                            log.info("\ntotalKBPerXfer=" + totalKBPerXFer + ", totalXFerPerSec=" + totalxferPerSec + ", totalMBPerSec=" + totalMBPerSec + "\n" + header1 + "\n" + data);
                        }
                        IOStatCollector.this.vals.put("PhysicalDisk/Transfers Per Second", totalxferPerSec);
                        IOStatCollector.this.vals.put("PhysicalDisk/Bytes Per Second", totalMBPerSec);
                        ++i3;
                    }
                }
                catch (Exception ex) {
                    log.warn(ex.getMessage() + "\nheader: " + header1 + "\n  data: " + data, ex);
                    continue;
                }
                break;
            }
        }
    }

    class DI
    extends I<Double> {
        protected final double scale;

        DI(String path) {
            this(path, 1.0);
        }

        DI(String path, double scale) {
            super(path);
            this.scale = scale;
        }

        @Override
        public Double getValue() {
            Double value = (Double)IOStatCollector.this.vals.get(this.path);
            if (value == null) {
                return 0.0;
            }
            double d = value * this.scale;
            return d;
        }
    }

    abstract class I<T>
    implements IInstrument<T> {
        protected final String path;

        public String getPath() {
            return this.path;
        }

        public I(String path) {
            assert (path != null);
            this.path = path;
        }

        @Override
        public long lastModified() {
            return IOStatCollector.this.lastModified.get();
        }

        @Override
        public void setValue(T value, long timestamp) {
            throw new UnsupportedOperationException();
        }
    }
}

