/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.query;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.HistoryInstrument;
import com.bigdata.counters.ICounter;
import com.bigdata.counters.PeriodEnum;
import com.bigdata.counters.query.ICounterSelector;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CounterSetSelector
implements ICounterSelector {
    private static final Logger log = Logger.getLogger(CounterSetSelector.class);
    private final CounterSet counterSet;

    public CounterSetSelector(CounterSet counterSet) {
        if (counterSet == null) {
            throw new IllegalArgumentException();
        }
        this.counterSet = counterSet;
    }

    public CounterSet getRoot() {
        return this.counterSet;
    }

    @Override
    public ICounter[] selectCounters(int depth, Pattern pattern, long fromTime, long toTime, PeriodEnum period, boolean historyRequired) {
        if (log.isInfoEnabled()) {
            log.info("path=" + this.counterSet.getPath() + ", depth=" + depth);
        }
        Vector<ICounter> counters = new Vector<ICounter>();
        Iterator<ICounter> itr = this.counterSet.getCounters(pattern);
        int nscanned = 0;
        int nskipped = 0;
        while (itr.hasNext()) {
            int counterDepth;
            ICounter c = itr.next();
            ++nscanned;
            if (log.isDebugEnabled()) {
                log.debug("considering: " + c.getPath());
            }
            if (historyRequired && !(c.getInstrument() instanceof HistoryInstrument)) {
                if (log.isDebugEnabled()) {
                    log.debug("skipping (history): " + c.getPath());
                }
                ++nskipped;
                continue;
            }
            if (depth > 0 && (counterDepth = c.getDepth()) > depth) {
                if (log.isDebugEnabled()) {
                    log.debug("skipping (depth): " + c.getPath());
                }
                ++nskipped;
                continue;
            }
            counters.add(c);
        }
        if (log.isInfoEnabled()) {
            log.info("Matched " + counters.size() + " counters; nscanned=" + nscanned + ", nskipped=" + nskipped);
        }
        ICounter[] a = counters.toArray(new ICounter[counters.size()]);
        return a;
    }
}

