/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.query;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.DefaultInstrumentFactory;
import com.bigdata.counters.History;
import com.bigdata.counters.HistoryInstrument;
import com.bigdata.counters.ICounter;
import com.bigdata.counters.ICounterSet;
import com.bigdata.counters.PeriodEnum;
import com.bigdata.counters.httpd.DummyEventReportingService;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class QueryUtil {
    protected static final Logger log = Logger.getLogger(QueryUtil.class);
    private static final String[] requiredPerformanceCounterPaths = new String[]{"Memory/Major Page Faults Per Second", "LogicalDisk/% Free Space", "CPU/% Processor Time", "CPU/% IO Wait", "Concurrency Manager/Unisolated Write Service/Average Queuing Time", "Resource Manager/Store Manager/Data Volume Bytes Available", "Resource Manager/Store Manager/Temp Volume Bytes Available"};
    private static final Pattern requiredPerformanceCountersFilter = QueryUtil.getPattern(Arrays.asList(requiredPerformanceCounterPaths), null);

    public static String[] getCapturedGroups(Pattern pattern, ICounter counter) {
        if (counter == null) {
            throw new IllegalArgumentException();
        }
        if (pattern == null) {
            return null;
        }
        Matcher m = pattern.matcher(counter.getPath());
        int groupCount = m.groupCount();
        if (groupCount == 0) {
            return null;
        }
        if (!m.matches()) {
            throw new IllegalArgumentException("No match? counter=" + counter + ", regex=" + pattern);
        }
        if (log.isDebugEnabled()) {
            log.debug("input  : " + counter.getPath());
            log.debug("pattern: " + pattern);
            log.debug("matcher: " + m);
            log.debug("result : " + m.toMatchResult());
        }
        String[] groups = new String[groupCount];
        for (int i = 1; i <= groupCount; ++i) {
            String s = m.group(i);
            if (log.isDebugEnabled()) {
                log.debug("group[" + i + "]: " + m.group(i));
            }
            groups[i - 1] = s;
        }
        return groups;
    }

    public static Pattern getPattern(Collection<String> filter, Collection<String> regex) {
        Pattern pattern;
        StringBuilder sb = new StringBuilder();
        if (filter != null) {
            for (String val : filter) {
                if (log.isInfoEnabled()) {
                    log.info("filter=" + val);
                }
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append("(?:.*" + Pattern.quote(val) + ".*)");
            }
        }
        if (regex != null) {
            for (String val : regex) {
                if (log.isInfoEnabled()) {
                    log.info("regex=" + val);
                }
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append("(?:" + val + ")");
            }
        }
        if (sb.length() > 0) {
            String s = sb.toString();
            if (log.isInfoEnabled()) {
                log.info("effective regex filter=" + s);
            }
            pattern = Pattern.compile(s);
        } else {
            pattern = null;
        }
        return pattern;
    }

    public static Pattern getPattern(Collection<Pattern> regex) {
        StringBuilder sb = new StringBuilder();
        for (Pattern val : regex) {
            if (log.isInfoEnabled()) {
                log.info("regex=" + val);
            }
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append("(?:" + val + ")");
        }
        String s = sb.toString();
        if (log.isInfoEnabled()) {
            log.info("effective regex filter=" + s);
        }
        return Pattern.compile(s);
    }

    public static void readCountersFromFile(File file, CounterSet counterSet, Pattern filter, int nslots, PeriodEnum unit) throws IOException, SAXException, ParserConfigurationException {
        DefaultInstrumentFactory instrumentFactory = new DefaultInstrumentFactory(nslots, unit, false);
        QueryUtil.readCountersFromFile(file, counterSet, filter, instrumentFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readCountersFromFile(File file, CounterSet counterSet, Pattern filter, ICounterSet.IInstrumentFactory instrumentFactory) throws IOException, SAXException, ParserConfigurationException {
        if (log.isInfoEnabled()) {
            log.info("reading file: " + file);
        }
        try (InputStream is = null;){
            is = new BufferedInputStream(new FileInputStream(file), 0x100000);
            counterSet.readXML(is, instrumentFactory, filter);
            if (log.isInfoEnabled()) {
                int n = 0;
                long firstTimestamp = 0L;
                long lastTimestamp = 0L;
                Iterator<ICounter> itr = counterSet.getCounters(null);
                while (itr.hasNext()) {
                    ICounter c = itr.next();
                    ++n;
                    System.err.println("Retained: " + c);
                    if (!(c.getInstrument() instanceof HistoryInstrument)) continue;
                    History h = ((HistoryInstrument)c.getInstrument()).getHistory();
                    History.SampleIterator sitr = h.iterator();
                    long firstSampleTime = sitr.getFirstSampleTime();
                    long lastSampleTime = sitr.getLastSampleTime();
                    if (firstSampleTime > 0L && (firstSampleTime < firstTimestamp || firstTimestamp == 0L)) {
                        firstTimestamp = firstSampleTime;
                    }
                    if (lastSampleTime <= lastTimestamp) continue;
                    lastTimestamp = lastSampleTime;
                }
                log.info("There are now " + n + " counters covering " + new Date(firstTimestamp) + " : " + new Date(lastTimestamp));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readEvents(DummyEventReportingService service, File file) throws IOException {
        System.out.println("reading events file: " + file);
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(file));
            service.readCSV(reader);
            System.out.println("read " + service.rangeCount(0L, Long.MAX_VALUE) + " events from file: " + file);
        }
    }

    public static Collection<File> collectFiles(Collection<File> in, FileFilter filter) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        LinkedList<File> out = new LinkedList<File>();
        for (File file : in) {
            if (file.isDirectory()) {
                if (log.isInfoEnabled()) {
                    log.info("Reading directory: " + file);
                }
                File[] files = file.listFiles(filter);
                out.addAll(QueryUtil.collectFiles(Arrays.asList(files), filter));
                continue;
            }
            if (!filter.accept(file)) continue;
            out.add(file);
        }
        return out;
    }

    public static Pattern getRequiredPerformanceCountersFilter() {
        return requiredPerformanceCountersFilter;
    }

    public static void main(String[] args) throws IOException, SAXException, ParserConfigurationException {
        Pattern filter = QueryUtil.getRequiredPerformanceCountersFilter();
        System.err.println("required counter pattern: " + filter);
        CounterSet counterSet = new CounterSet();
        for (String s : args) {
            File file = new File(s);
            QueryUtil.readCountersFromFile(file, counterSet, filter, new DefaultInstrumentFactory(60, PeriodEnum.Minutes, false));
        }
        System.out.println("counters: " + counterSet.asXML(null));
    }

    public static class ReadCounterSetXMLFileTask
    implements Callable<Void> {
        final File file;
        final CounterSet counterSet;
        final int nsamples;
        final PeriodEnum period;
        final Pattern regex;

        public ReadCounterSetXMLFileTask(File file, CounterSet counterSet, int nsamples, PeriodEnum period, Pattern regex) {
            this.file = file;
            this.counterSet = counterSet;
            this.nsamples = nsamples;
            this.period = period;
            this.regex = regex;
        }

        @Override
        public Void call() throws Exception {
            QueryUtil.readCountersFromFile(this.file, this.counterSet, this.regex, this.nsamples, this.period);
            return null;
        }

        public String toString() {
            return this.getClass() + "{ file=" + this.file + ", nsamples=" + this.nsamples + ", period=" + (Object)((Object)this.period) + ", regex=" + this.regex + "}";
        }
    }
}

