/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.render;

import com.bigdata.counters.ICounter;
import com.bigdata.counters.IHistoryEntry;
import com.bigdata.counters.query.CSet;
import com.bigdata.counters.query.HistoryTable;
import com.bigdata.counters.query.PivotTable;
import com.bigdata.counters.render.PivotTableRenderer;
import com.bigdata.counters.render.ValueFormatter;
import com.bigdata.counters.render.XHTMLRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

public class TabDelimitedPivotTableRenderer
extends PivotTableRenderer {
    public TabDelimitedPivotTableRenderer(PivotTable pt, ValueFormatter formatter) {
        super(pt, formatter);
    }

    @Override
    public void render(Writer w) throws IOException {
        HistoryTable t = this.pt.src;
        w.write(t.units + "\t");
        w.write("timestamp\t");
        for (String s : this.pt.cnames) {
            w.write(s + "\t");
        }
        for (String s : this.pt.vcols) {
            w.write(s + "\t");
        }
        w.write("\n");
        for (int row = 0; row < t.nrows; ++row) {
            long timestamp = t.getTimestamp(row);
            String unitStr = XHTMLRenderer.cdata(this.formatter.unitsFormat.format(((double)timestamp - (double)t.getTimestamp(0)) / (double)t.period));
            String timeStr = XHTMLRenderer.cdata(this.formatter.date(timestamp));
            for (CSet cset : this.pt.csets) {
                int j;
                assert (cset.cats.length == this.pt.cnames.length) : "cset categories=" + Arrays.toString(cset.cats) + " vs " + "category names: " + Arrays.toString(this.pt.cnames);
                Double[] vals = new Double[this.pt.vcols.size()];
                int ndefined = 0;
                int valueColumnIndex = 0;
                for (String vcol : this.pt.vcols) {
                    int valueCountForColumn = 0;
                    double val = 0.0;
                    block5: for (ICounter c : cset.counters) {
                        if (!c.getName().equals(vcol)) continue;
                        for (int col = 0; col < t.a.length; ++col) {
                            IHistoryEntry e;
                            if (c != t.a[col] || (e = t.data[row][col]) == null) continue;
                            val += ((Number)e.getValue()).doubleValue();
                            ++valueCountForColumn;
                            continue block5;
                        }
                    }
                    if (valueCountForColumn > 0) {
                        vals[valueColumnIndex] = val;
                        ++ndefined;
                    }
                    if (log.isDebugEnabled() && valueCountForColumn > 0) {
                        log.debug("vcol=" + vcol + ", vcol#=" + valueColumnIndex + ", #values=" + valueCountForColumn + ", val=" + val);
                    }
                    ++valueColumnIndex;
                }
                if (ndefined == 0) continue;
                w.write(unitStr + "\t");
                w.write(timeStr + "\t");
                for (j = 0; j < this.pt.cnames.length; ++j) {
                    w.write(cset.cats[j] + "\t");
                }
                for (j = 0; j < vals.length; ++j) {
                    String s = vals[j] == null ? "" : Double.toString(vals[j]);
                    w.write(s + "\t");
                }
                w.write("\n");
            }
        }
    }
}

