/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.win;

import com.bigdata.counters.AbstractProcessCollector;
import com.bigdata.counters.AbstractProcessReader;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.IInstrument;
import com.bigdata.util.CSVReader;
import com.bigdata.util.InnerCause;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.channels.ClosedByInterruptException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.apache.log4j.Logger;

public class TypeperfCollector
extends AbstractProcessCollector {
    private static final Logger log = Logger.getLogger(TypeperfCollector.class);
    private long lastModified = System.currentTimeMillis();
    private Map<String, Object> vals = new HashMap<String, Object>();
    protected List<InstrumentForWPC> decls = null;

    public TypeperfCollector(int interval) {
        super(interval);
    }

    @Override
    public List<String> getCommand() {
        this.getCounters();
        LinkedList<String> command = new LinkedList<String>();
        command.add("typeperf");
        command.add("-si");
        command.add("" + this.getInterval());
        for (InstrumentForWPC decl : this.decls) {
            command.add("\"" + decl.getCounterNameForWindows() + "\"");
            if (!log.isInfoEnabled()) continue;
            log.info("Will collect: \"" + decl.getCounterNameForWindows() + "\" as " + decl.getPath());
        }
        return command;
    }

    @Override
    public AbstractProcessReader getProcessReader() {
        return new ProcessReader();
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        String p = "";
        this.decls = Arrays.asList(new InstrumentForWPC("\\Memory\\Pages/Sec", "Memory/Major Page Faults Per Second", 1.0), new InstrumentForWPC("\\Processor(_Total)\\% Processor Time", "CPU/% Processor Time", 0.01), new InstrumentForWPC("\\LogicalDisk(_Total)\\% Free Space", "LogicalDisk/% Free Space", 0.01), new InstrumentForWPC("\\PhysicalDisk(_Total)\\Avg. Disk Queue Length", "PhysicalDisk/Avg. Disk Queue Length", 1.0), new InstrumentForWPC("\\PhysicalDisk(_Total)\\% Idle Time", "PhysicalDisk/% Idle Time", 0.01), new InstrumentForWPC("\\PhysicalDisk(_Total)\\% Disk Time", "PhysicalDisk/% Disk Time", 0.01), new InstrumentForWPC("\\PhysicalDisk(_Total)\\% Disk Read Time", "PhysicalDisk/% Disk Read Time", 0.01), new InstrumentForWPC("\\PhysicalDisk(_Total)\\% Disk Write Time", "PhysicalDisk/% Disk Write Time", 0.01), new InstrumentForWPC("\\PhysicalDisk(_Total)\\Disk Read Bytes/Sec", "PhysicalDisk/Bytes Read Per Second", 1.0), new InstrumentForWPC("\\PhysicalDisk(_Total)\\Disk Write Bytes/Sec", "PhysicalDisk/Bytes Written Per Second", 1.0), new InstrumentForWPC("\\PhysicalDisk(_Total)\\Disk Reads/Sec", "PhysicalDisk/Reads Per Second", 1.0), new InstrumentForWPC("\\PhysicalDisk(_Total)\\Disk Writes/Sec", "PhysicalDisk/Writes Per Second", 1.0), new InstrumentForWPC("\\PhysicalDisk(_Total)\\Avg. Disk Bytes/Read", "PhysicalDisk/Avg. Disk Bytes per Read", 1.0), new InstrumentForWPC("\\PhysicalDisk(_Total)\\Avg. Disk Bytes/Write", "PhysicalDisk/Avg. Disk Bytes per Write", 1.0));
        for (InstrumentForWPC inst : this.decls) {
            root.addCounter(inst.getPath(), inst);
        }
        return root;
    }

    private class ProcessReader
    extends AbstractProcessReader {
        private final SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy kk:mm:ss.SSS");

        ProcessReader() {
        }

        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info("");
            }
            try {
                this.read();
            }
            catch (Exception e) {
                if (InnerCause.isInnerCause(e, InterruptedException.class) || InnerCause.isInnerCause(e, ClosedByInterruptException.class) || InnerCause.isInnerCause(e, CancellationException.class)) {
                    if (log.isInfoEnabled()) {
                        log.info("Interrupted - will terminate");
                    }
                }
                log.fatal(e.getMessage(), e);
            }
            if (log.isInfoEnabled()) {
                log.info("Terminated");
            }
        }

        private void read() throws Exception {
            if (log.isInfoEnabled()) {
                log.info("");
            }
            long nsamples = 0L;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(this.is));
            CSVReader csvReader = new CSVReader(reader);
            csvReader.setTailDelayMillis(100L);
            csvReader.readHeaders();
            csvReader.setHeader(0, new CSVReader.Header("Timestamp"){

                @Override
                public Object parseValue(String text) {
                    try {
                        return ProcessReader.this.f.parse(text);
                    }
                    catch (ParseException e) {
                        log.error("Could not parse: " + text, e);
                        return text;
                    }
                }
            });
            if (log.isInfoEnabled()) {
                log.info("setting up headers.");
            }
            int i = 1;
            for (InstrumentForWPC decl : TypeperfCollector.this.decls) {
                String path = decl.getPath();
                if (log.isInfoEnabled()) {
                    log.info("setHeader[i=" + i + "]=" + path);
                }
                csvReader.setHeader(i++, new CSVReader.Header(path));
            }
            if (log.isInfoEnabled()) {
                log.info("starting row reads");
            }
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (!csvReader.hasNext()) break;
                try {
                    Object row = csvReader.next();
                    long timestamp = ((Date)row.get("Timestamp")).getTime();
                    TypeperfCollector.this.lastModified = timestamp;
                    for (Map.Entry entry : row.entrySet()) {
                        String path = (String)entry.getKey();
                        if (path.equals("Timestamp")) continue;
                        String value = "" + entry.getValue();
                        if (log.isDebugEnabled()) {
                            log.debug(path + "=" + value);
                        }
                        TypeperfCollector.this.vals.put(path, Double.parseDouble(value));
                    }
                    ++nsamples;
                }
                catch (Throwable ex) {
                    log.warn(ex.getMessage(), ex);
                }
            }
            if (log.isInfoEnabled()) {
                log.info("done.");
            }
        }
    }

    class InstrumentForWPC
    implements IInstrument<Double> {
        private final String counterNameForWindows;
        private final String path;
        private final double scale;

        public String getCounterNameForWindows() {
            return this.counterNameForWindows;
        }

        public String getPath() {
            return this.path;
        }

        public InstrumentForWPC(String counterNameForWindows, String path, double scale) {
            if (counterNameForWindows == null) {
                throw new IllegalArgumentException();
            }
            if (path == null) {
                throw new IllegalArgumentException();
            }
            this.counterNameForWindows = counterNameForWindows;
            this.path = path;
            this.scale = scale;
        }

        @Override
        public Double getValue() {
            Double value = (Double)TypeperfCollector.this.vals.get(this.path);
            if (value == null) {
                return 0.0;
            }
            double d = value * this.scale;
            return d;
        }

        @Override
        public long lastModified() {
            return TypeperfCollector.this.lastModified;
        }

        @Override
        public void setValue(Double value, long timestamp) {
            throw new UnsupportedOperationException();
        }
    }
}

