/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.GangliaMessageDecoder31;
import com.bigdata.ganglia.IGangliaDefaults;
import com.bigdata.ganglia.IGangliaMessage;
import com.bigdata.ganglia.IGangliaMessageDecoder;
import com.bigdata.ganglia.IGangliaMessageHandler;
import com.bigdata.ganglia.util.BytesUtil;
import com.bigdata.ganglia.util.DaemonThreadFactory;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class GangliaListener
implements Callable<Void>,
IGangliaDefaults {
    private static final Logger log = Logger.getLogger(GangliaListener.class);
    private final InetAddress group;
    private final int port;
    private final IGangliaMessageDecoder decoder;
    private final IGangliaMessageHandler handler;
    private volatile boolean listening = false;

    public boolean isListening() {
        return this.listening;
    }

    public GangliaListener(IGangliaMessageHandler handler) throws UnknownHostException {
        this(InetAddress.getByName("239.2.11.71"), 8649, new GangliaMessageDecoder31(), handler);
    }

    public GangliaListener(InetAddress group, int port, IGangliaMessageDecoder decoder, IGangliaMessageHandler handler) {
        if (group == null) {
            throw new IllegalArgumentException();
        }
        if (port <= 0) {
            throw new IllegalArgumentException();
        }
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        if (decoder == null) {
            throw new IllegalArgumentException();
        }
        this.group = group;
        this.port = port;
        this.decoder = decoder;
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        MulticastSocket datagramSocket = null;
        ExecutorService service = null;
        try {
            datagramSocket = new MulticastSocket(this.port);
            datagramSocket.joinGroup(this.group);
            service = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("GangliaListener"));
            byte[] buffer = new byte[1500];
            DatagramPacket packet = new DatagramPacket(buffer, 0, buffer.length);
            this.listening = true;
            block5: while (true) {
                try {
                    while (true) {
                        datagramSocket.receive(packet);
                        if (Thread.interrupted()) break block5;
                        IGangliaMessage msg = this.decodeRecord(packet.getData(), packet.getOffset(), packet.getLength());
                        if (msg == null) continue;
                        service.submit(new DispatchTask(this.handler, msg));
                    }
                }
                catch (Throwable t) {
                    log.warn(t, t);
                    continue;
                }
                break;
            }
            Void void_ = null;
            return void_;
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            this.listening = false;
        }
    }

    protected IGangliaMessage decodeRecord(byte[] data, int off, int len) {
        if (log.isTraceEnabled()) {
            log.trace(BytesUtil.toString(data, off, len));
        }
        return this.decoder.decode(data, off, len);
    }

    public static void main(String[] args) throws Exception {
        IGangliaMessageHandler handler = new IGangliaMessageHandler(){

            @Override
            public void accept(IGangliaMessage msg) {
                System.out.println(msg.toString());
            }
        };
        GangliaListener listener = new GangliaListener(handler);
        listener.call();
    }

    private static class DispatchTask
    implements Callable<Void> {
        private final IGangliaMessageHandler handler;
        private final IGangliaMessage msg;

        public DispatchTask(IGangliaMessageHandler handler, IGangliaMessage msg) {
            this.handler = handler;
            this.msg = msg;
        }

        @Override
        public Void call() throws Exception {
            try {
                if (log.isDebugEnabled()) {
                    log.debug(this.msg);
                }
                this.handler.accept(this.msg);
            }
            catch (Throwable t) {
                log.warn(this.msg, t);
            }
            return null;
        }
    }
}

