/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.DefaultMetadataFactory;
import com.bigdata.ganglia.GangliaCoreMetricDecls;
import com.bigdata.ganglia.GangliaListener;
import com.bigdata.ganglia.GangliaMessageDecoder31;
import com.bigdata.ganglia.GangliaMessageEncoder31;
import com.bigdata.ganglia.GangliaMetadataFactory;
import com.bigdata.ganglia.GangliaRequestMessage;
import com.bigdata.ganglia.GangliaSender;
import com.bigdata.ganglia.GangliaSlopeEnum;
import com.bigdata.ganglia.GangliaState;
import com.bigdata.ganglia.HostReport;
import com.bigdata.ganglia.HostReportComparator;
import com.bigdata.ganglia.IGangliaDefaults;
import com.bigdata.ganglia.IGangliaMessage;
import com.bigdata.ganglia.IGangliaMessageDecoder;
import com.bigdata.ganglia.IGangliaMessageEncoder;
import com.bigdata.ganglia.IGangliaMessageHandler;
import com.bigdata.ganglia.IGangliaMetadataFactory;
import com.bigdata.ganglia.IGangliaMetadataMessage;
import com.bigdata.ganglia.IGangliaMetricMessage;
import com.bigdata.ganglia.IGangliaMetricsCollector;
import com.bigdata.ganglia.IGangliaMetricsReporter;
import com.bigdata.ganglia.IGangliaRequestMessage;
import com.bigdata.ganglia.IGangliaState;
import com.bigdata.ganglia.IHostReport;
import com.bigdata.ganglia.RichMetricFactory;
import com.bigdata.ganglia.RichMetricMessage;
import com.bigdata.ganglia.TimestampMetricValue;
import com.bigdata.ganglia.util.DaemonThreadFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class GangliaService
implements Runnable,
IGangliaMetricsReporter {
    private static final Logger log = Logger.getLogger(GangliaService.class);
    private final AtomicLong serviceStartTime = new AtomicLong();
    private final String hostName;
    private final String serviceName;
    private final InetSocketAddress[] metricsServers;
    private final InetAddress listenGroup;
    private final int listenPort;
    private final boolean listen;
    private final boolean report;
    private final boolean mock;
    private final int quietPeriod;
    private final int initialDelay;
    private final int heartbeatInterval;
    private final int monitoringInterval;
    private final int globalDMax;
    private final RichMetricFactory metricFactory;
    private final IGangliaMessageDecoder messageDecoder;
    private final IGangliaMessageEncoder messageEncoder;
    private final GangliaState gangliaState;
    private ExecutorService sendService = null;
    private ExecutorService listenService = null;
    private ScheduledExecutorService scheduledService = null;
    private GangliaSender gangliaSender = null;
    private FutureTask<Void> listenerFuture = null;
    private static final String[] defaultHostReportOn = new String[]{"cpu_num", "procs_total", "procs_run", "load_one", "load_five", "load_fifteen", "cpu_user", "cpu_nice", "cpu_system", "cpu_idle", "cpu_wio", "gexec"};
    private static final Comparator<IHostReport> defaultHostReportComparator = new HostReportComparator("load_one", false);
    private final Object keepAlive = new Object();
    private final CopyOnWriteArraySet<IGangliaMetricsCollector> metricCollectors = new CopyOnWriteArraySet();
    public static final String HOSTNAME = "com.bigdata.hostname";

    public String[] getDefaultHostReportOn() {
        return Arrays.copyOf(defaultHostReportOn, defaultHostReportOn.length);
    }

    public GangliaService(String serviceName) throws UnknownHostException {
        this(GangliaService.getCanonicalHostName(), serviceName, new InetSocketAddress[]{new InetSocketAddress("239.2.11.71", 8649)}, InetAddress.getByName("239.2.11.71"), 8649, true, true, false, 600, 20, 0, 20, 3600, new GangliaMetadataFactory(new DefaultMetadataFactory("", IGangliaDefaults.DEFAULT_SLOPE, 180, 3600)));
    }

    public GangliaService(String hostName, String serviceName, InetSocketAddress[] metricsServers, InetAddress listenGroup, int listenPort, boolean listen, boolean report, boolean mock, int quietPeriod, int initialDelay, int heartbeatInterval, int monitoringInterval, int globalDMax, IGangliaMetadataFactory metadataFactory) {
        if (hostName == null) {
            throw new IllegalArgumentException();
        }
        if (serviceName == null) {
            throw new IllegalArgumentException();
        }
        if (metricsServers == null || metricsServers.length == 0) {
            throw new IllegalArgumentException();
        }
        if (listenGroup == null) {
            throw new IllegalArgumentException();
        }
        if (listenPort <= 0) {
            throw new IllegalArgumentException();
        }
        if (quietPeriod < 0) {
            throw new IllegalArgumentException();
        }
        if (initialDelay <= 0) {
            throw new IllegalArgumentException();
        }
        if (heartbeatInterval < 0) {
            throw new IllegalArgumentException();
        }
        if (monitoringInterval <= 0) {
            throw new IllegalArgumentException();
        }
        if (globalDMax <= 0) {
            throw new IllegalArgumentException();
        }
        if (metadataFactory == null) {
            throw new IllegalArgumentException();
        }
        this.hostName = hostName;
        this.serviceName = serviceName;
        this.metricsServers = metricsServers;
        this.listenGroup = listenGroup;
        this.listenPort = listenPort;
        this.listen = listen;
        this.report = report;
        this.mock = mock;
        this.quietPeriod = quietPeriod;
        this.initialDelay = initialDelay;
        this.heartbeatInterval = heartbeatInterval;
        this.monitoringInterval = monitoringInterval;
        this.globalDMax = globalDMax;
        this.messageEncoder = new GangliaMessageEncoder31();
        this.messageDecoder = new GangliaMessageDecoder31();
        this.metricFactory = new RichMetricFactory();
        this.gangliaState = new GangliaState(hostName, metadataFactory);
    }

    protected long uptime() {
        long t = this.serviceStartTime.get();
        if (t == 0L) {
            throw new IllegalStateException("Not running.");
        }
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - t);
    }

    protected boolean isQuietPeriod() {
        return this.uptime() < (long)this.quietPeriod;
    }

    protected boolean isListening() {
        if (!this.listen) {
            return false;
        }
        FutureTask<Void> f = this.listenerFuture;
        if (f == null) {
            return false;
        }
        return !f.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block25: {
            GangliaListener gangliaListener = null;
            try {
                DaemonThreadFactory threadFactory = new DaemonThreadFactory("GangliaService");
                if (!this.serviceStartTime.compareAndSet(0L, System.currentTimeMillis())) {
                    throw new IllegalStateException("Already running.");
                }
                if (this.listen) {
                    this.listenService = Executors.newSingleThreadExecutor(threadFactory);
                }
                if (this.report) {
                    this.sendService = Executors.newSingleThreadExecutor(threadFactory);
                }
                this.scheduledService = Executors.newScheduledThreadPool(3, threadFactory);
                this.gangliaSender = new GangliaSender(this.metricsServers, 1500);
                if (this.listen) {
                    gangliaListener = new GangliaListener(this.listenGroup, this.listenPort, this.messageDecoder, new GangliaServiceHandler());
                    this.listenerFuture = new FutureTask<Void>(gangliaListener);
                    this.listenService.submit(this.listenerFuture);
                }
                if (this.report) {
                    if (this.heartbeatInterval > 0) {
                        this.scheduledService.scheduleWithFixedDelay(new HeartBeatTask(), this.initialDelay, this.heartbeatInterval, TimeUnit.SECONDS);
                    }
                    this.scheduledService.scheduleAtFixedRate(new GatherMetricsTask(), this.initialDelay, this.monitoringInterval, TimeUnit.SECONDS);
                    this.scheduledService.scheduleAtFixedRate(new PurgeMetricsTask(), 60L, 60L, TimeUnit.SECONDS);
                }
                if (log.isInfoEnabled()) {
                    log.info("Running on " + this.hostName + " for " + this.serviceName);
                }
                if (this.listen) {
                    this.listenerFuture.get();
                    break block25;
                }
                Object object = this.keepAlive;
                synchronized (object) {
                    try {
                        this.keepAlive.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
            catch (InterruptedException t) {
            }
            catch (Throwable t) {
                log.error(t, t);
            }
            finally {
                if (this.listenerFuture != null) {
                    this.listenerFuture.cancel(true);
                }
                if (this.listenService != null) {
                    this.listenService.shutdownNow();
                }
                if (this.gangliaSender != null) {
                    this.sendMessage(new GangliaRequestMessage(this.hostName, "shutdown", false));
                }
                if (this.sendService != null) {
                    this.sendService.shutdownNow();
                }
                if (this.gangliaSender != null) {
                    this.gangliaSender.close();
                }
                this.gangliaState.reset();
                this.serviceStartTime.set(0L);
            }
        }
    }

    protected void sendMessage(IGangliaMessage msg) {
        block7: {
            if (msg == null) {
                log.error("No message");
            }
            ExecutorService service = this.sendService;
            if (this.sendService != null) {
                try {
                    if (this.mock) {
                        if (log.isInfoEnabled()) {
                            log.info(msg);
                        }
                    } else {
                        service.submit(new SendMessage31(msg));
                    }
                }
                catch (RejectedExecutionException ex) {
                    if (!log.isInfoEnabled()) break block7;
                    log.info(ex);
                }
            }
        }
    }

    protected void gatherMetrics() {
        for (IGangliaMetricsCollector c : this.metricCollectors) {
            try {
                c.collect(this);
            }
            catch (Throwable t) {
                log.warn(t, t);
            }
        }
    }

    public boolean addMetricCollector(IGangliaMetricsCollector c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        return this.metricCollectors.add(c);
    }

    public boolean removeMetricCollector(IGangliaMetricsCollector c) {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        return this.metricCollectors.remove(c);
    }

    @Override
    public void setMetric(String metricName, Object value) {
        GangliaSender sender = this.gangliaSender;
        if (sender != null) {
            try {
                if (metricName == null) {
                    log.warn("Metric was emitted with no name.");
                    return;
                }
                if (value == null) {
                    log.warn("Metric was emitted with a null value: metricName=" + metricName);
                    return;
                }
                IGangliaMetadataMessage decl = this.gangliaState.getMetadata(metricName);
                if (decl == null) {
                    decl = this.gangliaState.getMetadataFactory().newDecl(this.hostName, metricName, value);
                    if (decl == null) {
                        log.error("Could not declare: " + metricName);
                        return;
                    }
                    decl = this.gangliaState.putIfAbsent(decl);
                }
                TimestampMetricValue tmv = this.gangliaState.getMetric(this.getHostName(), decl.getMetricName());
                assert (tmv != null);
                assert (decl == tmv.getMetadata());
                if (tmv.getTimestamp() == 0L) {
                    this.sendMessage(tmv.getMetadata());
                }
                if (tmv.setValue(value)) {
                    tmv.update();
                    RichMetricMessage msg = this.metricFactory.newMetricMessage(this.getHostName(), decl, false, value);
                    this.sendMessage(msg);
                }
            }
            catch (Throwable e) {
                log.warn(e, e);
            }
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public IGangliaState getGangliaState() {
        return this.gangliaState;
    }

    public IGangliaMetadataFactory getMetadataFactory() {
        return this.gangliaState.getMetadataFactory();
    }

    public IHostReport[] getHostReport() {
        return this.getHostReport(defaultHostReportOn, defaultHostReportComparator);
    }

    public IHostReport[] getHostReport(String[] reportOn, Comparator<IHostReport> comparator) {
        String[] hosts = this.gangliaState.getKnownHosts();
        return this.getHostReport(hosts, reportOn, comparator);
    }

    public IHostReport[] getHostReport(String[] hosts, String[] reportOn, Comparator<IHostReport> comparator) {
        if (reportOn == null || reportOn.length == 0) {
            throw new IllegalArgumentException();
        }
        IHostReport[] a = new IHostReport[hosts.length];
        for (int i = 0; i < a.length; ++i) {
            String hostName = hosts[i];
            LinkedHashMap<String, IGangliaMetricMessage> m = new LinkedHashMap<String, IGangliaMetricMessage>();
            for (String metricName : reportOn) {
                Object value;
                TimestampMetricValue tmv = this.gangliaState.getMetric(hostName, metricName);
                if (tmv == null || (value = tmv.getValue()) == null) continue;
                RichMetricMessage metricValue = this.metricFactory.newMetricMessage(hostName, tmv.getMetadata(), false, value);
                if (log.isDebugEnabled()) {
                    log.debug("host=" + hostName + ", metric=" + metricName + ", value=" + value + ", record=" + metricValue);
                }
                m.put(metricName, metricValue);
            }
            a[i] = new HostReport(hostName, m);
        }
        if (comparator != null) {
            Arrays.sort(a, comparator);
        }
        return a;
    }

    public static final String getCanonicalHostName() {
        String s = System.getProperty(HOSTNAME);
        if (s != null) {
            s = s.trim();
        }
        if (s != null && s.length() != 0) {
            log.warn("Hostname override: hostname=" + s);
        } else {
            try {
                s = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (Throwable t) {
                log.warn("Could not resolve canonical name for host: " + t);
            }
            try {
                s = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable t) {
                log.warn("Could not resolve name for host: " + t);
                s = "localhost";
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String hostName = GangliaService.getCanonicalHostName();
        String serviceName = GangliaService.class.getSimpleName();
        int quietPeriod = 600;
        int initialDelay = 20;
        boolean heartbeatInterval = false;
        int monitoringInterval = 20;
        InetAddress listenGroup = InetAddress.getByName("239.2.11.71");
        int listenPort = 8649;
        String defaultUnits = "";
        GangliaSlopeEnum defaultSlope = IGangliaDefaults.DEFAULT_SLOPE;
        int defaultTMax = 180;
        int defaultDMax = 3600;
        InetSocketAddress[] metricsServers = new InetSocketAddress[]{new InetSocketAddress("239.2.11.71", 8649)};
        GangliaMetadataFactory metadataFactory = new GangliaMetadataFactory(new DefaultMetadataFactory("", defaultSlope, 180, 3600));
        GangliaService service = null;
        service = new GangliaService(hostName, serviceName, metricsServers, listenGroup, 8649, true, true, false, 600, 20, 0, 20, 3600, metadataFactory);
        service.run();
    }

    private class GatherMetricsTask
    implements Runnable {
        private GatherMetricsTask() {
        }

        @Override
        public void run() {
            try {
                GangliaService.this.gatherMetrics();
            }
            catch (Throwable t) {
                log.warn(t, t);
            }
        }
    }

    private class PurgeMetricsTask
    implements Runnable {
        private PurgeMetricsTask() {
        }

        @Override
        public void run() {
        }
    }

    private class HeartBeatTask
    implements Runnable {
        @Override
        public void run() {
            try {
                IGangliaMetadataMessage decl = GangliaService.this.gangliaState.getMetadata("heartbeat");
                if (decl == null) {
                    decl = GangliaService.this.gangliaState.putIfAbsent(GangliaCoreMetricDecls.heartbeat(GangliaService.this.hostName, GangliaService.this.heartbeatInterval));
                }
                long value = TimeUnit.MILLISECONDS.toSeconds(GangliaService.this.serviceStartTime.get());
                RichMetricMessage msg = GangliaService.this.metricFactory.newMetricMessage(GangliaService.this.getHostName(), decl, false, value);
                GangliaService.this.sendMessage(msg);
            }
            catch (Throwable t) {
                log.warn(t, t);
            }
        }
    }

    private class SendMessage31
    implements Callable<Void> {
        private final IGangliaMessage msg;

        public SendMessage31(IGangliaMessage msg) {
            if (msg == null) {
                throw new IllegalArgumentException();
            }
            this.msg = msg;
        }

        @Override
        public Void call() throws Exception {
            GangliaSender tmp = GangliaService.this.gangliaSender;
            if (GangliaService.this.gangliaSender != null) {
                if (this.msg.isMetricMetadata()) {
                    GangliaService.this.messageEncoder.writeMetadata(tmp.xdr, (IGangliaMetadataMessage)this.msg);
                } else if (this.msg.isMetricRequest()) {
                    GangliaService.this.messageEncoder.writeRequest(tmp.xdr, (IGangliaRequestMessage)this.msg);
                } else if (this.msg.isMetricValue()) {
                    GangliaService.this.messageEncoder.writeMetric(tmp.xdr, ((RichMetricMessage)this.msg).getMetadata(), (IGangliaMetricMessage)this.msg);
                } else {
                    throw new AssertionError();
                }
                tmp.sendMessage(tmp.xdr);
            }
            return null;
        }
    }

    private class GangliaServiceHandler
    implements IGangliaMessageHandler {
        private GangliaServiceHandler() {
        }

        @Override
        public void accept(IGangliaMessage msg) {
            if (msg == null) {
                return;
            }
            if (msg.isMetricRequest()) {
                if (GangliaService.this.isQuietPeriod()) {
                    return;
                }
                TimestampMetricValue tmv = GangliaService.this.gangliaState.getMetric(GangliaService.this.hostName, msg.getMetricName());
                if (tmv != null && tmv.getTimestamp() != 0L) {
                    tmv.resetTimestamp();
                    if (log.isInfoEnabled()) {
                        log.info("Reset metric timestamp: " + msg.toString());
                    }
                }
            } else if (msg.isMetricMetadata()) {
                if (GangliaService.this.gangliaState.putIfAbsent((IGangliaMetadataMessage)msg) == null && log.isInfoEnabled()) {
                    log.info("declared by host: " + msg.toString());
                }
            } else if (msg.isMetricValue()) {
                if (GangliaService.this.gangliaState.getMetadata(msg.getMetricName()) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("No metadata for metric: " + msg.getMetricName());
                    }
                    GangliaService.this.sendMessage(new GangliaRequestMessage(GangliaService.this.hostName, msg.getMetricName(), false));
                    return;
                }
                IGangliaMetricMessage m2 = (IGangliaMetricMessage)msg;
                TimestampMetricValue tmv = GangliaService.this.gangliaState.getMetric(msg.getHostName(), msg.getMetricName());
                assert (tmv != null);
                tmv.setValue(m2.getValue());
                if (log.isDebugEnabled()) {
                    log.debug("Updated value: " + msg);
                }
            } else {
                log.error("Unknown message type: " + msg);
            }
        }
    }
}

