/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.IGangliaMetadataFactory;
import com.bigdata.ganglia.IGangliaMetadataMessage;
import com.bigdata.ganglia.IGangliaState;
import com.bigdata.ganglia.TimestampMetricValue;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class GangliaState
implements IGangliaState {
    private static final Logger log = Logger.getLogger(GangliaState.class);
    private final String hostName;
    private final IGangliaMetadataFactory metadataFactory;
    private final ConcurrentHashMap<String, IGangliaMetadataMessage> metadata;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, TimestampMetricValue>> knownHosts;

    public GangliaState(String hostName, IGangliaMetadataFactory metadataFactory) {
        if (hostName == null) {
            throw new IllegalArgumentException();
        }
        if (metadataFactory == null) {
            throw new IllegalArgumentException();
        }
        this.hostName = hostName;
        this.metadataFactory = metadataFactory;
        this.metadata = new ConcurrentHashMap();
        this.knownHosts = new ConcurrentHashMap();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    public IGangliaMetadataFactory getMetadataFactory() {
        return this.metadataFactory;
    }

    @Override
    public String[] getKnownHosts() {
        return this.knownHosts.keySet().toArray(new String[0]);
    }

    public Iterator<TimestampMetricValue> iterator(String hostName) {
        this.assertValidHostName(hostName);
        ConcurrentHashMap<String, TimestampMetricValue> hostMetrics = this.knownHosts.get(hostName);
        if (hostMetrics == null) {
            return Collections.emptyList().iterator();
        }
        return hostMetrics.values().iterator();
    }

    @Override
    public IGangliaMetadataMessage getMetadata(String metricName) {
        return this.metadata.get(metricName);
    }

    public IGangliaMetadataMessage putIfAbsent(IGangliaMetadataMessage decl) {
        IGangliaMetadataMessage resolved = this.metadataFactory.resolve(decl);
        if (resolved == null) {
            throw new RuntimeException("Resolution error for " + decl);
        }
        if (!decl.getMetricName().equals(resolved.getMetricName())) {
            throw new RuntimeException("Resolution error: decl=" + decl + ", but resolved metricName=" + resolved.getMetricName());
        }
        IGangliaMetadataMessage tmp = this.metadata.putIfAbsent(decl.getMetricName(), resolved);
        if (tmp == null) {
            if (log.isInfoEnabled()) {
                log.info("declared: " + resolved);
            }
            return resolved;
        }
        return tmp;
    }

    private ConcurrentHashMap<String, TimestampMetricValue> getHostCounters(String hostName) {
        ConcurrentHashMap<String, TimestampMetricValue> tmp;
        this.assertValidHostName(hostName);
        ConcurrentHashMap<String, TimestampMetricValue> hostCounters = this.knownHosts.get(hostName);
        if (hostCounters == null && (tmp = this.knownHosts.putIfAbsent(hostName, hostCounters = new ConcurrentHashMap())) != null) {
            hostCounters = tmp;
        }
        return hostCounters;
    }

    private void assertValidHostName(String hostName) {
        if (hostName == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public TimestampMetricValue getMetric(String hostName, String metricName) {
        TimestampMetricValue tmp;
        this.assertValidHostName(hostName);
        if (metricName == null) {
            throw new IllegalArgumentException();
        }
        IGangliaMetadataMessage decl = this.getMetadata(metricName);
        if (decl == null) {
            return null;
        }
        ConcurrentHashMap<String, TimestampMetricValue> hostCounters = this.getHostCounters(hostName);
        TimestampMetricValue old = hostCounters.putIfAbsent(metricName, tmp = new TimestampMetricValue(decl));
        if (old != null) {
            return old;
        }
        if (log.isDebugEnabled()) {
            log.debug("declared: host=" + hostName + ", decl" + decl);
        }
        return tmp;
    }

    public void purgeOldHostsAndMetrics(int dmax) {
        String[] knownHosts;
        for (String hostName : knownHosts = this.getKnownHosts()) {
            if (this.purgeOldHost(hostName, dmax)) continue;
            this.purgeOldMetrics(hostName);
        }
    }

    private boolean purgeOldHost(String hostName, int dmax) {
        if (dmax == 0) {
            return false;
        }
        ConcurrentHashMap<String, TimestampMetricValue> hostCounters = this.knownHosts.get(hostName);
        if (hostCounters == null) {
            return false;
        }
        TimestampMetricValue tmv = hostCounters.get("heartbeat");
        int minAge = Integer.MAX_VALUE;
        if (tmv != null) {
            minAge = tmv.getAge();
        } else {
            for (TimestampMetricValue tmv2 : hostCounters.values()) {
                int age = tmv2.getAge();
                if (age >= minAge) continue;
                minAge = age;
                tmv = tmv2;
            }
        }
        if (minAge > dmax) {
            this.deleteHost(hostName);
            log.warn("Purged host: " + hostName + ", last update was " + minAge + " seconds ago for " + tmv.getMetadata().getMetricName());
            return true;
        }
        return false;
    }

    private void purgeOldMetrics(String hostName) {
        ConcurrentHashMap<String, TimestampMetricValue> hostCounters = this.knownHosts.get(hostName);
        if (hostCounters == null) {
            return;
        }
        for (TimestampMetricValue tmv : hostCounters.values()) {
            int age;
            int dmax = tmv.getMetadata().getDMax();
            if (dmax == 0 || (age = tmv.getAge()) <= dmax) continue;
            hostCounters.remove(tmv.getMetadata().getMetricName(), tmv);
            if (!log.isInfoEnabled()) continue;
            log.info("Purged metric=" + tmv.getMetadata().getMetricName() + " for host=" + hostName + ", last update was " + age + " seconds ago");
        }
    }

    public void deleteHost(String hostName) {
        if (hostName == null) {
            throw new IllegalArgumentException();
        }
        this.knownHosts.remove(hostName);
    }

    public void reset() {
        this.metadata.clear();
        this.knownHosts.clear();
    }
}

