/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.gom.om;

import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.gom.gpo.GPO;
import com.bigdata.gom.gpo.IGPO;
import com.bigdata.gom.om.ObjectMgrModel;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.Sesame2BigdataIterator;
import com.bigdata.rdf.sparql.ast.cache.CacheConnectionFactory;
import com.bigdata.rdf.sparql.ast.cache.ICacheConnection;
import com.bigdata.rdf.sparql.ast.cache.IDescribeCache;
import com.bigdata.striterator.CloseableIteratorWrapper;
import cutthecrap.utils.striterators.ICloseableIterator;
import info.aduna.iteration.CloseableIteration;
import java.util.List;
import org.apache.log4j.Logger;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;

public class ObjectManager
extends ObjectMgrModel {
    private static final Logger log = Logger.getLogger(ObjectManager.class);
    private final BigdataSailRepository m_repo;
    private final boolean readOnly;
    private final IDescribeCache m_describeCache;

    public ObjectManager(String endpoint, BigdataSailRepository cxn) throws RepositoryException {
        super(endpoint, (BigdataValueFactory)cxn.getValueFactory());
        this.m_repo = cxn;
        this.readOnly = !cxn.isWritable();
        QueryEngine queryEngine = QueryEngineFactory.getInstance().getStandaloneQueryController((Journal)this.m_repo.getSail().getIndexManager());
        ICacheConnection cacheConn = CacheConnectionFactory.getExistingCacheConnection(queryEngine);
        this.m_describeCache = cacheConn != null ? null : null;
    }

    public void setMaxDataListSize(int newValue) {
        if (newValue <= 0) {
            throw new IllegalArgumentException();
        }
        this.m_maxDirtyListSize = newValue;
    }

    public BigdataSailRepository getRepository() {
        return this.m_repo;
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this.m_repo.getSail().isOpen()) {
                this.m_repo.shutDown();
            }
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ICloseableIterator<BindingSet> evaluate(String query) {
        BigdataSailRepositoryConnection cxn;
        try {
            cxn = this.getQueryConnection();
        }
        catch (RepositoryException e1) {
            throw new RuntimeException(e1);
        }
        try {
            TupleQuery q = cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
            TupleQueryResult res = q.evaluate();
            return new Sesame2BigdataIterator<BindingSet, QueryEvaluationException>((CloseableIteration)res){

                @Override
                public void close() {
                    super.close();
                    try {
                        cxn.close();
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (Throwable t) {
            try {
                cxn.close();
            }
            catch (RepositoryException e) {
                log.error(e, e);
            }
            throw new RuntimeException("query=" + query, t);
        }
    }

    @Override
    public ICloseableIterator<Statement> evaluateGraph(String query) {
        BigdataSailRepositoryConnection cxn;
        try {
            cxn = this.getQueryConnection();
        }
        catch (RepositoryException e1) {
            throw new RuntimeException(e1);
        }
        try {
            GraphQuery q = cxn.prepareGraphQuery(QueryLanguage.SPARQL, query);
            GraphQueryResult res = q.evaluate();
            return new Sesame2BigdataIterator<Statement, QueryEvaluationException>((CloseableIteration)res){

                @Override
                public void close() {
                    super.close();
                    try {
                        cxn.close();
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        catch (Throwable t) {
            try {
                cxn.close();
            }
            catch (RepositoryException e) {
                log.error(e, e);
            }
            throw new RuntimeException("query=" + query, t);
        }
    }

    @Override
    public void execute(String updateStr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    protected void materializeWithDescribe(IGPO gpo) {
        IV<?, ?> iv;
        Graph g;
        if (gpo == null) {
            throw new IllegalArgumentException();
        }
        if (this.m_describeCache != null && (g = this.m_describeCache.lookup(iv = this.addResolveIV(gpo))) != null) {
            this.initGPO((GPO)gpo, new CloseableIteratorWrapper<Statement>(g.iterator()));
            return;
        }
        super.materializeWithDescribe(gpo);
    }

    private IV<?, ?> addResolveIV(IGPO gpo) {
        BigdataResource id = gpo.getId();
        IV iv = id.getIV();
        if (iv == null) {
            BigdataValue[] values = new BigdataValue[]{id};
            BigdataSailRepositoryConnection conn = null;
            try {
                conn = this.getQueryConnection();
                conn.getTripleStore().getLexiconRelation().addTerms(values, values.length, this.readOnly);
                iv = id.getIV();
            }
            catch (RepositoryException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (RepositoryException ex2) {
                        log.warn(ex2, ex2);
                    }
                }
            }
        }
        return iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushStatements(List<Statement> m_inserts, List<Statement> m_removes) {
        BigdataSailRepositoryConnection cxn = null;
        try {
            cxn = this.getConnection();
            for (Statement stmt : m_removes) {
                cxn.remove(stmt, new Resource[0]);
            }
            for (Statement stmt : m_inserts) {
                cxn.add(stmt, new Resource[0]);
            }
            cxn.commit();
        }
        catch (Throwable t) {
            if (cxn != null) {
                try {
                    cxn.rollback();
                }
                catch (RepositoryException e) {
                    log.error(e, e);
                }
            }
        }
        finally {
            if (cxn != null) {
                try {
                    cxn.close();
                }
                catch (RepositoryException e) {
                    log.error(e, e);
                }
            }
        }
    }

    private BigdataSailRepositoryConnection getConnection() throws RepositoryException {
        BigdataSailRepositoryConnection c = this.m_repo.getConnection();
        c.setAutoCommit(false);
        return c;
    }

    private BigdataSailRepositoryConnection getQueryConnection() throws RepositoryException {
        BigdataSailRepositoryConnection c = this.m_repo.getReadOnlyConnection();
        return c;
    }
}

