/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.gom.om;

import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.gom.gpo.GPO;
import com.bigdata.gom.gpo.IGPO;
import com.bigdata.gom.om.IDGenerator;
import com.bigdata.gom.om.IIDGenerator;
import com.bigdata.gom.om.IObjectManager;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;

public abstract class ObjectMgrModel
implements IObjectManager {
    private static final Logger log = Logger.getLogger(ObjectMgrModel.class);
    private final UUID m_uuid;
    protected final BigdataValueFactory m_valueFactory;
    private final IIDGenerator m_idGenerator;
    private final ConcurrentWeakValueCache<Object, IGPO> m_dict;
    private final ConcurrentHashMap<BigdataURI, BigdataURI> m_internedKeys = new ConcurrentHashMap();
    private final List<GPO> m_dirtyGPOs = new ArrayList<GPO>();
    private final URI s_nmeMgr;
    private final Lock lock = new ReentrantLock();
    protected int m_maxDirtyListSize = Integer.MAX_VALUE;
    private int m_transactionCounter = 0;
    long m_materialized = 0L;

    public ObjectMgrModel(String endpoint, BigdataValueFactory valueFactory) {
        this.m_valueFactory = valueFactory;
        this.m_uuid = UUID.randomUUID();
        this.m_idGenerator = new IDGenerator(endpoint, this.m_uuid, this.m_valueFactory);
        this.s_nmeMgr = this.m_valueFactory.createURI("gpo:nmeMgr/" + this.m_uuid);
        this.m_dict = new ConcurrentWeakValueCache(1000);
    }

    public IGPO getDefaultNameMgr() {
        return this.getGPO(this.s_nmeMgr);
    }

    @Override
    public UUID getID() {
        return this.m_uuid;
    }

    @Override
    public final BigdataValueFactory getValueFactory() {
        return this.m_valueFactory;
    }

    public BigdataURI internKey(URI aKey) {
        BigdataURI key = this.m_valueFactory.asValue(aKey);
        BigdataURI old = this.m_internedKeys.putIfAbsent(key, key);
        BigdataURI uri = old != null ? old : key;
        return uri;
    }

    public <T> T bestEffortIntern(T t) {
        if (t instanceof Resource) {
            IGPO gpo = this.m_dict.get(t);
            if (gpo == null) {
                return t;
            }
            return (T)gpo.getId();
        }
        return t;
    }

    public void addToDirtyList(GPO gpo) {
        if (gpo == null) {
            throw new IllegalArgumentException();
        }
        if (!gpo.isDirty()) {
            throw new IllegalStateException();
        }
        this.m_dirtyGPOs.add(gpo);
        if (this.m_dirtyGPOs.size() > this.m_maxDirtyListSize) {
            if (log.isTraceEnabled()) {
                log.trace("Incremental flush of dirty objects");
            }
            this.flushDirtyObjects();
        }
    }

    public int getDirtyObjectCount() {
        return this.m_dirtyGPOs.size();
    }

    private void flushDirtyObjects() {
        long start = System.currentTimeMillis();
        long count = this.m_dirtyGPOs.size();
        LinkedList<Statement> inserts = new LinkedList<Statement>();
        LinkedList<Statement> removes = new LinkedList<Statement>();
        Iterator<GPO> updates = this.m_dirtyGPOs.iterator();
        while (updates.hasNext()) {
            updates.next().prepareBatchUpdate(inserts, removes);
        }
        this.flushStatements(inserts, removes);
        Iterator<GPO> updates2 = this.m_dirtyGPOs.iterator();
        while (updates2.hasNext()) {
            updates2.next().doCommit();
        }
        this.m_dirtyGPOs.clear();
        if (log.isTraceEnabled()) {
            log.trace("Flush took " + (System.currentTimeMillis() - start) + "ms for " + count + " objects");
        }
    }

    protected abstract void flushStatements(List<Statement> var1, List<Statement> var2);

    @Override
    public IGPO getGPO(Resource id) {
        IGPO tmp;
        IGPO ret = this.m_dict.get(id);
        if (ret == null && (tmp = this.m_dict.putIfAbsent(id, ret = new GPO(this, id))) != null) {
            ret = tmp;
        }
        return ret;
    }

    @Override
    public IGPO getGPO(Statement stmt) {
        IGPO tmp;
        BigdataBNode id = this.m_valueFactory.createBNode(stmt.toString());
        id.setStatementIdentifier(true);
        IGPO ret = this.m_dict.get(id);
        if (ret == null && (tmp = this.m_dict.putIfAbsent(id, ret = new GPO(this, id, stmt))) != null) {
            ret = tmp;
        }
        return ret;
    }

    @Override
    public Iterator<WeakReference<IGPO>> getGPOs() {
        return this.m_dict.iterator();
    }

    @Override
    public void materialize(IGPO gpo) {
        if (gpo == null) {
            throw new IllegalArgumentException();
        }
        if (log.isTraceEnabled()) {
            log.trace("Materializing: " + gpo.getId());
        }
        ((GPO)gpo).dematerialize();
        this.materializeWithDescribe(gpo);
    }

    protected void materializeWithDescribe(IGPO gpo) {
        String query = "DESCRIBE <" + gpo.getId().toString() + ">";
        this.initGPO((GPO)gpo, this.evaluateGraph(query));
        ++this.m_materialized;
        if (this.m_materialized % 10000L == 0L) {
            System.out.println("Materialized: " + this.m_materialized + ", dictionary: " + this.m_dict.size() + ", m_dirtyGPOs: " + this.m_dirtyGPOs.size());
        }
    }

    protected void materializeWithSelect(IGPO gpo) {
        String query = "SELECT ?p ?v WHERE {<" + gpo.getId().toString() + "> ?p ?v}";
        ICloseableIterator<BindingSet> res = this.evaluate(query);
        while (res.hasNext()) {
            BindingSet bs = (BindingSet)res.next();
            ((GPO)gpo).initValue((URI)bs.getValue("p"), bs.getValue("v"));
        }
    }

    @Override
    public Map<Resource, IGPO> initGPOs(ICloseableIterator<Statement> itr) {
        return this.initGPO(null, itr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Resource, IGPO> initGPO(GPO gpo, ICloseableIterator<Statement> stmts) {
        Map<Object, Object> map = gpo != null ? Collections.singletonMap(gpo.getId(), gpo) : new HashMap();
        try {
            BigdataResource id = gpo == null ? null : gpo.getId();
            int statements = 0;
            while (stmts.hasNext()) {
                Statement stmt = (Statement)stmts.next();
                Resource subject = stmt.getSubject();
                URI predicate = stmt.getPredicate();
                Value value = stmt.getObject();
                if (id != null) {
                    if (subject.equals(id)) {
                        gpo.initValue(predicate, value);
                    } else {
                        gpo.initLinkValue(predicate, subject);
                    }
                } else {
                    GPO tmp = (GPO)this.getGPO(subject);
                    tmp.initValue(predicate, value);
                    map.put(tmp.getId(), tmp);
                    if (value instanceof Resource) {
                        tmp = (GPO)this.getGPO((Resource)value);
                        tmp.initLinkValue(predicate, subject);
                        map.put(tmp.getId(), tmp);
                    }
                }
                ++statements;
            }
            if (log.isTraceEnabled()) {
                log.trace("Materialized: " + (gpo == null ? "null" : gpo.getId()) + " with " + statements + " statements");
            }
            HashMap<Resource, IGPO> hashMap = map;
            return hashMap;
        }
        finally {
            stmts.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int beginNativeTransaction() {
        this.lock.lock();
        try {
            int n = this.m_transactionCounter++;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int commitNativeTransaction(int expectedCounter) {
        this.lock.lock();
        try {
            int ret = --this.m_transactionCounter;
            if (ret != expectedCounter) {
                throw new IllegalArgumentException("Unexpected transaction counter");
            }
            if (ret == 0) {
                this.flushDirtyObjects();
            }
            int n = ret;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNativeTransactionCounter() {
        this.lock.lock();
        try {
            int n = this.m_transactionCounter;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackNativeTransaction() {
        this.lock.lock();
        try {
            this.clearCache();
            this.m_transactionCounter = 0;
            if (this.m_idGenerator != null) {
                this.m_idGenerator.rollback();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public IGPO createGPO() {
        URI uri = this.m_idGenerator.genId();
        GPO ret = (GPO)this.getGPO(uri);
        ret.setMaterialized(true);
        return ret;
    }

    @Override
    public final void remove(IGPO gpo) {
        gpo.remove();
    }

    @Override
    @Deprecated
    public void save(URI key, Value value) {
        this.getGPO(this.s_nmeMgr).setValue(key, value);
    }

    @Override
    @Deprecated
    public Value recall(URI key) {
        return this.getGPO(this.s_nmeMgr).getValue(key);
    }

    @Override
    @Deprecated
    public IGPO recallAsGPO(URI key) {
        Value val = this.recall(key);
        if (val instanceof Resource) {
            return this.getGPO((Resource)val);
        }
        return null;
    }

    @Override
    public Iterator<URI> getNames() {
        GPO nmgr = (GPO)this.getGPO(this.s_nmeMgr);
        return nmgr.getPropertyURIs();
    }

    @Override
    public void close() {
        this.clearCache();
    }

    public final void clearCache() {
        this.m_dict.clear();
        this.m_dirtyGPOs.clear();
    }

    public String encode(Resource v) {
        return v.stringValue();
    }
}

