/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.gom.skin;

import com.bigdata.gom.gpo.IGPO;
import com.bigdata.gom.gpo.IGenericSkin;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import org.apache.log4j.Logger;

public class GenericSkinRegistry {
    public static final Logger log = Logger.getLogger(GenericSkinRegistry.class);
    static Collection m_registeredClass = Collections.synchronizedCollection(new Vector());

    public static void registerClass(Class theClass) {
        if (theClass.isInterface()) {
            log.error("This is an interface, not an implementation class: " + theClass.getName());
            throw new IllegalArgumentException("This is an interface, not an implementation class: " + theClass.getName());
        }
        if (!IGenericSkin.class.isAssignableFrom(theClass)) {
            throw new IllegalArgumentException("Class MUST implement: " + IGenericSkin.class.getName());
        }
        if (!m_registeredClass.contains(theClass)) {
            m_registeredClass.add(theClass);
            log.info("Registered skin: " + theClass);
        }
    }

    public static Class getImplementationClass(Class theClassOrInterface) {
        if (theClassOrInterface == null) {
            throw new IllegalArgumentException("The class or interface may not be null.");
        }
        Class theImplementationClass = null;
        if (theClassOrInterface.isInterface()) {
            for (Class aClass : m_registeredClass) {
                if (!theClassOrInterface.isAssignableFrom(aClass)) continue;
                theImplementationClass = aClass;
                break;
            }
            if (theImplementationClass == null) {
                throw new UnsupportedOperationException("No implementation class has been registered for that interface: " + theClassOrInterface.getName());
            }
        } else if (m_registeredClass.contains(theClassOrInterface)) {
            theImplementationClass = theClassOrInterface;
        } else {
            throw new UnsupportedOperationException("No registered class matches or is assignable from the parameter: " + theClassOrInterface.getName());
        }
        return theImplementationClass;
    }

    public static IGenericSkin asClass(IGPO g, Class theClassOrInterface) throws UnsupportedOperationException {
        if (g == null) {
            log.error("The generic object may not be null.");
            throw new IllegalArgumentException("The generic object may not be null.");
        }
        if (theClassOrInterface == null) {
            log.error("The class or interface may not be null.");
            throw new IllegalArgumentException("The class or interface may not be null.");
        }
        if (theClassOrInterface.isInstance(g)) {
            return g;
        }
        Class theImplementationClass = GenericSkinRegistry.getImplementationClass(theClassOrInterface);
        try {
            return GenericSkinRegistry.mintGenericSkin(theImplementationClass, g);
        }
        catch (Throwable t) {
            log.error("Unable to morph behavior to: theClassOrInterface=" + theClassOrInterface, t);
            UnsupportedOperationException ex = new UnsupportedOperationException("Unable to morph behavior to: theClassOrInterface=" + theClassOrInterface + ", initCause=" + t);
            ex.initCause(t);
            throw ex;
        }
    }

    public static IGenericSkin mintGenericSkin(Class implClass, IGPO g) throws Exception {
        Constructor c = implClass.getDeclaredConstructor(IGPO.class);
        return (IGenericSkin)c.newInstance(g);
    }
}

