/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.gom.web;

import com.bigdata.gom.om.ObjectManager;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.store.AbstractTripleStore;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.openrdf.repository.RepositoryException;

public class GOMWebUtil {
    private static final String ATTRIBUTE_OM = ObjectManager.class.getName();

    public static ObjectManager getObjectManager(HttpServletRequest request) throws Exception {
        return GOMWebUtil.newObjectManager(request, 0L);
    }

    public static ObjectManager newObjectManager(HttpServletRequest request, long timestamp) throws RepositoryException {
        ObjectManager om = (ObjectManager)request.getAttribute(ATTRIBUTE_OM);
        if (om != null) {
            return om;
        }
        ServletContext servletContext = request.getSession().getServletContext();
        BigdataRDFContext rdfContext = GOMWebUtil.getBigdataRDFContext(servletContext);
        String endpoint = request.getRequestURL().toString();
        String namespace = rdfContext.getConfig().namespace;
        AbstractTripleStore tripleStore = (AbstractTripleStore)rdfContext.getIndexManager().getResourceLocator().locate(namespace, timestamp);
        if (tripleStore == null) {
            throw new RuntimeException("Not found: namespace=" + namespace);
        }
        BigdataSail sail = new BigdataSail(tripleStore);
        BigdataSailRepository repo = new BigdataSailRepository(sail);
        repo.initialize();
        om = new ObjectManager(endpoint, repo);
        request.setAttribute(ATTRIBUTE_OM, om);
        return om;
    }

    protected static final BigdataRDFContext getBigdataRDFContext(ServletContext servletContext) {
        return (BigdataRDFContext)GOMWebUtil.getRequiredServletContextAttribute(servletContext, BigdataRDFServlet.ATTRIBUTE_RDF_CONTEXT);
    }

    protected static <T> T getRequiredServletContextAttribute(ServletContext servletContext, String name) {
        Object v = servletContext.getAttribute(name);
        if (v == null) {
            throw new RuntimeException("Not set: " + name);
        }
        return (T)v;
    }
}

