/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha;

import com.bigdata.ha.AbstractMessageTask;
import com.bigdata.ha.CommitRequest;
import com.bigdata.ha.CommitResponse;
import com.bigdata.ha.HACommitGlue;
import com.bigdata.ha.PrepareRequest;
import com.bigdata.ha.PrepareResponse;
import com.bigdata.ha.QuorumCommit;
import com.bigdata.ha.QuorumServiceBase;
import com.bigdata.ha.msg.HA2PhaseAbortMessage;
import com.bigdata.ha.msg.HA2PhaseCommitMessage;
import com.bigdata.ha.msg.HA2PhasePrepareMessage;
import com.bigdata.ha.msg.IHA2PhaseAbortMessage;
import com.bigdata.ha.msg.IHA2PhaseCommitMessage;
import com.bigdata.ha.msg.IHA2PhasePrepareMessage;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumMember;
import com.bigdata.quorum.QuorumStateChangeListener;
import com.bigdata.quorum.QuorumStateChangeListenerBase;
import com.bigdata.quorum.ServiceLookup;
import com.bigdata.util.concurrent.ExecutionExceptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class QuorumCommitImpl<S extends HACommitGlue>
extends QuorumStateChangeListenerBase
implements QuorumCommit<S>,
QuorumStateChangeListener,
ServiceLookup<HACommitGlue> {
    static final transient Logger log = Logger.getLogger(QuorumCommitImpl.class);
    private final QuorumMember<S> member;
    private final ExecutorService executorService;

    public QuorumCommitImpl(QuorumMember<S> member) {
        if (member == null) {
            throw new IllegalArgumentException();
        }
        this.member = member;
        this.executorService = member.getExecutor();
    }

    private Quorum<?, ?> getQuorum() {
        return this.member.getQuorum();
    }

    @Override
    public HACommitGlue getService(UUID serviceId) {
        return (HACommitGlue)this.member.getService(serviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrepareResponse prepare2Phase(PrepareRequest req) throws InterruptedException, IOException {
        long nanos;
        if (log.isInfoEnabled()) {
            log.info("req=" + req);
        }
        IRootBlockView rootBlock = req.getRootBlock();
        UUID[] joinedServiceIds = req.getPrepareAndNonJoinedServices().getJoinedServiceIds();
        long timeout = req.getTimeout();
        TimeUnit unit = req.getUnit();
        long token = rootBlock.getQuorumToken();
        long begin = System.nanoTime();
        long remaining = nanos = unit.toNanos(timeout);
        ArrayList<Future<Boolean>> localFutures = new ArrayList<Future<Boolean>>(joinedServiceIds.length);
        try {
            boolean willCommit;
            int i;
            int nfollowers = joinedServiceIds.length - 1;
            for (i = 0; i <= nfollowers; ++i) {
                localFutures.add(null);
            }
            this.member.assertLeader(token);
            for (i = 1; i < joinedServiceIds.length; ++i) {
                UUID serviceId = joinedServiceIds[i];
                boolean found = false;
                for (UUID x : req.getGatherJoinedAndNonJoinedServices().getJoinedServiceIds()) {
                    if (!serviceId.equals(x)) continue;
                    found = true;
                    break;
                }
                boolean isGatherService = found;
                HA2PhasePrepareMessage msgForJoinedService = new HA2PhasePrepareMessage(req.getConsensusReleaseTime(), isGatherService, true, rootBlock, timeout, unit);
                Future<Boolean> rf = this.executorService.submit(new PrepareMessageTask(this, serviceId, msgForJoinedService));
                localFutures.set(i, rf);
            }
            HACommitGlue leader = (HACommitGlue)this.member.getService();
            HA2PhasePrepareMessage msgForJoinedService = new HA2PhasePrepareMessage(req.getConsensusReleaseTime(), true, true, rootBlock, timeout, unit);
            Future<Boolean> f = leader.prepare2Phase(msgForJoinedService);
            localFutures.set(0, f);
            int nyes = 0;
            boolean[] votes = new boolean[1 + nfollowers];
            for (int i2 = 0; i2 <= nfollowers; ++i2) {
                Future ft = (Future)localFutures.get(i2);
                if (ft == null) {
                    throw new AssertionError((Object)("null @ index=" + i2));
                }
                try {
                    boolean vote;
                    remaining = nanos - (System.nanoTime() - begin);
                    votes[i2] = vote = ((Boolean)ft.get(remaining, TimeUnit.NANOSECONDS)).booleanValue();
                    nyes += vote ? 1 : 0;
                    continue;
                }
                catch (CancellationException ex) {
                    log.error(ex, ex);
                    continue;
                }
                catch (TimeoutException ex) {
                    log.error(ex, ex);
                    continue;
                }
                catch (ExecutionException ex) {
                    log.error(ex, ex);
                    continue;
                }
                catch (RuntimeException ex) {
                    log.error(ex, ex);
                    continue;
                }
                finally {
                    ft.cancel(true);
                }
            }
            int k = this.getQuorum().replicationFactor();
            boolean bl = willCommit = votes[0] && this.getQuorum().isQuorum(nyes);
            if (!willCommit) {
                log.error("prepare rejected: leader=" + votes[0] + ", nyes=" + nyes + " out of " + k);
            }
            PrepareResponse prepareResponse = new PrepareResponse(k, nyes, willCommit, votes);
            return prepareResponse;
        }
        finally {
            QuorumServiceBase.cancelFutures(localFutures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommitResponse commit2Phase(CommitRequest commitRequest) throws IOException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info("req=" + commitRequest);
        }
        PrepareRequest prepareRequest = commitRequest.getPrepareRequest();
        UUID[] joinedServiceIds = prepareRequest.getPrepareAndNonJoinedServices().getJoinedServiceIds();
        long token = prepareRequest.getRootBlock().getQuorumToken();
        long commitTime = prepareRequest.getRootBlock().getLastCommitTime();
        PrepareResponse prepareResponse = commitRequest.getPrepareResponse();
        boolean didAllServicesPrepare = prepareResponse.getYesCount() == prepareResponse.replicationFactor();
        ArrayList<Future<Void>> localFutures = new ArrayList<Future<Void>>(joinedServiceIds.length);
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        try {
            for (int i = 0; i < joinedServiceIds.length; ++i) {
                localFutures.add(null);
                causes.add(null);
            }
            this.member.assertLeader(token);
            HA2PhaseCommitMessage msgJoinedService = new HA2PhaseCommitMessage(true, commitTime, didAllServicesPrepare);
            for (int i = 1; i < joinedServiceIds.length; ++i) {
                if (!prepareResponse.getVote(i)) continue;
                UUID serviceId = joinedServiceIds[i];
                Future<Void> rf = this.executorService.submit(new CommitMessageTask(this, serviceId, msgJoinedService));
                localFutures.set(i, rf);
            }
            HACommitGlue leader = (HACommitGlue)this.member.getService();
            Future<Void> f = leader.commit2Phase(msgJoinedService);
            localFutures.set(0, f);
            for (int i = 0; i < joinedServiceIds.length; ++i) {
                Future ft = (Future)localFutures.get(i);
                if (ft == null) continue;
                try {
                    ft.get();
                    continue;
                }
                catch (CancellationException ex) {
                    log.error(ex, ex);
                    causes.set(i, ex);
                    continue;
                }
                catch (ExecutionException ex) {
                    log.error(ex, ex);
                    causes.set(i, ex);
                    continue;
                }
                catch (RuntimeException ex) {
                    log.error(ex, ex);
                    causes.set(i, ex);
                    continue;
                }
                finally {
                    ft.cancel(true);
                }
            }
            CommitResponse commitResponse = new CommitResponse(commitRequest, causes);
            return commitResponse;
        }
        finally {
            QuorumServiceBase.cancelFutures(localFutures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort2Phase(long token) throws IOException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info("token=" + token);
        }
        UUID[] joinedServiceIds = this.getQuorum().getJoined();
        this.member.assertLeader(token);
        HA2PhaseAbortMessage msg = new HA2PhaseAbortMessage(token);
        LinkedList<Future<Void>> localFutures = new LinkedList<Future<Void>>();
        try {
            for (int i = 1; i < joinedServiceIds.length; ++i) {
                UUID serviceId = joinedServiceIds[i];
                Future<Void> future = this.executorService.submit(new AbortMessageTask(this, serviceId, msg));
                localFutures.add(future);
            }
            this.member.assertLeader(token);
            HACommitGlue leader = (HACommitGlue)this.member.getService();
            Future<Void> f = leader.abort2Phase(msg);
            localFutures.add(f);
            LinkedList<Exception> causes = new LinkedList<Exception>();
            for (Future future : localFutures) {
                try {
                    future.get();
                }
                catch (InterruptedException ex) {
                    log.error(ex, ex);
                    causes.add(ex);
                }
                catch (ExecutionException ex) {
                    log.error(ex, ex);
                    causes.add(ex);
                }
                catch (RuntimeException ex) {
                    log.error(ex, ex);
                    causes.add(ex);
                }
                finally {
                    future.cancel(true);
                }
            }
            if (!causes.isEmpty()) {
                if (causes.size() == 1) {
                    throw new RuntimeException((Throwable)causes.get(0));
                }
                throw new RuntimeException("remote errors: nfailures=" + causes.size(), new ExecutionExceptions(causes));
            }
        }
        finally {
            QuorumServiceBase.cancelFutures(localFutures);
        }
    }

    private static class AbortMessageTask
    extends AbstractMessageTask<HACommitGlue, Void, IHA2PhaseAbortMessage> {
        public AbortMessageTask(ServiceLookup<HACommitGlue> serviceLookup, UUID serviceId, IHA2PhaseAbortMessage msg) {
            super(serviceLookup, serviceId, msg);
        }

        @Override
        protected Future<Void> doRMI(HACommitGlue service) throws IOException {
            return service.abort2Phase((IHA2PhaseAbortMessage)this.msg);
        }
    }

    private static class CommitMessageTask
    extends AbstractMessageTask<HACommitGlue, Void, IHA2PhaseCommitMessage> {
        public CommitMessageTask(ServiceLookup<HACommitGlue> serviceLookup, UUID serviceId, IHA2PhaseCommitMessage msg) {
            super(serviceLookup, serviceId, msg);
        }

        @Override
        protected Future<Void> doRMI(HACommitGlue service) throws IOException {
            return service.commit2Phase((IHA2PhaseCommitMessage)this.msg);
        }
    }

    private static class PrepareMessageTask
    extends AbstractMessageTask<HACommitGlue, Boolean, IHA2PhasePrepareMessage> {
        public PrepareMessageTask(ServiceLookup<HACommitGlue> serviceLookup, UUID serviceId, IHA2PhasePrepareMessage msg) {
            super(serviceLookup, serviceId, msg);
        }

        @Override
        protected Future<Boolean> doRMI(HACommitGlue service) throws IOException {
            return service.prepare2Phase((IHA2PhasePrepareMessage)this.msg);
        }
    }
}

