/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha;

import com.bigdata.ha.CommitRequest;
import com.bigdata.ha.CommitResponse;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.IHAPipelineResetRequest;
import com.bigdata.ha.IHAPipelineResetResponse;
import com.bigdata.ha.PrepareRequest;
import com.bigdata.ha.PrepareResponse;
import com.bigdata.ha.QuorumCommitImpl;
import com.bigdata.ha.QuorumPipelineImpl;
import com.bigdata.ha.QuorumReadImpl;
import com.bigdata.ha.QuorumService;
import com.bigdata.ha.msg.IHASendState;
import com.bigdata.ha.msg.IHASyncRequest;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.quorum.AbstractQuorumMember;
import com.bigdata.util.InnerCause;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public abstract class QuorumServiceBase<S extends HAGlue, L extends AbstractJournal>
extends AbstractQuorumMember<S>
implements QuorumService<S> {
    protected static final transient Logger log = Logger.getLogger(QuorumServiceBase.class);
    private final S service;
    private final L localService;
    private final QuorumPipelineImpl<S> pipelineImpl;
    private final QuorumCommitImpl<S> commitImpl;
    private final QuorumReadImpl<S> readImpl;

    protected QuorumServiceBase(String logicalServiceId, UUID serviceId, S service, L localService) {
        super(logicalServiceId, serviceId);
        if (localService == null) {
            throw new IllegalArgumentException();
        }
        this.service = service;
        this.localService = localService;
        this.pipelineImpl = new QuorumPipelineImpl<S>(this){

            @Override
            protected void handleReplicatedWrite(IHASyncRequest req, IHAWriteMessage msg, ByteBuffer data) throws Exception {
                QuorumServiceBase.this.handleReplicatedWrite(req, msg, data);
            }

            @Override
            protected void incReceive(IHASyncRequest req, IHAWriteMessage msg, int nreads, int rdlen, int rem) throws Exception {
                QuorumServiceBase.this.incReceive(req, msg, nreads, rdlen, rem);
            }

            @Override
            protected long getRetrySendTimeoutNanos() {
                return QuorumServiceBase.this.getRetrySendTimeoutNanos();
            }

            @Override
            public UUID getStoreUUID() {
                return QuorumServiceBase.this.getStoreUUID();
            }

            @Override
            public long getLastCommitTime() {
                return QuorumServiceBase.this.getLastCommitTime();
            }

            @Override
            public long getLastCommitCounter() {
                return QuorumServiceBase.this.getLastCommitCounter();
            }

            @Override
            public void logWriteCacheBlock(IHAWriteMessage msg, ByteBuffer data) throws IOException {
                QuorumServiceBase.this.logWriteCacheBlock(msg, data);
            }

            @Override
            public void logRootBlock(IRootBlockView rootBlock) throws IOException {
                QuorumServiceBase.this.logRootBlock(rootBlock);
            }

            @Override
            public void purgeHALogs(long token) {
                QuorumServiceBase.this.purgeHALogs(token);
            }
        };
        this.addListener(this.pipelineImpl);
        this.commitImpl = new QuorumCommitImpl(this);
        this.addListener(this.commitImpl);
        this.readImpl = new QuorumReadImpl(this);
        this.addListener(this.readImpl);
    }

    protected abstract long getRetrySendTimeoutNanos();

    @Override
    public S getService() {
        return this.service;
    }

    @Override
    public abstract S getService(UUID var1);

    protected L getLocalService() {
        return this.localService;
    }

    @Override
    public ExecutorService getExecutor() {
        return ((AbstractJournal)this.getLocalService()).getExecutorService();
    }

    @Override
    public Future<Void> receiveAndReplicate(IHASyncRequest req, IHASendState snd, IHAWriteMessage msg) throws IOException {
        return this.pipelineImpl.receiveAndReplicate(req, snd, msg);
    }

    @Override
    public Future<Void> replicate(IHASyncRequest req, IHAWriteMessage msg, ByteBuffer b) throws IOException {
        return this.pipelineImpl.replicate(req, msg, b);
    }

    @Override
    public Future<IHAPipelineResetResponse> resetPipeline(IHAPipelineResetRequest req) throws IOException {
        return this.pipelineImpl.resetPipeline(req);
    }

    protected abstract void handleReplicatedWrite(IHASyncRequest var1, IHAWriteMessage var2, ByteBuffer var3) throws Exception;

    protected abstract void incReceive(IHASyncRequest var1, IHAWriteMessage var2, int var3, int var4, int var5) throws Exception;

    @Override
    public void logWriteCacheBlock(IHAWriteMessage msg, ByteBuffer data) throws IOException {
    }

    @Override
    public void purgeHALogs(long token) {
    }

    @Override
    public void logRootBlock(IRootBlockView rootBlock) throws IOException {
    }

    @Override
    public void abort2Phase(long token) throws IOException, InterruptedException {
        this.commitImpl.abort2Phase(token);
    }

    @Override
    public CommitResponse commit2Phase(CommitRequest req) throws IOException, InterruptedException {
        return this.commitImpl.commit2Phase(req);
    }

    @Override
    public PrepareResponse prepare2Phase(PrepareRequest req) throws InterruptedException, TimeoutException, IOException {
        return this.commitImpl.prepare2Phase(req);
    }

    @Override
    public final UUID getStoreUUID() {
        L localService = this.getLocalService();
        return ((AbstractJournal)localService).getRootBlockView().getUUID();
    }

    @Override
    public final long getLastCommitTime() {
        L localService = this.getLocalService();
        return ((AbstractJournal)localService).getRootBlockView().getLastCommitTime();
    }

    @Override
    public final long getLastCommitCounter() {
        L localService = this.getLocalService();
        return ((AbstractJournal)localService).getRootBlockView().getCommitCounter();
    }

    @Override
    public long getPrepareTimeout() {
        return ((AbstractJournal)this.getLocalService()).getHAPrepareTimeout();
    }

    @Override
    public byte[] readFromQuorum(UUID storeId, long addr) throws InterruptedException, IOException {
        return this.readImpl.readFromQuorum(storeId, addr);
    }

    protected void processEvents() {
        this.pipelineImpl.processEvents();
    }

    public static <F extends Future<T>, T> void cancelFutures(List<F> futures) {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        for (Future f : futures) {
            if (f == null) continue;
            try {
                if (f.isDone()) continue;
                f.cancel(true);
            }
            catch (Throwable t) {
                if (!InnerCause.isInnerCause(t, InterruptedException.class)) continue;
                Thread.currentThread().interrupt();
            }
        }
    }
}

