/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha.althalog;

import com.bigdata.ha.althalog.HALogManager;
import com.bigdata.ha.althalog.IHALogReader;
import com.bigdata.ha.althalog.IHALogWriter;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.io.ChecksumUtility;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.IBufferAccess;
import com.bigdata.io.IReopenChannel;
import com.bigdata.io.SerializerUtil;
import com.bigdata.journal.CommitCounterUtility;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RootBlockUtility;
import com.bigdata.journal.StoreTypeEnum;
import com.bigdata.util.ChecksumError;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class HALogFile {
    private static final Logger log = Logger.getLogger("com.bigdata.haLog");
    static final int SIZE_MAGIC = 4;
    static final int SIZE_VERSION = 4;
    static final int SIZEOF_ROOT_BLOCK = 340;
    static final int OFFSET_ROOT_BLOCK0 = 8;
    static final int OFFSET_ROOT_BLOCK1 = 348;
    static final int headerSize0 = 688;
    public static final long START_DATA = 688L;
    static final int MAGIC = -2082883787;
    static final int VERSION1 = 1;
    private final int m_magic;
    private final int m_version;
    private final HALogManager.IHALogManagerCallback m_callback;
    private final IRootBlockView m_openRootBlock;
    private IRootBlockView m_closeRootBlock;
    private final StoreTypeEnum m_storeType;
    private final File m_haLogFile;
    private final FileChannel m_channel;
    private final RandomAccessFile m_raf;
    private volatile int m_accessors = 0;
    final IReopenChannel<FileChannel> m_reopener = new IReopenChannel<FileChannel>(){

        @Override
        public FileChannel reopenChannel() throws IOException {
            if (HALogFile.this.m_channel == null) {
                throw new IOException("Closed");
            }
            return HALogFile.this.m_channel;
        }
    };
    private final HALogWriter m_writer;
    private final ReadWriteLock m_lock = new ReentrantReadWriteLock();
    private final Lock m_writeLock = this.m_lock.writeLock();
    private final Lock m_readLock = this.m_lock.readLock();
    private final Condition m_fileChange = this.m_writeLock.newCondition();
    private long m_writePosition = -1L;
    private long m_sequence = 0L;

    public HALogFile(IRootBlockView rbv, HALogManager.IHALogManagerCallback callback) throws IOException {
        this.m_callback = callback;
        this.m_haLogFile = HALogFile.getHALogFileName(this.m_callback.getHALogDir(), rbv.getCommitCounter());
        if (this.m_haLogFile.exists()) {
            throw new IllegalStateException("File already exists: " + this.m_haLogFile.getAbsolutePath());
        }
        File parentDir = this.m_haLogFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Could not create directory: " + parentDir);
        }
        this.m_raf = new RandomAccessFile(this.m_haLogFile, "rw");
        this.m_channel = this.m_raf.getChannel();
        this.m_storeType = rbv.getStoreType();
        this.m_openRootBlock = rbv;
        this.m_closeRootBlock = null;
        this.m_magic = -2082883787;
        this.m_version = 1;
        this.m_raf.seek(0L);
        this.m_raf.writeInt(this.m_magic);
        this.m_raf.writeInt(this.m_version);
        this.writeRootBlock(true, rbv);
        this.writeRootBlock(false, rbv);
        this.m_writePosition = 688L;
        this.m_writer = new HALogWriter();
        if (log.isInfoEnabled()) {
            log.info("Opening HALogFile: " + this.m_haLogFile.getAbsolutePath());
        }
    }

    public HALogFile(File file) {
        if (file == null || !file.exists()) {
            throw new IllegalStateException();
        }
        this.m_callback = null;
        this.m_writer = null;
        this.m_haLogFile = file;
        try {
            this.m_raf = new RandomAccessFile(this.m_haLogFile, "r");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.m_channel = this.m_raf.getChannel();
        try {
            long cc1;
            this.m_raf.seek(0L);
            try {
                this.m_magic = this.m_raf.readInt();
            }
            catch (IOException ex) {
                throw new RuntimeException("Can not read magic. Is file locked by another process?", ex);
            }
            if (this.m_magic != -2082883787) {
                throw new RuntimeException("Bad journal magic: expected=-2082883787, actual=" + this.m_magic);
            }
            this.m_version = this.m_raf.readInt();
            if (this.m_version != 1) {
                throw new RuntimeException("Bad journal version: expected=1, actual=" + this.m_version);
            }
            RootBlockUtility tmp = new RootBlockUtility(this.m_reopener, file, true, false, false);
            this.m_closeRootBlock = tmp.chooseRootBlock();
            this.m_openRootBlock = tmp.rootBlock0 == this.m_closeRootBlock ? tmp.rootBlock1 : tmp.rootBlock0;
            long cc0 = this.m_openRootBlock.getCommitCounter();
            if (cc0 + 1L != (cc1 = this.m_closeRootBlock.getCommitCounter()) && cc0 != cc1) {
                throw new IllegalStateException("Incompatible rootblocks: cc0=" + cc0 + ", cc1=" + cc1);
            }
            this.m_channel.position(688L);
            this.m_storeType = this.m_openRootBlock.getStoreType();
        }
        catch (Throwable t) {
            try {
                this.close();
            }
            catch (IOException e) {
                log.warn(e);
            }
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(IHAWriteMessage msg, ByteBuffer data) throws IOException {
        this.m_writeLock.lock();
        try {
            if (this.m_openRootBlock.getCommitCounter() != msg.getCommitCounter()) {
                throw new IllegalStateException("commitCounter=" + this.m_openRootBlock.getCommitCounter() + ", but msg=" + msg);
            }
            if (this.m_openRootBlock.getLastCommitTime() != msg.getLastCommitTime()) {
                throw new IllegalStateException("lastCommitTime=" + this.m_openRootBlock.getLastCommitTime() + ", but msg=" + msg);
            }
            if (this.m_sequence != msg.getSequence()) {
                throw new IllegalStateException("nextSequence=" + this.m_sequence + ", but msg=" + msg);
            }
            if (log.isInfoEnabled()) {
                log.info("msg=" + msg + ", position=" + this.m_writePosition);
            }
            if (this.m_writePosition < 688L) {
                throw new AssertionError((Object)("position=" + this.m_writePosition + ", but headerSize=" + 688));
            }
            ByteBuffer tmp = this.bufferObject(msg);
            int nbytes = tmp.limit();
            FileChannelUtility.writeAll(this.m_reopener, tmp, this.m_writePosition);
            this.m_writePosition += (long)nbytes;
            switch (this.m_openRootBlock.getStoreType()) {
                case RW: {
                    int nbytes2 = msg.getSize();
                    assert (data.position() == 0);
                    assert (data.limit() == nbytes2);
                    FileChannelUtility.writeAll(this.m_reopener, data.duplicate(), this.m_writePosition);
                    this.m_writePosition += (long)nbytes2;
                    break;
                }
                case WORM: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++this.m_sequence;
            this.m_fileChange.signalAll();
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    private ByteBuffer bufferObject(Object obj) throws IOException {
        return ByteBuffer.wrap(SerializerUtil.serialize(obj));
    }

    public void close() throws IOException {
        if (this.m_accessors == 0 && this.m_channel.isOpen()) {
            this.m_raf.close();
        }
    }

    public void delete() throws IOException {
        this.close();
        if (this.m_channel.isOpen()) {
            throw new IllegalStateException("Request to delete file with open readers and writers");
        }
        if (this.m_haLogFile.exists()) {
            try {
                this.m_haLogFile.delete();
            }
            catch (SecurityException se) {
                log.warn("unable to delete file", se);
            }
        }
    }

    public boolean isEmpty() {
        return this.m_closeRootBlock != null && this.m_openRootBlock.getCommitCounter() == this.m_closeRootBlock.getCommitCounter();
    }

    public long getCommitCounter() {
        return this.m_openRootBlock.getCommitCounter();
    }

    public HALogWriter getWriter() {
        return this.m_writer != null && this.m_writer.isOpen() ? this.m_writer : null;
    }

    public IHALogReader getReader() throws IOException {
        return new HALogReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(IRootBlockView rbv) throws IOException {
        this.m_writeLock.lock();
        try {
            if (this.m_closeRootBlock != null) {
                throw new IllegalStateException("LogFile is already closed");
            }
            this.writeRootBlock(rbv.isRootBlock0(), rbv);
            this.m_closeRootBlock = rbv;
            this.m_callback.release(this);
            this.m_fileChange.signalAll();
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    private void writeRootBlock(boolean isRootBlock0, IRootBlockView rootBlock) throws IOException {
        if (rootBlock == null) {
            throw new IllegalArgumentException();
        }
        long position = isRootBlock0 ? 8L : 348L;
        FileChannelUtility.writeAll(this.m_reopener, rootBlock.asReadOnlyBuffer(), position);
        if (log.isDebugEnabled()) {
            log.debug("wrote root block: " + rootBlock);
        }
    }

    private IRootBlockView getOpeningRootBlock() {
        return this.m_openRootBlock;
    }

    private IRootBlockView getClosingRootBlock() {
        return this.m_closeRootBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHAWriteMessage processNextBuffer(IReadPosition position, ByteBuffer clientBuffer) throws IOException {
        this.m_readLock.lock();
        try {
            IHAWriteMessage msg;
            long startPosition = position.getPosition();
            FileChannelInputStream chinstr = new FileChannelInputStream(startPosition);
            ObjectInputStream objinstr = new ObjectInputStream(chinstr);
            try {
                msg = (IHAWriteMessage)objinstr.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            long currentPosition = chinstr.getPosition();
            switch (this.m_storeType) {
                case RW: {
                    if (clientBuffer != null && msg.getSize() > clientBuffer.capacity()) {
                        throw new IllegalStateException("Client buffer is not large enough for logged buffer");
                    }
                    int nbytes = msg.getSize();
                    if (clientBuffer != null) {
                        clientBuffer.position(0);
                        clientBuffer.limit(nbytes);
                        FileChannelUtility.readAll(this.m_reopener, clientBuffer, currentPosition);
                        clientBuffer.flip();
                        int chksum = new ChecksumUtility().checksum(clientBuffer.duplicate());
                        if (chksum != msg.getChk()) {
                            throw new ChecksumError("Expected=" + msg.getChk() + ", actual=" + chksum);
                        }
                        if (clientBuffer.remaining() != nbytes) {
                            throw new AssertionError();
                        }
                    }
                    currentPosition += (long)msg.getSize();
                    break;
                }
                case WORM: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            position.setPosition(currentPosition);
            IHAWriteMessage iHAWriteMessage = msg;
            return iHAWriteMessage;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public void disable() throws IOException {
        assert (this.m_writer != null);
        this.m_writer.close();
    }

    public static File getHALogFileName(File dir, long commitCounter) {
        return CommitCounterUtility.getCommitCounterFile(dir, commitCounter, ".ha-log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void computeDigest(IReopenChannel<FileChannel> reopener, MessageDigest digest) throws DigestException, IOException {
        IBufferAccess buf = null;
        try {
            long fileExtent;
            long totalBytes;
            try {
                buf = DirectBufferPool.INSTANCE.acquire();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            ByteBuffer b = buf.buffer();
            int bufferCapacity = b.capacity();
            long remaining = totalBytes = (fileExtent = reopener.reopenChannel().size());
            long offset = 0L;
            long sequence = 0L;
            if (log.isInfoEnabled()) {
                log.info("Computing digest: nbytes=" + totalBytes);
            }
            while (remaining > 0L) {
                int nbytes = (int)Math.min((long)bufferCapacity, remaining);
                if (log.isDebugEnabled()) {
                    log.debug("Computing digest: sequence=" + sequence + ", offset=" + offset + ", nbytes=" + nbytes);
                }
                b.position(0);
                b.limit(nbytes);
                FileChannelUtility.readAll(reopener, b, offset);
                digest.update(b);
                offset += (long)nbytes;
                remaining -= (long)nbytes;
                ++sequence;
            }
            if (log.isInfoEnabled()) {
                log.info("Computed digest: #blocks=" + sequence + ", #bytes=" + totalBytes);
            }
            return;
        }
        finally {
            if (buf != null) {
                try {
                    buf.release();
                }
                catch (InterruptedException e) {
                    log.warn(e);
                }
            }
        }
    }

    public boolean isOpen() {
        return this.m_channel != null && this.m_channel.isOpen();
    }

    public File getFile() {
        return this.m_haLogFile;
    }

    private class FileChannelInputStream
    extends InputStream {
        final ByteBuffer m_char = ByteBuffer.allocate(1);
        private long m_position;
        final Thread m_startThread = Thread.currentThread();

        FileChannelInputStream(long position) {
            this.m_position = position;
        }

        @Override
        public int read() throws IOException {
            assert (this.m_startThread == Thread.currentThread());
            this.m_char.position(0);
            int status = this.readLocal(this.m_char, this.m_position++);
            this.m_char.position(0);
            return status == -1 ? -1 : (int)this.m_char.get();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            assert (this.m_startThread == Thread.currentThread());
            ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
            int ret = this.readLocal(buffer, this.m_position);
            this.m_position += (long)ret;
            return ret;
        }

        private long getPosition() {
            return this.m_position;
        }

        private int readLocal(ByteBuffer buffer, long position) throws IOException {
            int requestLen = buffer.remaining();
            long eof = HALogFile.this.m_channel.size();
            if (eof < position + (long)requestLen) {
                if (position == eof) {
                    return -1;
                }
                int len = (int)(eof - position);
                buffer.limit(len);
                FileChannelUtility.readAll(HALogFile.this.m_reopener, buffer, position);
                buffer.limit(requestLen);
            } else {
                FileChannelUtility.readAll(HALogFile.this.m_reopener, buffer, position);
            }
            return requestLen - buffer.remaining();
        }
    }

    public class HALogWriter
    extends HALogAccess
    implements IHALogWriter {
        private long m_nextSequence;

        public HALogWriter() {
            this.m_nextSequence = 0L;
        }

        private void assertOpen() {
            if (!this.isOpen()) {
                throw new IllegalStateException();
            }
        }

        @Override
        public long getSequence() {
            this.assertOpen();
            return this.m_nextSequence;
        }

        @Override
        public String toString() {
            IRootBlockView tmp = HALogFile.this.getOpeningRootBlock();
            long seq = this.m_nextSequence;
            return this.getClass().getName() + "{" + (!this.isOpen() ? "closed" : "commitCounter=" + tmp.getCommitCounter() + ",nextSequence=" + seq) + "}";
        }

        @Override
        public void write(IHAWriteMessage msg, ByteBuffer data) throws IOException {
            this.assertOpen();
            HALogFile.this.write(msg, data);
        }

        @Override
        public void close(IRootBlockView rbv) throws IOException {
            this.assertOpen();
            HALogFile.this.close(rbv);
            this.close();
        }

        @Override
        public long getCommitCounter() {
            return HALogFile.this.getCommitCounter();
        }
    }

    private class HALogReader
    extends HALogAccess
    implements IHALogReader {
        private IReadPosition m_readPosition;

        private HALogReader() {
            this.m_readPosition = new IReadPosition(){
                long m_position = 688L;

                @Override
                public long getPosition() {
                    return this.m_position;
                }

                @Override
                public void setPosition(long position) {
                    this.m_position = position;
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return HALogFile.this.isEmpty();
        }

        private void assertOpen() throws IOException {
            if (!this.isOpen()) {
                throw new IOException("Closed: " + HALogFile.this);
            }
        }

        @Override
        public boolean hasMoreBuffers() throws IOException {
            this.assertOpen();
            return this.waitOnData(this.m_readPosition.getPosition());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitOnData(long position) throws IOException {
            HALogFile.this.m_readLock.lock();
            try {
                long cursize = HALogFile.this.m_channel.size();
                if (position > cursize) {
                    throw new IllegalArgumentException();
                }
                if (position < cursize) {
                    boolean bl = true;
                    return bl;
                }
                if (HALogFile.this.m_closeRootBlock != null) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                HALogFile.this.m_readLock.unlock();
            }
            HALogFile.this.m_writeLock.lock();
            try {
                while (HALogFile.this.m_closeRootBlock == null && position == HALogFile.this.m_channel.size() && HALogFile.this.m_writer.isOpen()) {
                    try {
                        HALogFile.this.m_fileChange.await();
                    }
                    catch (InterruptedException e) {}
                }
                long cursize = HALogFile.this.m_channel.size();
                boolean bl = position < cursize;
                return bl;
            }
            finally {
                HALogFile.this.m_writeLock.unlock();
            }
        }

        @Override
        public IHAWriteMessage processNextBuffer(ByteBuffer clientBuffer) throws IOException {
            return HALogFile.this.processNextBuffer(this.m_readPosition, clientBuffer);
        }

        @Override
        public IRootBlockView getClosingRootBlock() throws IOException {
            return HALogFile.this.getClosingRootBlock();
        }

        @Override
        public IRootBlockView getOpeningRootBlock() {
            return HALogFile.this.getOpeningRootBlock();
        }

        @Override
        public void computeDigest(MessageDigest digest) throws DigestException, IOException {
            HALogFile.computeDigest(HALogFile.this.m_reopener, digest);
        }
    }

    static interface IReadPosition {
        public long getPosition();

        public void setPosition(long var1);
    }

    private class HALogAccess {
        private volatile boolean m_open = true;

        HALogAccess() {
            HALogFile.this.m_accessors++;
        }

        public void close() throws IOException {
            if (!this.m_open) {
                throw new IllegalStateException();
            }
            this.m_open = false;
            HALogFile.this.m_accessors--;
            HALogFile.this.close();
        }

        public boolean isOpen() {
            return this.m_open;
        }
    }
}

