/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha.halog;

import com.bigdata.ha.halog.IHALogReader;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.io.ChecksumUtility;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.IBufferAccess;
import com.bigdata.io.IReopenChannel;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RootBlockUtility;
import com.bigdata.journal.StoreTypeEnum;
import com.bigdata.util.ChecksumError;
import com.bigdata.util.InnerCause;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class HALogReader
implements IHALogReader {
    private static final Logger log = Logger.getLogger(HALogReader.class);
    private final File m_file;
    private final RandomAccessFile m_raf;
    private final FileChannel m_channel;
    private final IRootBlockView m_openRootBlock;
    private final IRootBlockView m_closeRootBlock;
    private final StoreTypeEnum m_storeType;
    private final int magic;
    private final int version;
    private final IReopenChannel<FileChannel> reopener = new IReopenChannel<FileChannel>(){

        @Override
        public FileChannel reopenChannel() throws IOException {
            if (HALogReader.this.m_channel == null) {
                throw new IOException("Closed");
            }
            return HALogReader.this.m_channel;
        }
    };

    public HALogReader(File file) throws IOException {
        this.m_file = file;
        this.m_raf = new RandomAccessFile(file, "r");
        this.m_channel = this.m_raf.getChannel();
        try {
            long cc1;
            this.m_raf.seek(0L);
            try {
                this.magic = this.m_raf.readInt();
            }
            catch (IOException ex) {
                throw new RuntimeException("Can not read magic. Is file locked by another process? file=" + file, ex);
            }
            if (this.magic != -2082883787) {
                throw new RuntimeException("Bad HALog magic: file=" + file + ", expected=" + -2082883787 + ", actual=" + this.magic);
            }
            this.version = this.m_raf.readInt();
            if (this.version != 1) {
                throw new RuntimeException("Bad HALog version: file=" + file + ", expected=" + 1 + ", actual=" + this.version);
            }
            RootBlockUtility tmp = new RootBlockUtility(this.reopener, file, true, false, false);
            this.m_closeRootBlock = tmp.chooseRootBlock();
            this.m_openRootBlock = tmp.rootBlock0 == this.m_closeRootBlock ? tmp.rootBlock1 : tmp.rootBlock0;
            long cc0 = this.m_openRootBlock.getCommitCounter();
            if (cc0 + 1L != (cc1 = this.m_closeRootBlock.getCommitCounter()) && cc0 != cc1) {
                throw new IllegalStateException("Incompatible rootblocks: file=" + file + ", cc0=" + cc0 + ", cc1=" + cc1);
            }
            this.m_channel.position(688L);
            this.m_storeType = this.m_openRootBlock.getStoreType();
        }
        catch (Throwable t) {
            this.close();
            throw new RuntimeException(t);
        }
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            try {
                this.m_raf.close();
            }
            catch (IOException e) {
                log.error("Problem closing file: file=" + this.m_file + " : " + e, e);
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.m_channel.isOpen();
    }

    @Override
    public boolean isLive() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.m_openRootBlock.getCommitCounter() == this.m_closeRootBlock.getCommitCounter();
    }

    private void assertOpen() throws IOException {
        if (!this.m_channel.isOpen()) {
            throw new IOException("Closed: " + this.m_file);
        }
    }

    @Override
    public IRootBlockView getOpeningRootBlock() {
        return this.m_openRootBlock;
    }

    @Override
    public IRootBlockView getClosingRootBlock() {
        return this.m_closeRootBlock;
    }

    @Override
    public boolean hasMoreBuffers() throws IOException {
        if (!this.isOpen()) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        return this.m_channel.position() < this.m_channel.size();
    }

    @Override
    public IHAWriteMessage processNextBuffer(ByteBuffer clientBuffer) throws IOException {
        return HALogReader.processNextBuffer(this.m_raf, this.reopener, this.m_storeType, clientBuffer);
    }

    public static IHAWriteMessage processNextBuffer(RandomAccessFile raf, IReopenChannel<FileChannel> reopener, StoreTypeEnum storeType, ByteBuffer clientBuffer) throws IOException {
        IHAWriteMessage msg;
        FileChannel channel = raf.getChannel();
        ObjectInputStream objinstr = new ObjectInputStream(new RAFInputStream(raf));
        try {
            msg = (IHAWriteMessage)objinstr.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        switch (storeType) {
            case WORM: 
            case RW: {
                if (msg.getSize() > clientBuffer.capacity()) {
                    throw new IllegalStateException("Client buffer is not large enough for logged buffer");
                }
                int nbytes = msg.getSize();
                clientBuffer.position(0);
                clientBuffer.limit(nbytes);
                long pos = channel.position();
                if (clientBuffer != null) {
                    FileChannelUtility.readAll(reopener, clientBuffer, pos);
                    clientBuffer.flip();
                    int chksum = new ChecksumUtility().checksum(clientBuffer.duplicate());
                    if (chksum != msg.getChk()) {
                        throw new ChecksumError("Expected=" + msg.getChk() + ", actual=" + chksum);
                    }
                    if (clientBuffer.remaining() != nbytes) {
                        throw new AssertionError();
                    }
                }
                channel.position(pos + (long)msg.getSize());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        Arrays.sort(args);
        IBufferAccess buf = DirectBufferPool.INSTANCE.acquire();
        try {
            for (String arg : args) {
                File file = new File(arg);
                if (!file.exists()) {
                    System.err.println("No such file: " + file);
                    continue;
                }
                if (file.isDirectory()) {
                    HALogReader.doDirectory(file, buf);
                    continue;
                }
                HALogReader.doFile(file, buf);
            }
        }
        finally {
            buf.release();
        }
    }

    private static void doDirectory(File dir, IBufferAccess buf) {
        Object[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (new File(dir, name).isDirectory()) {
                    return true;
                }
                return name.endsWith(".ha-log");
            }
        });
        Arrays.sort(files);
        for (Object file : files) {
            if (((File)file).isDirectory()) {
                HALogReader.doDirectory((File)file, buf);
                continue;
            }
            HALogReader.doFile((File)file, buf);
        }
    }

    private static void doFile(File file, IBufferAccess buf) {
        try {
            HALogReader.doFile2(file, buf);
        }
        catch (Throwable e) {
            if (InnerCause.isInnerCause(e, InterruptedException.class)) {
                Thread.currentThread().interrupt();
            }
            String msg = "ERROR: Could not read file: file=" + file + ", cause=" + e;
            System.err.println(msg);
            log.error(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doFile2(File file, IBufferAccess buf) throws IOException {
        try (HALogReader r = new HALogReader(file);){
            IRootBlockView openingRootBlock = r.getOpeningRootBlock();
            IRootBlockView closingRootBlock = r.getClosingRootBlock();
            boolean isWORM = openingRootBlock.getStoreType() == StoreTypeEnum.WORM;
            System.out.println("----------begin----------");
            System.out.println("file=" + file);
            System.out.println("openingRootBlock=" + openingRootBlock);
            System.out.println("closingRootBlock=" + closingRootBlock);
            if (openingRootBlock.getCommitCounter() == closingRootBlock.getCommitCounter()) {
                System.err.println("WARN : LOGICALLY EMPTY LOG (closing root block == opening root block): file=" + file);
            }
            while (r.hasMoreBuffers()) {
                IHAWriteMessage msg = r.processNextBuffer(isWORM ? null : buf.buffer());
                System.out.println(msg.toString());
            }
            System.out.println("-----------end-----------");
        }
    }

    @Override
    public void computeDigest(MessageDigest digest) throws DigestException, IOException {
        HALogReader.computeDigest(this.reopener, digest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void computeDigest(IReopenChannel<FileChannel> reopener, MessageDigest digest) throws DigestException, IOException {
        IBufferAccess buf = null;
        try {
            long fileExtent;
            long totalBytes;
            try {
                buf = DirectBufferPool.INSTANCE.acquire();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            ByteBuffer b = buf.buffer();
            int bufferCapacity = b.capacity();
            long remaining = totalBytes = (fileExtent = reopener.reopenChannel().size());
            long offset = 0L;
            long sequence = 0L;
            if (log.isInfoEnabled()) {
                log.info("Computing digest: nbytes=" + totalBytes);
            }
            while (remaining > 0L) {
                int nbytes = (int)Math.min((long)bufferCapacity, remaining);
                if (log.isDebugEnabled()) {
                    log.debug("Computing digest: sequence=" + sequence + ", offset=" + offset + ", nbytes=" + nbytes);
                }
                b.position(0);
                b.limit(nbytes);
                FileChannelUtility.readAll(reopener, b, offset);
                b.flip();
                digest.update(b);
                offset += (long)nbytes;
                remaining -= (long)nbytes;
                ++sequence;
            }
            if (log.isInfoEnabled()) {
                log.info("Computed digest: #blocks=" + sequence + ", #bytes=" + totalBytes);
            }
            return;
        }
        finally {
            if (buf != null) {
                try {
                    buf.release();
                }
                catch (InterruptedException e) {
                    log.warn(e);
                }
            }
        }
    }

    private static class RAFInputStream
    extends InputStream {
        final RandomAccessFile m_raf;

        RAFInputStream(RandomAccessFile raf) {
            this.m_raf = raf;
        }

        @Override
        public int read() throws IOException {
            return this.m_raf.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.m_raf.read(b, off, len);
        }
    }
}

