/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha.msg;

import com.bigdata.ha.msg.IHA2PhasePrepareMessage;
import com.bigdata.ha.msg.IHANotifyReleaseTimeResponse;
import com.bigdata.io.ChecksumUtility;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.RootBlockView;
import com.bigdata.util.BytesUtil;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public class HA2PhasePrepareMessage
implements IHA2PhasePrepareMessage,
Serializable {
    private static final long serialVersionUID = 2L;
    private final IHANotifyReleaseTimeResponse consensusReleaseTime;
    private final boolean isGatherService;
    private final boolean isJoinedService;
    private final boolean isRootBlock0;
    private final byte[] rootBlock;
    private final long timeout;
    private final TimeUnit unit;

    public HA2PhasePrepareMessage(IHANotifyReleaseTimeResponse consensusReleaseTime, boolean isGatherService, boolean isJoinedService, IRootBlockView rootBlock, long timeout, TimeUnit unit) {
        if (consensusReleaseTime == null) {
            throw new IllegalArgumentException();
        }
        if (rootBlock == null) {
            throw new IllegalArgumentException();
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        this.consensusReleaseTime = consensusReleaseTime;
        this.isGatherService = isGatherService;
        this.isJoinedService = isJoinedService;
        this.isRootBlock0 = rootBlock.isRootBlock0();
        this.rootBlock = BytesUtil.getBytes(rootBlock.asReadOnlyBuffer());
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public IHANotifyReleaseTimeResponse getConsensusReleaseTime() {
        return this.consensusReleaseTime;
    }

    @Override
    public boolean isGatherService() {
        return this.isGatherService;
    }

    @Override
    public boolean isJoinedService() {
        return this.isJoinedService;
    }

    @Override
    public boolean isRootBlock0() {
        return this.isRootBlock0;
    }

    @Override
    public IRootBlockView getRootBlock() {
        return new RootBlockView(this.isRootBlock0, ByteBuffer.wrap(this.rootBlock), new ChecksumUtility());
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public TimeUnit getUnit() {
        return this.unit;
    }

    @Override
    public boolean voteNo() {
        return false;
    }

    public String toString() {
        return super.toString() + "{" + "consensusReleaseTime=" + this.getConsensusReleaseTime() + ",isGatherService=" + this.isGatherService() + ",isPrepareService=" + this.isJoinedService() + ",isRootBlock0=" + this.isRootBlock0() + ",rootBlock()=" + this.getRootBlock() + ",timeout=" + this.getTimeout() + ",unit=" + (Object)((Object)this.getUnit()) + "}";
    }
}

