/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.Banner;
import com.bigdata.BigdataStatics;
import com.bigdata.btree.BTreeCounters;
import com.bigdata.btree.EntryScanIterator;
import com.bigdata.btree.HTreeIndexMetadata;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.IReadWriteLockManager;
import com.bigdata.btree.ISimpleTreeIndexAccess;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexInconsistentError;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.PO;
import com.bigdata.btree.ReadWriteLockManager;
import com.bigdata.btree.data.IAbstractNodeData;
import com.bigdata.cache.HardReferenceQueue;
import com.bigdata.cache.HardReferenceQueueWithBatchingUpdates;
import com.bigdata.cache.IHardReferenceQueue;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.htree.AbstractPage;
import com.bigdata.htree.BucketPage;
import com.bigdata.htree.BucketPageTupleIterator;
import com.bigdata.htree.DefaultEvictionListener;
import com.bigdata.htree.DirectoryPage;
import com.bigdata.htree.HTree;
import com.bigdata.htree.INodeFactory;
import com.bigdata.htree.NodeSerializer;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.compression.IRecordCompressorFactory;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.util.concurrent.Computable;
import com.bigdata.util.concurrent.Memoizer;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractHTree
implements ICounterSetAccess,
ICheckpointProtocol,
ISimpleTreeIndexAccess {
    protected static final String ERROR_CLOSED = "Closed";
    protected static final String ERROR_LESS_THAN_ZERO = "Less than zero";
    protected static final String ERROR_TOO_SMALL = "Too small: ";
    protected static final String ERROR_TOO_LARGE = "Too large: ";
    protected static final String ERROR_READ_ONLY = "Read-only";
    protected static final String ERROR_TRANSIENT = "Transient";
    protected static final String ERROR_ERROR_STATE = "Index is in error state";
    public final int MIN_ADDRESS_BITS = 1;
    public final int MAX_ADDRESS_BITS = 16;
    protected static final transient Logger log = Logger.getLogger(AbstractHTree.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    public static final Logger dumpLog = Logger.getLogger(AbstractHTree.class.getName() + "#dump");
    private volatile BTreeCounters btreeCounters = new BTreeCounters();
    protected final IRawStore store;
    protected final boolean readOnly;
    protected final int addressBits;
    protected final int bucketSlots;
    private final IReadWriteLockManager lockManager;
    private static final Computable<LoadChildRequest, AbstractPage> loadChild = new Computable<LoadChildRequest, AbstractPage>(){

        @Override
        public AbstractPage compute(LoadChildRequest req) throws InterruptedException {
            return req.parent._getChild(req.index, req);
        }
    };
    final ChildMemoizer memo;
    protected volatile DirectoryPage root;
    protected volatile Throwable error;
    protected final IHardReferenceQueue<PO> writeRetentionQueue;
    protected int ndistinctOnWriteRetentionQueue;
    private final int maxParallelEvictThreads;
    private final int minDirtyListSizeForParallelEvict;
    private volatile HTreeIndexMetadata metadata2;
    protected HTreeIndexMetadata metadata;
    protected final NodeSerializer nodeSer;

    public final BTreeCounters getBtreeCounters() {
        return this.btreeCounters;
    }

    public final void setBTreeCounters(BTreeCounters btreeCounters) {
        if (btreeCounters == null) {
            throw new IllegalArgumentException();
        }
        this.btreeCounters = btreeCounters;
    }

    @Override
    public CounterSet getCounters() {
        CounterSet counterSet = new CounterSet();
        counterSet.addCounter("index UUID", new OneShotInstrument<String>(this.getIndexMetadata().getIndexUUID().toString()));
        counterSet.addCounter("class", new OneShotInstrument<String>(this.getClass().getName()));
        CounterSet tmp = counterSet.makePath("WriteRetentionQueue");
        tmp.addCounter("Capacity", new OneShotInstrument<Integer>(this.writeRetentionQueue.capacity()));
        tmp.addCounter("Size", new OneShotInstrument<Integer>(this.writeRetentionQueue.size()));
        tmp.addCounter("Distinct", new OneShotInstrument<Integer>(this.ndistinctOnWriteRetentionQueue));
        tmp = counterSet.makePath("Statistics");
        tmp.addCounter("addressBits", new OneShotInstrument<Integer>(this.addressBits));
        tmp.addCounter("nodeCount", new OneShotInstrument<Long>(this.getNodeCount()));
        tmp.addCounter("leafCount", new OneShotInstrument<Long>(this.getLeafCount()));
        tmp.addCounter("tupleCount", new OneShotInstrument<Long>(this.getEntryCount()));
        long entryCount = this.getEntryCount();
        long bytes = this.btreeCounters.bytesOnStore_nodesAndLeaves.get() + this.btreeCounters.bytesOnStore_rawRecords.get();
        long bytesPerTuple = (long)(entryCount == 0L ? 0.0 : (double)(bytes / entryCount));
        tmp.addCounter("bytesPerTuple", new OneShotInstrument<Long>(bytesPerTuple));
        counterSet.attach(this.btreeCounters.getCounters());
        return counterSet;
    }

    AbstractPage loadChild(DirectoryPage parent, int index) {
        try {
            return (AbstractPage)this.memo.compute(new LoadChildRequest(parent, index));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTreeIndexMetadata getIndexMetadata() {
        if (this.isReadOnly()) {
            if (this.metadata2 == null) {
                AbstractHTree abstractHTree = this;
                synchronized (abstractHTree) {
                    if (this.metadata2 == null) {
                        this.metadata2 = this.metadata.clone();
                    }
                }
            }
            return this.metadata2;
        }
        return this.metadata;
    }

    @Override
    public synchronized void close() {
        if (this.root == null) {
            throw new IllegalStateException(ERROR_CLOSED);
        }
        if (INFO || BigdataStatics.debug) {
            String msg = "HTree close: name=" + this.metadata.getName() + ", dirty=" + this.root.isDirty() + ", nnodes=" + this.getNodeCount() + ", nleaves=" + this.getLeafCount() + ", nentries=" + this.getEntryCount() + ", impl=" + (this instanceof HTree ? ((HTree)this).getCheckpoint().toString() : this.getClass().getSimpleName());
            if (INFO) {
                log.info(msg);
            }
        }
        if (this.nodeSer != null) {
            this.nodeSer.close();
        }
        this.writeRetentionQueue.clear(true);
        this.ndistinctOnWriteRetentionQueue = 0;
        this.root = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reopen() {
        if (this.root == null) {
            AbstractHTree abstractHTree = this;
            synchronized (abstractHTree) {
                if (this.root == null) {
                    this._reopen();
                }
            }
        }
    }

    protected abstract void _reopen();

    @Override
    public final boolean isOpen() {
        return this.root != null;
    }

    public final boolean isTransient() {
        return this.store == null;
    }

    protected final void assertNotTransient() {
        if (this.isTransient()) {
            throw new UnsupportedOperationException(ERROR_TRANSIENT);
        }
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    protected final void assertNotReadOnly() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException(ERROR_READ_ONLY);
        }
        if (this.error != null) {
            throw new IndexInconsistentError(ERROR_ERROR_STATE, this.error);
        }
    }

    @Override
    public abstract long getLastCommitTime();

    @Override
    public IRawStore getStore() {
        return this.store;
    }

    public final int getAddressBits() {
        return this.addressBits;
    }

    @Override
    public abstract long getNodeCount();

    @Override
    public abstract long getLeafCount();

    @Override
    public abstract long getEntryCount();

    @Override
    public final boolean isBalanced() {
        return false;
    }

    @Override
    public int getHeight() {
        throw new UnsupportedOperationException();
    }

    public final NodeSerializer getNodeSerializer() {
        return this.nodeSer;
    }

    protected final DirectoryPage getRoot() {
        if (this.root == null) {
            this.reopen();
        }
        this.touch(this.root);
        return this.root;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{ ");
        if (this.metadata.getName() != null) {
            sb.append("name=" + this.metadata.getName());
        } else {
            sb.append("uuid=" + this.metadata.getIndexUUID());
        }
        sb.append(", addressBits=" + this.getAddressBits());
        sb.append(", entryCount=" + this.getEntryCount());
        sb.append(", nodeCount=" + this.getNodeCount());
        sb.append(", leafCount=" + this.getLeafCount());
        sb.append(", lastCommitTime=" + this.getLastCommitTime());
        sb.append("}");
        return sb.toString();
    }

    protected AbstractHTree(IRawStore store, INodeFactory nodeFactory, boolean readOnly, HTreeIndexMetadata metadata, IRecordCompressorFactory<?> recordCompressorFactory) {
        Banner.banner();
        if (nodeFactory == null) {
            throw new IllegalArgumentException();
        }
        if (metadata == null) {
            throw new IllegalArgumentException();
        }
        this.metadata = metadata;
        this.store = store;
        this.readOnly = readOnly;
        this.addressBits = metadata.getAddressBits();
        if (this.addressBits < 1) {
            throw new IllegalArgumentException("Too small: addressBits=" + this.addressBits);
        }
        if (this.addressBits > 16) {
            throw new IllegalArgumentException("Too large: addressBits=" + this.addressBits);
        }
        this.bucketSlots = 1 << this.addressBits;
        this.memo = new ChildMemoizer(loadChild);
        this.writeRetentionQueue = this.newWriteRetentionQueue(readOnly);
        this.nodeSer = new NodeSerializer(store, nodeFactory, this.addressBits, 0, metadata, readOnly, recordCompressorFactory);
        this.lockManager = ReadWriteLockManager.getLockManager(this);
        this.maxParallelEvictThreads = Integer.parseInt(System.getProperty(IndexMetadata.Options.MAX_PARALLEL_EVICT_THREADS, "10"));
        this.minDirtyListSizeForParallelEvict = Integer.parseInt(System.getProperty(IndexMetadata.Options.MIN_DIRTY_LIST_SIZE_FOR_PARALLEL_EVICT, "5"));
    }

    IHardReferenceQueue<PO> newWriteRetentionQueue(boolean readOnly) {
        int writeRetentionQueueCapacity = this.metadata.getWriteRetentionQueueCapacity();
        int writeRetentionQueueScan = this.metadata.getWriteRetentionQueueScan();
        if (readOnly) {
            return new HardReferenceQueueWithBatchingUpdates<PO>(BigdataStatics.threadLocalBuffers, 16, new HardReferenceQueue<PO>(new DefaultEvictionListener(), writeRetentionQueueCapacity, 0), writeRetentionQueueScan, 128, 64, null);
        }
        return new HardReferenceQueue<PO>(new DefaultEvictionListener(), writeRetentionQueueCapacity, writeRetentionQueueScan);
    }

    public boolean dump(PrintStream out) {
        return this.dump(HTree.dumpLog.getEffectiveLevel(), out, false);
    }

    public boolean dump(Level level, PrintStream out, boolean materialize) {
        boolean info;
        boolean bl = info = level.toInt() <= Level.INFO.toInt();
        if (info) {
            out.print("addressBits=" + this.addressBits);
            out.print(", (2^addressBits)=" + (1 << this.addressBits));
            out.print(", #nodes=" + this.getNodeCount());
            out.print(", #leaves=" + this.getLeafCount());
            out.print(", #entries=" + this.getEntryCount());
            out.println();
        }
        if (this.root != null) {
            return this.root.dump(level, out, 0, true, materialize);
        }
        return true;
    }

    protected void touch(AbstractPage node) {
        assert (node != null);
        if (this.readOnly) {
            this.doTouch(node);
            return;
        }
        int rcount = this.lockManager.getReadLockCount();
        if (rcount <= 0) {
            this.doSyncTouch(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doSyncTouch(AbstractPage node) {
        AbstractHTree abstractHTree = this;
        synchronized (abstractHTree) {
            this.doTouch(node);
        }
    }

    private final void doTouch(AbstractPage node) {
        ++node.referenceCount;
        if (!this.writeRetentionQueue.add(node)) {
            --node.referenceCount;
        } else if (node.referenceCount == 1) {
            ++this.ndistinctOnWriteRetentionQueue;
        }
    }

    protected final void writeNodeRecursive(AbstractPage node) {
        if (node instanceof DirectoryPage && this.getStore() instanceof IIndexManager) {
            this.writeNodeRecursiveConcurrent(node);
        } else {
            this.writeNodeRecursiveCallersThread(node);
        }
    }

    protected final void writeNodeRecursiveCallersThread(AbstractPage node) {
        assert (this.root != null);
        assert (node != null);
        assert (node.isDirty());
        assert (!node.isDeleted());
        assert (!node.isPersistent());
        assert (node.referenceCount >= 0);
        int ndirty = 0;
        int nleaves = 0;
        Iterator<AbstractPage> itr = node.postOrderNodeIterator(true, false);
        while (itr.hasNext()) {
            AbstractPage t = itr.next();
            assert (t.isDirty());
            if (t != this.root) {
                assert (t.parent != null);
                assert (t.parent.get() != null);
            }
            this.writeNodeOrLeaf(t);
            ++ndirty;
            if (!(t instanceof BucketPage)) continue;
            ++nleaves;
        }
    }

    /*
     * Exception decompiling
     */
    protected final void writeNodeRecursiveConcurrent(AbstractPage node) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long writeNodeOrLeaf(AbstractPage node) {
        return this.writeNodeOrLeaf(node, this.nodeSer);
    }

    private long writeNodeOrLeaf(AbstractPage node, NodeSerializer nodeSer) {
        AbstractFixedByteArrayBuffer slice;
        if (this.error != null) {
            throw new IllegalStateException(ERROR_ERROR_STATE, this.error);
        }
        assert (this.root != null);
        assert (node != null);
        assert (node.htree == this);
        assert (node.isDirty());
        assert (!node.isDeleted());
        assert (!node.isPersistent());
        assert (!node.isReadOnly());
        this.assertNotReadOnly();
        assert (node.referenceCount >= 0);
        DirectoryPage parent = node.getParentDirectory();
        if (parent == null) {
            assert (node == this.root);
        } else {
            if (!parent.isDirty()) {
                throw new AssertionError();
            }
            assert (parent.isDirty());
            assert (!parent.isPersistent());
        }
        long beginNanos = System.nanoTime();
        if (node.isLeaf()) {
            assert (1 << this.addressBits - node.globalDepth == parent.countChildRefs((BucketPage)node));
            ((BucketPage)node).data = nodeSer.encodeLive(((BucketPage)node).data);
            slice = ((BucketPage)node).data();
            this.btreeCounters.leavesWritten.increment();
        } else {
            ((DirectoryPage)node).data = nodeSer.encodeLive(((DirectoryPage)node).data);
            slice = ((DirectoryPage)node).data();
            this.btreeCounters.nodesWritten.increment();
        }
        this.btreeCounters.serializeNanos.add(System.nanoTime() - beginNanos);
        if (this.store == null) {
            node.setDirty(false);
            return 0L;
        }
        long beginNanos2 = System.nanoTime();
        long addr = this.store.write(slice.asByteBuffer());
        long oldAddr = node.isPersistent() ? node.getIdentity() : 0L;
        int nbytes = this.store.getByteCount(addr);
        this.btreeCounters.writeNanos.add(System.nanoTime() - beginNanos2);
        this.btreeCounters.bytesWritten.add(nbytes);
        this.btreeCounters.bytesOnStore_nodesAndLeaves.addAndGet(nbytes);
        node.setIdentity(addr);
        if (oldAddr != 0L) {
            this.deleteNodeOrLeaf(oldAddr);
        }
        node.setDirty(false);
        if (parent != null) {
            parent.setChildAddr(node);
        }
        return addr;
    }

    protected AbstractPage readNodeOrLeaf(long addr) {
        if (addr == 0L) {
            throw new IllegalArgumentException();
        }
        long begin = System.nanoTime();
        ByteBuffer tmp = this.store.read(addr);
        assert (tmp.position() == 0);
        this.btreeCounters.readNanos.add(System.nanoTime() - begin);
        int bytesRead = tmp.limit();
        this.btreeCounters.bytesRead.add(bytesRead);
        try {
            long begin2 = System.nanoTime();
            IAbstractNodeData data = this.nodeSer.decode(tmp);
            this.btreeCounters.deserializeNanos.add(System.nanoTime() - begin2);
            if (data.isLeaf()) {
                this.btreeCounters.leavesRead.increment();
            } else {
                this.btreeCounters.nodesRead.increment();
            }
            AbstractPage node = this.nodeSer.wrap(this, addr, data);
            return node;
        }
        catch (Throwable t) {
            throw new RuntimeException("De-serialization problem: addr=" + this.store.toString(addr) + " from store=" + this.store.getFile() + " : cause=" + t, t);
        }
    }

    final <T extends AbstractPage> Reference<AbstractPage> newRef(AbstractPage child) {
        if (this.store == null) {
            return new HardReference<AbstractPage>(child);
        }
        return new WeakReference<AbstractPage>(child);
    }

    public static byte[] encodeRecordAddr(ByteArrayBuffer recordAddrBuf, long addr) {
        recordAddrBuf.reset().putLong(addr);
        return recordAddrBuf.toByteArray();
    }

    public static long decodeRecordAddr(byte[] buf) {
        long v = 0L;
        v += (0xFFL & (long)buf[0]) << 56;
        v += (0xFFL & (long)buf[1]) << 48;
        v += (0xFFL & (long)buf[2]) << 40;
        v += (0xFFL & (long)buf[3]) << 32;
        v += (0xFFL & (long)buf[4]) << 24;
        v += (0xFFL & (long)buf[5]) << 16;
        v += (0xFFL & (long)buf[6]) << 8;
        return v += (0xFFL & (long)buf[7]) << 0;
    }

    int getMaxRecLen() {
        return this.metadata.getMaxRecLen();
    }

    ByteBuffer readRawRecord(long addr) {
        ByteBuffer b = this.getStore().read(addr);
        int nbytes = this.getStore().getByteCount(addr);
        this.btreeCounters.rawRecordsRead.increment();
        this.btreeCounters.rawRecordsBytesRead.add(nbytes);
        return b;
    }

    long writeRawRecord(byte[] b) {
        if (this.isReadOnly()) {
            throw new IllegalStateException(ERROR_READ_ONLY);
        }
        long addr = this.getStore().write(ByteBuffer.wrap(b));
        int nbytes = b.length;
        this.btreeCounters.rawRecordsWritten.increment();
        this.btreeCounters.rawRecordsBytesWritten.add(nbytes);
        this.btreeCounters.bytesOnStore_rawRecords.addAndGet(nbytes);
        return addr;
    }

    void deleteRawRecord(long addr) {
        if (this.isReadOnly()) {
            throw new IllegalStateException(ERROR_READ_ONLY);
        }
        this.getStore().delete(addr);
        int nbytes = this.getStore().getByteCount(addr);
        this.btreeCounters.bytesOnStore_rawRecords.addAndGet(-nbytes);
    }

    void deleteNodeOrLeaf(long addr) {
        if (addr == 0L) {
            throw new IllegalArgumentException();
        }
        if (this.isReadOnly()) {
            throw new IllegalStateException(ERROR_READ_ONLY);
        }
        this.getStore().delete(addr);
        int nbytes = this.getStore().getByteCount(addr);
        this.btreeCounters.bytesOnStore_nodesAndLeaves.addAndGet(-nbytes);
    }

    @Override
    public abstract long rangeCount();

    @Override
    public final ICloseableIterator<?> scan() {
        return new EntryScanIterator(this.rangeIterator());
    }

    public ITupleIterator rangeIterator() {
        return new BucketPageTupleIterator(this, 3, new Striterator(this.getRoot().postOrderIterator()).addFilter(new Filter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isValid(Object obj) {
                return ((AbstractPage)obj).isLeaf();
            }
        }));
    }

    public Iterator<byte[]> values() {
        return new Striterator(this.rangeIterator()).addFilter(new Resolver(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Object resolve(Object obj) {
                return ((ITuple)obj).getValue();
            }
        });
    }

    public void checkConsistency(boolean full) {
        this.checkConsistency(this.root, full);
    }

    public void checkConsistency(AbstractPage pge, boolean full) {
        DirectoryPage parent = pge.getParentDirectory();
        if (parent != null && 1 << this.addressBits - pge.globalDepth != parent.countChildRefs(pge)) {
            throw new HTreePageStateException(pge);
        }
        if (pge instanceof BucketPage) {
            if (parent != this.root && ((BucketPage)pge).data.getKeyCount() == 0) {
                throw new HTreePageStateException(pge);
            }
        } else {
            DirectoryPage dpge = (DirectoryPage)pge;
            int nslots = dpge.childRefs.length;
            for (int i = 0; i < nslots; ++i) {
                AbstractPage ch = dpge.deref(i);
                if (ch == null && full) {
                    ch = dpge.getChild(i);
                }
                if (ch == null) continue;
                this.checkConsistency(ch, full);
            }
        }
    }

    @Override
    public final Lock readLock() {
        return this.lockManager.readLock();
    }

    @Override
    public final Lock writeLock() {
        return this.lockManager.writeLock();
    }

    @Override
    public final int getReadLockCount() {
        return this.lockManager.getReadLockCount();
    }

    public static class HTreePageStateException
    extends RuntimeException {
        final AbstractPage m_pge;

        public HTreePageStateException(AbstractPage pge) {
            super("Problem with Page: " + pge);
            this.m_pge = pge;
        }

        public AbstractPage getPage() {
            return this.m_pge;
        }
    }

    static class HardReference<T>
    extends WeakReference<T> {
        private final T ref;

        HardReference(T ref) {
            super(null);
            this.ref = ref;
        }

        @Override
        public T get() {
            return this.ref;
        }

        @Override
        public void clear() {
        }
    }

    static class ChildMemoizer
    extends Memoizer<LoadChildRequest, AbstractPage> {
        public ChildMemoizer(Computable<LoadChildRequest, AbstractPage> c) {
            super(c);
        }

        void removeFromCache(LoadChildRequest req) {
            if (this.cache.remove(req) == null) {
                throw new AssertionError();
            }
        }
    }

    static class LoadChildRequest {
        final DirectoryPage parent;
        final int index;

        public LoadChildRequest(DirectoryPage parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LoadChildRequest)) {
                return false;
            }
            LoadChildRequest r = (LoadChildRequest)o;
            return this.parent == r.parent && this.index == r.index;
        }

        public int hashCode() {
            return this.parent.hashCode() + this.index;
        }
    }
}

