/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.btree.IRawRecordAccess;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.data.DefaultLeafCoder;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.htree.AbstractPage;
import com.bigdata.htree.BuddyBucketTupleIterator;
import com.bigdata.htree.DirectoryPage;
import com.bigdata.htree.HTree;
import com.bigdata.htree.HTreePageStats;
import com.bigdata.htree.MutableBucketData;
import com.bigdata.htree.Tuple;
import com.bigdata.htree.raba.MutableKeyBuffer;
import com.bigdata.htree.raba.MutableValueBuffer;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.util.BytesUtil;
import cutthecrap.utils.striterators.EmptyIterator;
import cutthecrap.utils.striterators.SingleValueIterator;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Level;

class BucketPage
extends AbstractPage
implements ILeafData,
IRawRecordAccess {
    ILeafData data;

    @Override
    public AbstractFixedByteArrayBuffer data() {
        return this.data.data();
    }

    @Override
    public boolean getDeleteMarker(int index) {
        return this.data.getDeleteMarker(index);
    }

    @Override
    public int getKeyCount() {
        return this.data.getKeyCount();
    }

    @Override
    public IRaba getKeys() {
        return this.data.getKeys();
    }

    @Override
    public long getMaximumVersionTimestamp() {
        return this.data.getMaximumVersionTimestamp();
    }

    @Override
    public long getMinimumVersionTimestamp() {
        return this.data.getMinimumVersionTimestamp();
    }

    @Override
    public long getNextAddr() {
        return this.data.getNextAddr();
    }

    @Override
    public long getPriorAddr() {
        return this.data.getPriorAddr();
    }

    @Override
    public long getRawRecord(int index) {
        return this.data.getRawRecord(index);
    }

    @Override
    public int getValueCount() {
        return this.data.getValueCount();
    }

    @Override
    public IRaba getValues() {
        return this.data.getValues();
    }

    @Override
    public long getVersionTimestamp(int index) {
        return this.data.getVersionTimestamp(index);
    }

    @Override
    public boolean hasDeleteMarkers() {
        return this.data.hasDeleteMarkers();
    }

    @Override
    public boolean hasRawRecords() {
        return this.data.hasRawRecords();
    }

    @Override
    public boolean hasVersionTimestamps() {
        return this.data.hasVersionTimestamps();
    }

    @Override
    public boolean isCoded() {
        return this.data.isCoded();
    }

    @Override
    public boolean isDoubleLinked() {
        return this.data.isDoubleLinked();
    }

    @Override
    public boolean isLeaf() {
        return this.data.isLeaf();
    }

    @Override
    public boolean isReadOnly() {
        return this.data.isReadOnly();
    }

    BucketPage(HTree htree, int globalDepth) {
        super(htree, true, globalDepth);
        int n = htree.bucketSlots;
        htree.getClass();
        htree.getClass();
        this.data = new MutableBucketData(n, false, false, htree.rawRecords);
    }

    BucketPage(HTree htree, long addr, ILeafData data) {
        super(htree, false, 0);
        this.data = data;
        this.setIdentity(addr);
    }

    protected BucketPage(BucketPage src) {
        super(src);
        assert (!src.isDirty());
        assert (src.isReadOnly());
        this.data = src.isReadOnly() ? new MutableBucketData(src.slotsOnPage(), src.data) : src.data;
        src.data = null;
    }

    boolean contains(byte[] key, int buddyOffset) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        int index = this.getKeys().search(key);
        return index >= 0;
    }

    final int slotsOnPage() {
        return this.htree.bucketSlots;
    }

    final byte[] lookupFirst(byte[] key, int buddyOffset) {
        long addr;
        int index = this.lookupIndex(key);
        if (index == -1) {
            return null;
        }
        if (this.hasRawRecords() && (addr = this.getRawRecord(index)) != 0L) {
            return this.getBytes(this.readRawRecord(addr));
        }
        return this.getValues().get(index);
    }

    final byte[] getBytes(ByteBuffer buf) {
        if (buf.hasArray() && buf.arrayOffset() == 0 && buf.position() == 0 && buf.limit() == buf.capacity()) {
            return buf.array();
        }
        ByteBuffer buf2 = buf.asReadOnlyBuffer();
        int len = buf2.remaining();
        byte[] a = new byte[len];
        buf2.get(a);
        return a;
    }

    final int lookupIndex(byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        IRaba keys = this.getKeys();
        int si = keys.search(key);
        return si < 0 ? -1 : si;
    }

    final ITupleIterator lookupAll(byte[] key) {
        return new BuddyBucketTupleIterator(key, this);
    }

    boolean insert(byte[] key, byte[] val) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.parent == null) {
            throw new IllegalArgumentException();
        }
        int slotsOnPage = this.slotsOnPage();
        BucketPage copy = (BucketPage)this.copyOnWrite();
        if (copy != this) {
            return copy.insert(key, val);
        }
        byte[] ival = this.checkRawRecord(val);
        MutableKeyBuffer keys = (MutableKeyBuffer)this.getKeys();
        if (keys.nkeys < keys.capacity()) {
            int insIndex = this.getParentDirectory().isOverflowDirectory() ? keys.nkeys : keys.search(key);
            if (insIndex < 0) {
                insIndex = -insIndex - 1;
            } else if (TRACE) {
                log.trace("Insert duplicate key");
            }
            ((MutableBucketData)this.data).insert(insIndex, key, ival, ival != val);
            ++((HTree)this.htree).nentries;
            return true;
        }
        boolean identicalKeys = true;
        for (int i = 0; i < slotsOnPage; ++i) {
            if (BytesUtil.bytesEqual(key, keys.get(i))) continue;
            identicalKeys = false;
            break;
        }
        if (!identicalKeys) {
            return false;
        }
        BucketPage newPage = new BucketPage((HTree)this.htree, this.globalDepth);
        ++((HTree)this.htree).nleaves;
        DirectoryPage pd = this.getParentDirectory();
        if (pd.isOverflowDirectory()) {
            assert (this.globalDepth == this.htree.addressBits);
            pd._addChild(newPage);
        } else {
            if (pd.getLevel() * this.htree.addressBits > key.length * 8) {
                throw new AssertionError();
            }
            pd._ensureUniqueBucketPage(key, this.self);
            this.globalDepth = this.htree.addressBits;
            newPage.globalDepth = this.htree.addressBits;
            DirectoryPage blob = new DirectoryPage((HTree)this.htree, key, pd.getOverflowPageDepth());
            pd.replaceChildRef(this.self, (AbstractPage)blob);
            blob._addChild(this);
            blob._addChild(newPage);
        }
        newPage.insert(key, val);
        assert (this.dirtyHierarchy());
        return true;
    }

    private byte[] checkRawRecord(byte[] val) {
        if (this.hasRawRecords() && val != null && val.length > this.htree.getMaxRecLen()) {
            long naddr = this.htree.writeRawRecord(val);
            return ((HTree)this.htree).encodeRecordAddr(naddr);
        }
        return val;
    }

    boolean insertRawTuple(BucketPage srcPage, int srcSlot, byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        BucketPage copy = (BucketPage)this.copyOnWrite();
        if (copy != this) {
            return copy.insertRawTuple(srcPage, srcSlot, key);
        }
        int slotsOnPage = this.slotsOnPage();
        MutableKeyBuffer keys = (MutableKeyBuffer)this.getKeys();
        MutableValueBuffer vals = (MutableValueBuffer)this.getValues();
        for (int i = 0; i < slotsOnPage; ++i) {
            if (!keys.isNull(i)) continue;
            ++keys.nkeys;
            keys.keys[i] = key;
            ++vals.nvalues;
            vals.values[i] = srcPage.getValues().get(srcSlot);
            if (srcPage.hasDeleteMarkers()) {
                ((MutableBucketData)this.data).deleteMarkers[i] = srcPage.getDeleteMarker(srcSlot);
            }
            if (srcPage.hasVersionTimestamps()) {
                ((MutableBucketData)this.data).versionTimestamps[i] = srcPage.getVersionTimestamp(srcSlot);
            }
            if (srcPage.hasRawRecords() && srcPage.getRawRecord(srcSlot) != 0L) {
                ((MutableBucketData)this.data).rawRecords[i] = true;
            }
            return true;
        }
        boolean identicalKeys = true;
        for (int i = 0; i < slotsOnPage; ++i) {
            if (BytesUtil.bytesEqual(key, keys.get(i))) continue;
            identicalKeys = false;
            break;
        }
        if (!identicalKeys) {
            return false;
        }
        throw new AssertionError();
    }

    ITupleIterator tuples() {
        return new InnerBucketPageTupleIterator(3);
    }

    @Override
    public Iterator<AbstractPage> postOrderNodeIterator(boolean dirtyNodesOnly, boolean nodesOnly) {
        if (dirtyNodesOnly && !this.isDirty()) {
            return EmptyIterator.DEFAULT;
        }
        if (nodesOnly) {
            return EmptyIterator.DEFAULT;
        }
        return new SingleValueIterator<AbstractPage>(this);
    }

    @Override
    public void PP(StringBuilder sb, boolean showBinary) {
        sb.append(this.PPID() + " [" + this.globalDepth + "] " + BucketPage.indent(this.getLevel()));
        sb.append("(");
        boolean nbuddies = true;
        int slotsPerBuddy = this.slotsOnPage();
        for (int i = 0; i < 1; ++i) {
            if (i > 0) {
                sb.append(";");
            }
            for (int j = 0; j < slotsPerBuddy; ++j) {
                int slot;
                if (j > 0) {
                    sb.append(",");
                }
                if ((slot = i * slotsPerBuddy + j) > 0 && slot % 16 == 0) {
                    sb.append("\n----------" + BucketPage.indent(this.getLevel()));
                }
                sb.append(this.PPVAL(slot, showBinary));
            }
        }
        sb.append(")");
        sb.append("\n");
    }

    private String PPVAL(int index, boolean showBinary) {
        if (index >= this.getKeys().size()) {
            return "-";
        }
        if (index > this.getKeys().capacity()) {
            throw new RuntimeException("index=" + index + ", keys.size=" + this.getKeys().size() + ", keys.capacity=" + this.getKeys().capacity());
        }
        byte[] key = this.getKeys().get(index);
        String keyStr = showBinary ? BytesUtil.toString(key) + "(" + BytesUtil.toBitString(key) + ")" : BytesUtil.toString(key);
        String valStr = null;
        if (valStr == null) {
            return keyStr;
        }
        return keyStr + "=>" + valStr;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{ isDirty=" + this.isDirty());
        sb.append(", isDeleted=" + this.isDeleted());
        sb.append(", addr=" + this.identity);
        DirectoryPage p = this.parent == null ? null : (DirectoryPage)this.parent.get();
        sb.append(", parent=" + (p == null ? "N/A" : p.toShortString()));
        sb.append(", globalDepth=" + this.getGlobalDepth());
        sb.append(", nbuddies=" + (1 << this.htree.addressBits) / (1 << this.globalDepth));
        sb.append(", slotsPerBuddy=" + (1 << this.globalDepth));
        if (this.data == null) {
            sb.append(", data=NA}");
            return sb.toString();
        }
        sb.append(", nkeys=" + this.getKeyCount());
        DefaultLeafCoder.toString(this, sb);
        sb.append("}");
        return sb.toString();
    }

    @Override
    protected boolean dump(Level level, PrintStream out, int height, boolean recursive, boolean materialize) {
        boolean debug = level.toInt() <= Level.DEBUG.toInt();
        boolean ok = true;
        if (this.parent == null || this.parent.get() == null) {
            out.println(BucketPage.indent(height) + "ERROR: parent not set");
            ok = false;
        }
        if (this.globalDepth > ((DirectoryPage)this.parent.get()).globalDepth) {
            out.println(BucketPage.indent(height) + "ERROR: localDepth exceeds globalDepth of parent");
            ok = false;
        }
        if (debug || !ok) {
            out.println(BucketPage.indent(height) + this.toString());
        }
        return ok;
    }

    @Override
    public void dumpPages(boolean recursive, boolean visitLeaves, HTreePageStats stats) {
        if (!visitLeaves) {
            return;
        }
        stats.visit(this.htree, this);
    }

    int distinctBitsRequired() {
        int currentResolution = this.getPrefixLength();
        int testPrefix = currentResolution + 1;
        IRaba keys = this.data.getKeys();
        int nkeys = keys.size();
        int maxPrefix = 0;
        for (int t = 1; t < nkeys; ++t) {
            byte[] k = keys.get(t);
            int klen = k == null ? 0 : k.length;
            maxPrefix = maxPrefix > klen ? maxPrefix : klen;
        }
        maxPrefix *= 8;
        assert (nkeys > 1);
        while (testPrefix < maxPrefix) {
            boolean bitset = BytesUtil.getBit(keys.get(0), testPrefix);
            for (int t = 1; t < nkeys; ++t) {
                byte[] k = keys.get(t);
                if (bitset == (k == null ? false : BytesUtil.getBit(keys.get(t), testPrefix))) continue;
                return testPrefix - currentResolution;
            }
            ++testPrefix;
        }
        return -1;
    }

    public byte[] getValue(int index) {
        if (!this.hasRawRecords()) {
            return this.getValues().get(index);
        }
        long addr = this.getRawRecord(index);
        if (addr == 0L) {
            return this.getValues().get(index);
        }
        ByteBuffer tmp = this.htree.readRawRecord(addr);
        if (tmp.hasArray() && tmp.arrayOffset() == 0 && tmp.position() == 0 && tmp.limit() == tmp.capacity()) {
            return tmp.array();
        }
        int len = tmp.remaining();
        byte[] a = new byte[len];
        tmp.get(a);
        return a;
    }

    @Override
    public final ByteBuffer readRawRecord(long addr) {
        return this.htree.readRawRecord(addr);
    }

    void split() {
        BucketPage copy = (BucketPage)this.copyOnWrite();
        if (copy != this) {
            copy.split();
            return;
        }
        this.getParentDirectory()._splitBucketPage(this);
    }

    void addLevel() {
        BucketPage copy = (BucketPage)this.copyOnWrite();
        if (copy != this) {
            copy.addLevel();
            return;
        }
        this.getParentDirectory()._addLevel(this);
    }

    @Override
    boolean isClean() {
        return !this.isDirty();
    }

    @Override
    public int removeAll(byte[] key) {
        if (this.isReadOnly()) {
            BucketPage copy = (BucketPage)this.copyOnWrite(this.getIdentity());
            return copy.removeAll(key);
        }
        int ret = 0;
        while (this.removeFirst(key) != null) {
            ++ret;
        }
        return ret;
    }

    @Override
    public final byte[] removeFirst(byte[] key) {
        byte[] ret;
        long addr;
        if (this.isReadOnly()) {
            BucketPage copy = (BucketPage)this.copyOnWrite(this.getIdentity());
            return copy.removeFirst(key);
        }
        int index = this.lookupIndex(key);
        if (index == -1) {
            return null;
        }
        long l = addr = this.hasRawRecords() ? this.getRawRecord(index) : 0L;
        if (addr != 0L) {
            ret = this.getBytes(this.htree.readRawRecord(addr));
            this.htree.deleteRawRecord(addr);
        } else {
            ret = this.data.getValues().get(index);
        }
        ((MutableBucketData)this.data).remove(index);
        return ret;
    }

    public byte[] getFirstKey() {
        assert (this.data.getKeys().size() > 0);
        return this.data.getKeys().get(0);
    }

    private class InnerBucketPageTupleIterator<E>
    implements ITupleIterator<E> {
        private final int slotsPerPage;
        private int nextNonEmptySlot;
        private final Tuple<E> tuple;

        InnerBucketPageTupleIterator(int flags) {
            this.slotsPerPage = BucketPage.this.slotsOnPage();
            this.nextNonEmptySlot = 0;
            this.tuple = this.findNextSlot() ? new Tuple(BucketPage.this.htree, flags) : null;
        }

        private boolean findNextSlot() {
            IRaba keys = BucketPage.this.getKeys();
            int size = keys.size();
            while (this.nextNonEmptySlot < size) {
                if (!keys.isNull(this.nextNonEmptySlot)) {
                    return true;
                }
                ++this.nextNonEmptySlot;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.nextNonEmptySlot < BucketPage.this.getKeys().size();
        }

        @Override
        public ITuple<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.tuple.copy(this.nextNonEmptySlot, BucketPage.this);
            ++this.nextNonEmptySlot;
            this.findNextSlot();
            return this.tuple;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

