/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.htree;

import com.bigdata.btree.AbstractTuple;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.htree.BucketPage;
import com.bigdata.htree.Tuple;
import com.bigdata.util.BytesUtil;
import java.util.NoSuchElementException;

class BuddyBucketTupleIterator<E>
implements ITupleIterator<E> {
    private final byte[] key;
    private final BucketPage bucket;
    private final int lastSlot;
    private int index;
    private int lastVisited = -1;
    private final AbstractTuple<E> tuple;

    public BuddyBucketTupleIterator(byte[] key, BucketPage bucket) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (bucket == null) {
            throw new IllegalArgumentException();
        }
        this.key = key;
        this.bucket = bucket;
        this.lastSlot = bucket.getKeys().size();
        this.index = bucket.lookupIndex(key);
        this.tuple = new Tuple(bucket.htree, 3);
    }

    @Override
    public boolean hasNext() {
        if (this.index == -1) {
            return false;
        }
        IRaba keys = this.bucket.getKeys();
        assert (keys.size() == this.lastSlot);
        assert (keys.size() <= keys.capacity());
        while (this.index < this.lastSlot) {
            if (!keys.isNull(this.index) && BytesUtil.bytesEqual(this.key, keys.get(this.index))) {
                return true;
            }
            this.index = this.lastSlot;
            ++this.index;
        }
        return false;
    }

    @Override
    public ITuple<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastVisited = this.index++;
        this.tuple.copy(this.lastVisited, this.bucket);
        return this.tuple;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

