/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import com.bigdata.io.DataInputBuffer;
import com.bigdata.io.FixedByteArrayBuffer;
import com.bigdata.io.IFixedDataRecord;
import com.bigdata.util.BytesUtil;
import it.unimi.dsi.io.InputBitStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class AbstractFixedByteArrayBuffer
implements IFixedDataRecord {
    private final int off;
    private final int len;

    @Override
    public final int off() {
        return this.off;
    }

    @Override
    public final int len() {
        return this.len;
    }

    public static FixedByteArrayBuffer wrap(byte[] array) {
        return new FixedByteArrayBuffer(array, 0, array.length);
    }

    protected AbstractFixedByteArrayBuffer(int off, int len) {
        if (off < 0) {
            throw new IllegalArgumentException("off<0");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len<0");
        }
        this.off = off;
        this.len = len;
    }

    protected boolean rangeCheck(int aoff, int alen) {
        if (aoff < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (alen < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (aoff + alen > this.len) {
            throw new IndexOutOfBoundsException();
        }
        return true;
    }

    @Override
    public final void put(int pos, byte[] b) {
        this.put(pos, b, 0, b.length);
    }

    @Override
    public final void put(int dstoff, byte[] src, int srcoff, int srclen) {
        assert (this.rangeCheck(dstoff, srclen));
        System.arraycopy(src, srcoff, this.array(), this.off + dstoff, srclen);
    }

    @Override
    public final void get(int srcoff, byte[] dst) {
        this.get(srcoff, dst, 0, dst.length);
    }

    @Override
    public final void get(int srcoff, byte[] dst, int dstoff, int dstlen) {
        assert (this.rangeCheck(srcoff, dstlen));
        System.arraycopy(this.array(), this.off + srcoff, dst, dstoff, dstlen);
    }

    @Override
    public final void putByte(int pos, byte v) {
        assert (this.rangeCheck(pos, 1));
        this.array()[this.off + pos] = v;
    }

    @Override
    public final byte getByte(int pos) {
        assert (this.rangeCheck(pos, 1));
        return this.array()[this.off + pos];
    }

    @Override
    public final void putShort(int pos, short v) {
        assert (this.rangeCheck(pos, 2));
        pos += this.off;
        this.array()[pos++] = (byte)(v >>> 8);
        this.array()[pos] = (byte)(v >>> 0);
    }

    @Override
    public final short getShort(int pos) {
        assert (this.rangeCheck(pos, 2));
        pos += this.off;
        short v = 0;
        v = (short)(v + ((0xFF & this.array()[pos++]) << 8));
        v = (short)(v + ((0xFF & this.array()[pos]) << 0));
        return v;
    }

    @Override
    public final void putInt(int pos, int v) {
        assert (this.rangeCheck(pos, 4));
        pos += this.off;
        this.array()[pos++] = (byte)(v >>> 24);
        this.array()[pos++] = (byte)(v >>> 16);
        this.array()[pos++] = (byte)(v >>> 8);
        this.array()[pos] = (byte)(v >>> 0);
    }

    @Override
    public final int getInt(int pos) {
        assert (this.rangeCheck(pos, 4));
        pos += this.off;
        int v = 0;
        v += (0xFF & this.array()[pos++]) << 24;
        v += (0xFF & this.array()[pos++]) << 16;
        v += (0xFF & this.array()[pos++]) << 8;
        return v += (0xFF & this.array()[pos]) << 0;
    }

    @Override
    public final void putFloat(int pos, float f) {
        this.putInt(pos, Float.floatToIntBits(f));
    }

    @Override
    public final float getFloat(int pos) {
        return Float.intBitsToFloat(this.getInt(pos));
    }

    @Override
    public final void putLong(int pos, long v) {
        assert (this.rangeCheck(pos, 8));
        pos += this.off;
        this.array()[pos++] = (byte)(v >>> 56);
        this.array()[pos++] = (byte)(v >>> 48);
        this.array()[pos++] = (byte)(v >>> 40);
        this.array()[pos++] = (byte)(v >>> 32);
        this.array()[pos++] = (byte)(v >>> 24);
        this.array()[pos++] = (byte)(v >>> 16);
        this.array()[pos++] = (byte)(v >>> 8);
        this.array()[pos] = (byte)(v >>> 0);
    }

    @Override
    public final void putDouble(int pos, double d) {
        this.putLong(pos, Double.doubleToLongBits(d));
    }

    @Override
    public final long getLong(int pos) {
        assert (this.rangeCheck(pos, 8));
        pos += this.off;
        long v = 0L;
        v += (0xFFL & (long)this.array()[pos++]) << 56;
        v += (0xFFL & (long)this.array()[pos++]) << 48;
        v += (0xFFL & (long)this.array()[pos++]) << 40;
        v += (0xFFL & (long)this.array()[pos++]) << 32;
        v += (0xFFL & (long)this.array()[pos++]) << 24;
        v += (0xFFL & (long)this.array()[pos++]) << 16;
        v += (0xFFL & (long)this.array()[pos++]) << 8;
        return v += (0xFFL & (long)this.array()[pos]) << 0;
    }

    @Override
    public final double getDouble(int pos) {
        return Double.longBitsToDouble(this.getLong(pos));
    }

    @Override
    public final boolean getBit(long bitIndex) {
        assert (this.rangeCheck(BytesUtil.byteIndexForBit(bitIndex), 1));
        return BytesUtil.getBit(this.array(), (long)(this.off << 3) + bitIndex);
    }

    @Override
    public final boolean setBit(long bitIndex, boolean value) {
        assert (this.rangeCheck(BytesUtil.byteIndexForBit(bitIndex), 1));
        return BytesUtil.setBit(this.array(), (long)(this.off << 3) + bitIndex, value);
    }

    @Override
    public final byte[] toByteArray() {
        byte[] tmp = new byte[this.len];
        System.arraycopy(this.array(), this.off, tmp, 0, this.len);
        return tmp;
    }

    @Override
    public final ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.array(), this.off, this.len);
    }

    @Override
    public AbstractFixedByteArrayBuffer slice(int aoff, int alen) {
        assert (this.rangeCheck(aoff, alen));
        return new AbstractFixedByteArrayBuffer(this.off() + aoff, alen){

            @Override
            public byte[] array() {
                return AbstractFixedByteArrayBuffer.this.array();
            }
        };
    }

    @Override
    public DataInputBuffer getDataInput() {
        return new DataInputBuffer(this.array(), this.off, this.len);
    }

    @Override
    public InputBitStream getInputBitStream() {
        return new InputBitStream(this.array(), this.off, this.len);
    }

    @Override
    public final void writeOn(OutputStream os) throws IOException {
        os.write(this.array(), this.off, this.len);
    }

    @Override
    public final void writeOn(DataOutput out) throws IOException {
        out.write(this.array(), this.off, this.len);
    }

    @Override
    public final void writeOn(OutputStream os, int aoff, int alen) throws IOException {
        if (aoff < 0) {
            throw new IllegalArgumentException();
        }
        if (aoff + alen > this.len) {
            throw new IllegalArgumentException();
        }
        os.write(this.array(), this.off + aoff, alen);
    }
}

