/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.IBufferAccess;
import com.bigdata.io.IReopenChannel;
import com.bigdata.io.NOPReopener;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.NonReadableChannelException;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FileChannelUtility {
    private static final Logger log = Logger.getLogger(FileChannelUtility.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();

    public static int readAll(FileChannel channel, ByteBuffer src, long pos) throws IOException {
        return FileChannelUtility.readAll(new NOPReopener(channel), src, pos);
    }

    public static int readAll(IReopenChannel<FileChannel> opener, ByteBuffer src, long pos) throws IOException {
        if (opener == null) {
            throw new IllegalArgumentException();
        }
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
        int nbytes = src.remaining();
        if (nbytes == 0) {
            throw new IllegalArgumentException();
        }
        if (DEBUG) {
            log.debug("pos=" + pos + ", #bytes=" + nbytes);
        }
        int nreads = 0;
        int count = 0;
        while (count < nbytes) {
            int nread;
            FileChannel channel = opener.reopenChannel();
            if (channel == null) {
                throw new AssertionError((Object)"Channel is null?");
            }
            try {
                nread = channel.read(src, pos + (long)count);
            }
            catch (ClosedByInterruptException ex) {
                throw ex;
            }
            catch (AsynchronousCloseException ex) {
                continue;
            }
            catch (ClosedChannelException ex) {
                continue;
            }
            catch (IOException ex) {
                throw ex;
            }
            if (nread == -1) {
                throw new IOException("EOF reading on channel: remaining=" + (nbytes - count) + ", nread=" + nreads + ", pos=" + pos + ", bytesRead=" + count);
            }
            count += nread;
            if (++nreads == 100) {
                log.warn("reading on channel: remaining=" + (nbytes - count) + ", nread=" + nreads + ", pos=" + pos + ", bytesRead=" + count);
                continue;
            }
            if (nreads == 1000) {
                log.error("reading on channel: remaining=" + (nbytes - count) + ", nread=" + nreads + ", pos=" + pos + ", bytesRead=" + count);
                continue;
            }
            if (nreads <= 10000) continue;
            throw new RuntimeException("reading on channel: remaining=" + (nbytes - count) + ", nread=" + nreads + ", pos=" + pos + ", bytesRead=" + count);
        }
        if (count != nbytes) {
            throw new RuntimeException("Expected to read " + nbytes + " bytes but read " + count + " bytes in " + nreads + " reads");
        }
        if (INFO) {
            log.info("read " + nbytes + " bytes from offset=" + pos + " in " + nreads + " IOs");
        }
        return nreads;
    }

    /*
     * Exception decompiling
     */
    public static long readAllAsync(IAsyncOpener opener, List<AsyncTransfer> transfers) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int writeAll(FileChannel channel, ByteBuffer data, long pos) throws IOException {
        return FileChannelUtility.writeAll(new NOPReopener(channel), data, pos);
    }

    public static int writeAll(IReopenChannel<FileChannel> opener, ByteBuffer data, long pos) throws IOException {
        long begin = System.nanoTime();
        int nbytes = data.remaining();
        int count = 0;
        int nwrites = 0;
        while (data.remaining() > 0) {
            int nwritten;
            FileChannel channel = opener.reopenChannel();
            if (channel == null) {
                throw new AssertionError((Object)"Channel is null?");
            }
            try {
                nwritten = channel.write(data, pos + (long)count);
            }
            catch (ClosedByInterruptException ex) {
                throw ex;
            }
            catch (AsynchronousCloseException ex) {
                continue;
            }
            catch (ClosedChannelException ex) {
                continue;
            }
            catch (IOException ex) {
                throw ex;
            }
            count += nwritten;
            if (++nwrites == 100) {
                log.warn("writing on channel: remaining=" + data.remaining() + ", nwrites=" + nwrites + ", written=" + count);
                continue;
            }
            if (nwrites == 1000) {
                log.error("writing on channel: remaining=" + data.remaining() + ", nwrites=" + nwrites + ", written=" + count);
                continue;
            }
            if (nwrites <= 10000) continue;
            throw new RuntimeException("writing on channel: remaining=" + data.remaining() + ", nwrites=" + nwrites + ", written=" + count);
        }
        if (count != nbytes) {
            throw new RuntimeException("Expecting to write " + nbytes + " bytes, but wrote " + count + " bytes in " + nwrites);
        }
        long elapsed = System.nanoTime() - begin;
        if (INFO) {
            log.info("wrote on disk: address: " + pos + ", bytes=" + nbytes + ", elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsed) + "ms");
        }
        return nwrites;
    }

    public static int transferAll(FileChannel sourceChannel, long fromPosition, long count, RandomAccessFile out, long toPosition) throws IOException {
        long n;
        long nbytes;
        long begin = System.currentTimeMillis();
        FileChannel outChannel = out.getChannel();
        sourceChannel.position(fromPosition);
        out.setLength(toPosition + count);
        if (INFO) {
            log.info("fromPosition=" + fromPosition + ", count=" + count + ", toPosition=" + toPosition);
        }
        int nwrites = 0;
        long nwritten = 0L;
        long to = toPosition;
        for (n = count; n > 0L; n -= nbytes) {
            nbytes = outChannel.transferFrom(sourceChannel, to, n);
            to += nbytes;
            nwritten += nbytes;
            if (++nwrites == 100) {
                log.warn("writing on channel: remaining=" + n + ", nwrites=" + nwrites + ", written=" + nwritten + " of " + count + " bytes");
                continue;
            }
            if (nwrites != 1000) continue;
            log.error("writing on channel: remaining=" + n + ", nwrites=" + nwrites + ", written=" + nwritten + " of " + count + " bytes");
        }
        if (n != 0L) {
            throw new IOException("Expected to transfer " + count + ", but transferred " + (count - n));
        }
        outChannel.position(toPosition + count);
        long elapsed = System.currentTimeMillis() - begin;
        if (INFO) {
            log.info("Transferred " + count + " bytes from disk channel at offset " + fromPosition + " to disk channel at offset=" + toPosition + " in " + nwrites + " writes and " + elapsed + "ms");
        }
        return nwrites;
    }

    public static class ReopenerInputStream
    extends InputStream {
        private final IReopenChannel<FileChannel> m_opener;
        private final ByteBuffer m_buffer;
        private final IBufferAccess m_bufferAccess;
        private final long m_eof;
        private long m_cursor = 0L;
        private final byte[] m_singleByte = new byte[1];

        public ReopenerInputStream(IReopenChannel<FileChannel> opener) throws IOException {
            this.m_opener = opener;
            this.m_eof = opener.reopenChannel().size();
            try {
                this.m_bufferAccess = DirectBufferPool.INSTANCE.acquire();
                this.m_buffer = this.m_bufferAccess.buffer();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            try {
                this.m_bufferAccess.release();
            }
            catch (InterruptedException e) {
                log.warn(e);
            }
        }

        @Override
        public int read() throws IOException {
            int ret = this.read(this.m_singleByte, 0, 1);
            if (ret == -1) {
                return -1;
            }
            return this.m_singleByte[0];
        }

        @Override
        public int read(byte[] dst) throws IOException {
            return this.read(dst, 0, dst.length);
        }

        @Override
        public int read(byte[] dst, int off, int len) throws IOException {
            int rdlen = (int)(this.m_cursor + (long)len < this.m_eof ? (long)len : this.m_eof - this.m_cursor);
            if (rdlen == 0) {
                return -1;
            }
            this.m_buffer.position(0);
            this.m_buffer.limit(rdlen);
            int ret = FileChannelUtility.readAll(this.m_opener, this.m_buffer, this.m_cursor);
            if (ret > 0) {
                this.m_cursor += (long)rdlen;
                if (log.isTraceEnabled()) {
                    log.trace("Request for " + len + " bytes");
                }
                this.m_buffer.position(0);
                this.m_buffer.limit(rdlen);
                this.m_buffer.get(dst, off, rdlen);
                return rdlen;
            }
            return -1;
        }
    }

    public static class AsyncTransfer {
        private final long m_addr;
        private final int m_bytesToRead;
        private final ByteBuffer m_buffer;
        private Future<Integer> m_fut = null;

        public AsyncTransfer(long addr, ByteBuffer buffer) {
            this.m_addr = addr;
            this.m_buffer = buffer;
            this.m_bytesToRead = buffer.remaining();
            this.m_buffer.mark();
        }

        private void read(AsynchronousFileChannel channel) throws IllegalArgumentException, NonReadableChannelException, CancellationException, InterruptedException {
            if (this.isDone()) {
                try {
                    this.m_fut.get();
                }
                catch (ExecutionException ex) {
                    this.m_fut = null;
                }
            }
            if (!this.isDone()) {
                this.m_buffer.reset();
                this.m_fut = channel.read(this.m_buffer, this.m_addr);
            }
        }

        public int complete() throws InterruptedException, ExecutionException, IllegalStateException {
            if (this.m_fut == null) {
                throw new IllegalStateException("Future is not set");
            }
            return this.m_fut.get();
        }

        public void cancel() {
            if (this.m_fut != null) {
                this.m_fut.cancel(true);
            }
        }

        public boolean isDone() {
            return this.m_fut != null && this.m_fut.isDone();
        }

        static /* synthetic */ int access$000(AsyncTransfer x0) {
            return x0.m_bytesToRead;
        }

        static /* synthetic */ void access$100(AsyncTransfer x0, AsynchronousFileChannel x1) throws IllegalArgumentException, NonReadableChannelException, CancellationException, InterruptedException {
            x0.read(x1);
        }
    }

    public static interface IAsyncOpener {
        public AsynchronousFileChannel getAsyncChannel();
    }
}

