/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MergeStreamWithSortedSet {
    private static final transient Logger log = Logger.getLogger(MergeStreamWithSortedSet.class);

    public static void process(InputStream in, Set<Map.Entry<Long, byte[]>> snapshotData, OutputStream out) throws IOException {
        byte[] bb = new byte[4096];
        Iterator<Map.Entry<Long, byte[]>> bbs = snapshotData.iterator();
        long curs = 0L;
        while (bbs.hasNext()) {
            Map.Entry<Long, byte[]> e = bbs.next();
            long pos = e.getKey();
            byte[] buf = e.getValue();
            long blen = buf.length;
            if (curs < pos) {
                MergeStreamWithSortedSet.transfer(in, pos - curs, bb, out);
                curs = pos;
            }
            out.write(buf);
            log.info("Write ByteBuffer at " + pos + ", length: " + blen);
            curs += blen;
            in.skip(blen);
        }
        MergeStreamWithSortedSet.transfer(in, Long.MAX_VALUE, bb, out);
    }

    private static void transfer(InputStream in, long len, byte[] buf, OutputStream out) throws IOException {
        long rem;
        int rdlen;
        for (rem = len; rem > (long)buf.length; rem -= (long)rdlen) {
            rdlen = in.read(buf);
            if (rdlen == -1) {
                return;
            }
            out.write(buf, 0, rdlen);
        }
        rdlen = in.read(buf, 0, (int)rem);
        if (rdlen == -1) {
            return;
        }
        out.write(buf, 0, rdlen);
    }
}

