/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channels;
import org.apache.log4j.Logger;

public class ObjectSocketChannelStream {
    protected static final Logger log = Logger.getLogger(ObjectSocketChannelStream.class);
    ObjectOutputStream outStr = null;
    ObjectInputStream inStr = null;
    final ByteChannel channel;
    byte[] buf = new byte[2048];

    public ObjectSocketChannelStream(ByteChannel channel) {
        this.channel = channel;
    }

    public ByteChannel getChannel() {
        return this.channel;
    }

    public void writeObject(Object obj) throws IOException {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ObjectOutputStream outobj = new ObjectOutputStream(baout);
        outobj.writeObject(obj);
        outobj.flush();
        byte[] buf = baout.toByteArray();
        this.channel.write(ByteBuffer.wrap(buf));
    }

    public Object readObject() throws IOException {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ObjectOutputStream outobj = new ObjectOutputStream(baout);
        outobj.flush();
        byte[] buf = baout.toByteArray();
        this.channel.write(ByteBuffer.wrap(buf));
        return null;
    }

    public ObjectInputStream getInputStream() {
        if (this.inStr == null) {
            try {
                this.inStr = new ObjectInputStream(Channels.newInputStream(this.channel));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.inStr;
    }

    public ObjectOutputStream getOutputStream() {
        if (this.outStr == null) {
            try {
                this.outStr = new ObjectOutputStream(Channels.newOutputStream(this.channel));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.outStr;
    }

    private void checkBuffer(int sze) {
        if (this.buf.length < sze) {
            this.buf = new byte[sze + 2048];
        }
    }

    public byte[] readByteArray(int sze) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("readByteArray: " + sze);
        }
        this.checkBuffer(sze);
        int totrd = 0;
        int tsze = sze;
        while (tsze > 0) {
            int rdlen = this.getInputStream().read(this.buf, totrd, tsze);
            tsze -= rdlen;
            totrd += rdlen;
        }
        if (log.isTraceEnabled()) {
            log.trace("Read buffer of " + sze + " bytes, actual: " + totrd);
        }
        return this.buf;
    }

    public void write(ByteBuffer tmp) throws IOException {
        int sze = tmp.limit();
        byte[] loc = null;
        if (tmp.hasArray()) {
            loc = tmp.array();
        } else {
            this.checkBuffer(sze);
            tmp.get(this.buf, 0, sze);
            loc = this.buf;
        }
        if (log.isTraceEnabled()) {
            log.trace("Writing buffer of " + sze + " bytes");
        }
        this.getOutputStream().write(loc, 0, sze);
    }

    public static OutputStream newOutputStream(final ByteChannel channel) {
        return new OutputStream(){
            final ByteBuffer buf = ByteBuffer.allocate(2048);

            @Override
            public synchronized void write(int b) throws IOException {
                if (this.buf.remaining() == 0) {
                    this.flush();
                }
                this.buf.put((byte)b);
            }

            @Override
            public synchronized void write(byte[] bytes, int off, int len) throws IOException {
                int rem = this.buf.remaining();
                while (len > rem) {
                    len -= rem;
                    this.buf.put(bytes, off, rem);
                    off += rem;
                    this.flush();
                    rem = this.buf.remaining();
                }
                this.buf.put(bytes, off, len);
            }

            @Override
            public synchronized void flush() {
                try {
                    channel.write(this.buf);
                    this.buf.reset();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public static InputStream newInputStream(final ByteChannel channel) {
        final ByteBuffer buf = ByteBuffer.allocate(2048);
        return new InputStream(){

            @Override
            public synchronized int read() throws IOException {
                if (!buf.hasRemaining()) {
                    channel.read(buf);
                }
                return buf.get();
            }

            @Override
            public synchronized int read(byte[] bytes, int off, int len) throws IOException {
                int rem = buf.remaining();
                while (rem < len) {
                    if (rem > 0) {
                        buf.get(bytes, off, rem);
                        off += rem;
                        len -= rem;
                    }
                    channel.read(buf);
                    rem = buf.remaining();
                }
                buf.get(bytes, off, len);
                return len;
            }
        };
    }
}

