/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io.compression;

import com.bigdata.io.ByteBufferInputStream;
import com.bigdata.io.ByteBufferOutputStream;
import com.bigdata.io.compression.CompressorRegistry;
import com.bigdata.io.compression.IRecordCompressor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.log4j.Logger;

public class RecordCompressor
implements Externalizable,
IRecordCompressor {
    protected static final Logger log = Logger.getLogger(CompressorRegistry.class);
    private static final long serialVersionUID = -2028159717578047153L;
    private transient Deflater _deflater;
    private final transient Inflater _inflater = new Inflater();
    private transient byte[] _buf = new byte[1024];
    private int level;

    public String toString() {
        return this.getClass().getName() + "{level=" + this.level + "}";
    }

    public RecordCompressor(int level) {
        this._deflater = new Deflater(level);
        this.level = level;
    }

    public RecordCompressor() {
    }

    @Override
    public void compress(ByteBuffer bin, ByteBuffer out) {
        this.compress(bin, (OutputStream)new ByteBufferOutputStream(out));
    }

    @Override
    public ByteBuffer compress(ByteBuffer bin) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.compress(bin, (OutputStream)out);
        if (log.isTraceEnabled()) {
            log.trace("Record compression from " + bin.limit() + " to " + out.size());
        }
        return ByteBuffer.wrap(out.toByteArray());
    }

    @Override
    public void compress(ByteBuffer bin, OutputStream os) {
        if (bin.hasArray() && bin.position() == 0 && bin.limit() == bin.capacity()) {
            this.compress(bin.array(), bin.position(), bin.limit(), os);
            bin.position(bin.limit());
        } else {
            int size = bin.remaining();
            if (this._buf.length < size) {
                this._buf = new byte[size];
            }
            bin.get(this._buf, 0, size);
            this.compress(this._buf, 0, size, os);
        }
    }

    @Override
    public void compress(byte[] bytes, OutputStream os) {
        this.compress(bytes, 0, bytes.length, os);
    }

    @Override
    public void compress(byte[] bytes, int off, int len, OutputStream os) {
        this._deflater.reset();
        DeflaterOutputStream dos = new DeflaterOutputStream(os, this._deflater);
        try {
            dos.write(bytes, off, len);
            dos.flush();
            dos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public ByteBuffer decompress(ByteBuffer bin) {
        this._inflater.reset();
        int size = bin.limit();
        InflaterInputStream iis = new InflaterInputStream(new ByteBufferInputStream(bin), this._inflater, size);
        return this.decompress(iis);
    }

    @Override
    public ByteBuffer decompress(byte[] bin) {
        this._inflater.reset();
        int size = bin.length;
        InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(bin), this._inflater, size);
        return this.decompress(iis);
    }

    protected ByteBuffer decompress(InflaterInputStream iis) {
        int off = 0;
        try {
            while (true) {
                int nread;
                int capacity;
                if ((capacity = this._buf.length - off) == 0) {
                    byte[] tmp = new byte[this._buf.length * 2];
                    System.arraycopy(this._buf, 0, tmp, 0, off);
                    this._buf = tmp;
                    capacity = this._buf.length - off;
                }
                if ((nread = iis.read(this._buf, off, capacity)) != -1) {
                    off += nread;
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return ByteBuffer.wrap(this._buf, 0, off).asReadOnlyBuffer();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.level = in.readInt();
        this._deflater = new Deflater(this.level);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.level);
    }
}

