/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io.writecache;

import com.bigdata.counters.CounterSet;
import com.bigdata.ha.msg.HAWriteMessage;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.io.ChecksumUtility;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.FileChannelUtility;
import com.bigdata.io.IBufferAccess;
import com.bigdata.io.IReopenChannel;
import com.bigdata.io.compression.CompressorRegistry;
import com.bigdata.io.compression.IRecordCompressor;
import com.bigdata.io.writecache.BufferedWrite;
import com.bigdata.io.writecache.IWriteCache;
import com.bigdata.io.writecache.WriteCacheCounters;
import com.bigdata.journal.StoreTypeEnum;
import com.bigdata.util.ChecksumError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public abstract class WriteCache
implements IWriteCache {
    protected static final Logger log = Logger.getLogger(WriteCache.class);
    private final boolean useChecksum;
    private final boolean prefixWrites;
    static final int SIZEOF_PREFIX_WRITE_METADATA = 16;
    static final int PREFIX_OFFSET_POS = 0;
    static final int PREFIX_SIZE_POS = 8;
    private final AtomicReference<IBufferAccess> buf;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final ReentrantLock transferLock = new ReentrantLock();
    protected final ConcurrentMap<Long, RecordMetadata> recordMap;
    private final List<RecordMetadata> orderedRecords;
    private final AtomicLong firstOffset = new AtomicLong(-1L);
    private final int capacity;
    private final boolean releaseBuffer;
    private final ChecksumHelper checker;
    private final AtomicLong fileExtent = new AtomicLong();
    private volatile boolean m_closedForWrites = false;
    protected final AtomicReference<WriteCacheCounters> counters = new AtomicReference<WriteCacheCounters>(new WriteCacheCounters());
    private volatile int m_removed;
    boolean m_written = false;
    private long lastOffset;
    final AtomicInteger m_referenceCount = new AtomicInteger(0);

    private ByteBuffer acquire() throws InterruptedException, IllegalStateException {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lockInterruptibly();
        try {
            IBufferAccess tmp = this.buf.get();
            if (tmp == null) {
                throw new IllegalStateException();
            }
            return tmp.buffer();
        }
        catch (Throwable t) {
            readLock.unlock();
            if (t instanceof InterruptedException) {
                throw (InterruptedException)t;
            }
            if (t instanceof IllegalStateException) {
                throw (IllegalStateException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private void release() {
        this.lock.readLock().unlock();
    }

    ByteBuffer peek() {
        ByteBuffer b = this.buf.get().buffer();
        return b == null ? null : b.asReadOnlyBuffer();
    }

    protected void setFirstOffset(long firstOffset) {
        this.firstOffset.set(firstOffset);
    }

    public WriteCache(IBufferAccess buf, boolean prefixWrites, boolean useChecksum, boolean isHighlyAvailable, boolean bufferHasData, long fileExtent) throws InterruptedException {
        if (bufferHasData && buf == null) {
            throw new IllegalArgumentException();
        }
        if (buf == null) {
            buf = DirectBufferPool.INSTANCE.acquire();
            this.releaseBuffer = true;
        } else {
            this.releaseBuffer = false;
        }
        this.useChecksum = useChecksum;
        this.prefixWrites = prefixWrites;
        this.checker = isHighlyAvailable && !bufferHasData ? new ChecksumHelper() : null;
        this.buf = new AtomicReference<IBufferAccess>(buf);
        this.capacity = buf.buffer().capacity();
        this.fileExtent.set(fileExtent);
        if (!bufferHasData) {
            buf.buffer().clear();
        }
        int indexDefaultCapacity = this.capacity / 1024;
        this.recordMap = prefixWrites ? new ConcurrentSkipListMap<Long, RecordMetadata>() : new ConcurrentHashMap<Long, RecordMetadata>(indexDefaultCapacity);
        this.orderedRecords = isHighlyAvailable && !bufferHasData ? new LinkedList<RecordMetadata>() : null;
        if (bufferHasData) {
            this.resetRecordMapFromBuffer();
        }
    }

    public String toString() {
        return super.toString() + "{recordCount=" + this.recordMap.size() + ",firstOffset=" + this.firstOffset + ",releaseBuffer=" + this.releaseBuffer + ",prefixWrites=" + this.prefixWrites + ",useChecksum=" + this.useChecksum + ",bytesWritten=" + this.bytesWritten() + ",bytesRemaining=" + this.remaining() + ",bytesRemoved=" + this.m_removed + "}";
    }

    final long getFirstOffset() {
        return this.firstOffset.get();
    }

    public final int capacity() {
        return this.capacity - (this.useChecksum ? 4 : 0) - (this.prefixWrites ? 16 : 0);
    }

    final int remaining() {
        int remaining = this.capacity - this.bytesWritten();
        return remaining;
    }

    public final int bytesWritten() {
        return this.buf.get().buffer().position();
    }

    final boolean isEmpty() {
        return this.recordMap.isEmpty();
    }

    public void setFileExtent(long fileExtent) {
        if (fileExtent < 0L) {
            throw new IllegalArgumentException();
        }
        this.fileExtent.set(fileExtent);
    }

    public long getFileExtent() {
        return this.fileExtent.get();
    }

    int getWholeBufferChecksum(ByteBuffer checksumBuffer, ByteBuffer src, boolean isCompressed) {
        if (this.checker == null) {
            throw new UnsupportedOperationException();
        }
        if (isCompressed || this.prefixWrites) {
            assert (checksumBuffer.capacity() >= src.limit()) : "b.limit=" + src.limit() + ", checksumBuffer.capacity=" + checksumBuffer.capacity();
            checksumBuffer.limit(src.limit());
            checksumBuffer.position(0);
            checksumBuffer.put(src);
            checksumBuffer.flip();
            this.checker.reset();
            this.checker.checksum(checksumBuffer);
        }
        return this.checker.getChecksum();
    }

    @Override
    public boolean write(long offset, ByteBuffer data, int chk) throws InterruptedException {
        return this.write(offset, data, chk, true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean write(long offset, ByteBuffer data, int chk, boolean writeChecksum, int latchedAddr) throws InterruptedException {
        assert (!this.m_closedForWrites);
        if (this.m_written) {
            log.error("Writing to CLEAN cache: " + this.hashCode());
            throw new IllegalStateException("Writing to CLEAN cache: " + this.hashCode());
        }
        if (data == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        WriteCacheCounters counters = this.counters.get();
        ByteBuffer tmp = this.acquire();
        try {
            int pos;
            int remaining = data.remaining();
            int datalen = remaining + (writeChecksum && this.useChecksum ? 4 : 0);
            int nwrite = datalen + (this.prefixWrites ? 16 : 0);
            if (nwrite > this.capacity) {
                throw new IllegalArgumentException("Would overrun buffer");
            }
            if (remaining == 0) {
                throw new IllegalArgumentException("Zero bytes remaining in buffer");
            }
            ByteBuffer byteBuffer = tmp;
            synchronized (byteBuffer) {
                int spos;
                block21: {
                    spos = tmp.position();
                    if (spos + nwrite <= this.capacity) break block21;
                    boolean bl = false;
                    return bl;
                }
                if (this.prefixWrites) {
                    tmp.putLong(offset);
                    tmp.putInt(datalen);
                    tmp.putInt(latchedAddr);
                    pos = spos + 16;
                } else {
                    pos = spos;
                }
                tmp.put(data);
                if (this.checker != null && !this.prefixWrites) {
                    ByteBuffer chkBuf = tmp.asReadOnlyBuffer();
                    chkBuf.position(spos);
                    chkBuf.limit(tmp.position());
                    this.checker.update(chkBuf);
                }
                if (writeChecksum && this.useChecksum) {
                    tmp.putInt(chk);
                    if (this.checker != null && !this.prefixWrites) {
                        this.checker.update(chk);
                    }
                }
                this.firstOffset.compareAndSet(-1L, offset);
                ++counters.naccept;
                counters.bytesAccepted += (long)nwrite;
                RecordMetadata md = new RecordMetadata(offset, pos, datalen, latchedAddr);
                if (this.recordMap.put(offset, md) != null) {
                    throw new AssertionError((Object)("Record exists for offset in cache: offset=" + offset));
                }
                if (this.orderedRecords != null) {
                    this.orderedRecords.add(md);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("offset=" + offset + ", pos=" + pos + ", nwrite=" + nwrite + ", writeChecksum=" + writeChecksum + ", useChecksum=" + this.useChecksum + ", nrecords=" + this.recordMap.size() + ", hashCode=" + this.hashCode());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(long offset, int nbytes) throws InterruptedException, ChecksumError {
        WriteCacheCounters counters = this.counters.get();
        ByteBuffer tmp = this.acquire();
        try {
            int chk;
            RecordMetadata md = (RecordMetadata)this.recordMap.get(offset);
            if (md == null) {
                counters.nmiss.increment();
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            int reclen = md.recordLength - (this.useChecksum ? 4 : 0);
            int pos = md.bufferOffset;
            ByteBuffer view = tmp.duplicate();
            view.limit(pos + reclen);
            view.position(pos);
            byte[] b = new byte[reclen];
            ByteBuffer dst = ByteBuffer.wrap(b);
            dst.put(view);
            dst.flip();
            if (this.useChecksum && !(this instanceof ReadCache) && (chk = tmp.getInt(pos + reclen)) != ChecksumUtility.threadChk.get().checksum(b, 0, reclen)) {
                throw new ChecksumError(this.checkdata());
            }
            counters.nhit.increment();
            if (log.isTraceEnabled()) {
                log.trace(this.show(dst, "read bytes"));
            }
            int nhits = ++md.hitCount;
            if (log.isTraceEnabled() && nhits > 2) {
                log.trace("Cache read ");
            }
            ByteBuffer byteBuffer = dst;
            return byteBuffer;
        }
        finally {
            this.release();
        }
    }

    private String show(ByteBuffer buf, String prefix) {
        StringBuffer str = new StringBuffer();
        int tpos = buf.position();
        if (tpos == 0) {
            tpos = buf.limit();
        }
        str.append(prefix + ", length: " + tpos + " : ");
        for (int tb = 0; tb < tpos && tb < 20; ++tb) {
            str.append(Integer.toString(buf.get(tb)) + ",");
        }
        return str.toString();
    }

    @Override
    public void flush(boolean force) throws IOException, InterruptedException {
        try {
            if (!this.flush(force, Long.MAX_VALUE, TimeUnit.NANOSECONDS)) {
                throw new RuntimeException();
            }
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flush(boolean force, long timeout, TimeUnit unit) throws IOException, TimeoutException, InterruptedException {
        long nanos;
        if (!this.m_closedForWrites) {
            this.closeForWrites();
        }
        long begin = System.nanoTime();
        long remaining = nanos = unit.toNanos(timeout);
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        if (!writeLock.tryLock(remaining, TimeUnit.NANOSECONDS)) {
            return false;
        }
        try {
            ByteBuffer tmp = this.buf.get().buffer();
            if (tmp == null) {
                throw new IllegalStateException();
            }
            int nbytes = tmp.position();
            if (log.isTraceEnabled()) {
                log.trace("nbytes=" + nbytes + ", firstOffset=" + this.getFirstOffset());
            }
            if (nbytes == 0) {
                boolean bl = true;
                return bl;
            }
            ByteBuffer view = tmp.duplicate();
            view.limit(nbytes);
            view.position(0);
            remaining = nanos - (System.nanoTime() - begin);
            boolean ret = this.writeOnChannel(view, this.getFirstOffset(), Collections.unmodifiableMap(this.recordMap), remaining);
            if (!ret) {
                throw new TimeoutException("Unable to flush WriteCache");
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkdata() throws IllegalStateException, InterruptedException {
        if (!this.useChecksum) {
            return "Unable to check since checksums are not enabled";
        }
        ByteBuffer tmp = this.acquire();
        try {
            int nerrors = 0;
            int nrecords = this.recordMap.size();
            for (Map.Entry ent : this.recordMap.entrySet()) {
                RecordMetadata md = (RecordMetadata)ent.getValue();
                int reclen = md.recordLength - 4;
                int pos = md.bufferOffset;
                int chk = tmp.getInt(pos + reclen);
                ByteBuffer view = tmp.duplicate();
                view.limit(pos + reclen);
                view.position(pos);
                byte[] b = new byte[reclen];
                ByteBuffer dst = ByteBuffer.wrap(b);
                dst.put(view);
                if (chk == ChecksumUtility.threadChk.get().checksum(b, 0, reclen)) continue;
                log.error("Bad data for address: " + ent.getKey());
                ++nerrors;
            }
            String string = "WriteCache checkdata - records: " + nrecords + ", errors: " + nerrors;
            return string;
        }
        finally {
            this.release();
        }
    }

    protected abstract boolean writeOnChannel(ByteBuffer var1, long var2, Map<Long, RecordMetadata> var4, long var5) throws InterruptedException, TimeoutException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws InterruptedException {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lockInterruptibly();
        try {
            ByteBuffer tmp = this.buf.get().buffer();
            if (tmp == null) {
                throw new IllegalStateException();
            }
            this._resetState(tmp);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws InterruptedException {
        block9: {
            ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
            writeLock.lockInterruptibly();
            try {
                IBufferAccess tmp = this.buf.get();
                if (tmp == null) {
                    return;
                }
                if (!this.buf.compareAndSet(tmp, null)) break block9;
                try {
                    this._resetState(tmp.buffer());
                }
                finally {
                    if (this.releaseBuffer) {
                        tmp.release();
                    }
                }
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _resetState(ByteBuffer tmp) {
        if (tmp == null) {
            throw new IllegalArgumentException();
        }
        if (!this.lock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (!this.recordMap.isEmpty()) {
            this.recordMap.clear();
        }
        if (this.orderedRecords != null) {
            ByteBuffer byteBuffer = tmp;
            synchronized (byteBuffer) {
                this.orderedRecords.clear();
            }
        }
        this.firstOffset.set(-1L);
        tmp.clear();
        if (this.checker != null) {
            this.checker.reset();
        }
        this.m_written = false;
        this.m_closedForWrites = false;
        this.m_removed = 0;
        this.m_referenceCount.set(0);
    }

    protected String getCompressorKey() {
        return null;
    }

    final HAPackage newHAPackage(UUID storeUUID, long quorumToken, long lastCommitCounter, long lastCommitTime, long sequence, int replicationFactor, ByteBuffer checksumBuffer) {
        ByteBuffer b = this.peek().duplicate();
        b.flip();
        String compressorKey = this.getCompressorKey();
        IRecordCompressor compressor = CompressorRegistry.getInstance().get(compressorKey);
        ByteBuffer send = compressor != null ? compressor.compress(b) : b;
        int chksum = this.getWholeBufferChecksum(checksumBuffer, send.duplicate(), b != send);
        HAWriteMessage msg = new HAWriteMessage(storeUUID, lastCommitCounter, lastCommitTime, sequence, send.limit(), chksum, this.prefixWrites ? StoreTypeEnum.RW : StoreTypeEnum.WORM, quorumToken, replicationFactor, this.fileExtent.get(), this.firstOffset.get(), compressorKey);
        if (log.isTraceEnabled()) {
            log.trace("Original buffer: " + b.limit() + ", final buffer: " + send.limit() + ", compressorKey: " + compressorKey + ", checksum: " + chksum);
        }
        return new HAPackage(msg, send);
    }

    void setCounters(WriteCacheCounters newVal) {
        if (newVal == null) {
            return;
        }
        this.counters.set(newVal);
    }

    public CounterSet getCounters() {
        return this.counters.get().getCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean clearAddrMap(long addr, int latchedAddr) throws IllegalStateException, InterruptedException {
        ByteBuffer tmp = this.acquire();
        try {
            if (this.m_closedForWrites) {
                boolean bl = false;
                return bl;
            }
            RecordMetadata removed = (RecordMetadata)this.recordMap.remove(addr);
            if (removed == null) {
                throw new AssertionError();
            }
            removed.deleted = true;
            if (!this.prefixWrites) {
                this.m_removed += removed.recordLength;
                boolean bl = true;
                return bl;
            }
            int addr_offset = removed.bufferOffset - 16;
            tmp.putLong(addr_offset, -removed.fileOffset);
            if (this.m_written && this.recordMap.isEmpty()) {
                this.m_written = false;
            }
            this.m_removed += removed.recordLength;
            boolean bl = true;
            return bl;
        }
        finally {
            this.release();
        }
    }

    protected void registerWriteStatus(long offset, int length, char action) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetWith(ConcurrentMap<Long, WriteCache> serviceRecordMap) throws InterruptedException {
        Iterator entries = this.recordMap.keySet().iterator();
        if (serviceRecordMap != null && entries.hasNext()) {
            this.transferLock.lock();
            try {
                if (log.isInfoEnabled()) {
                    log.info("resetting existing WriteCache: nrecords=" + this.recordMap.size() + ", hashCode=" + this.hashCode());
                }
                while (entries.hasNext()) {
                    Long fileOffset = (Long)entries.next();
                    boolean removed = serviceRecordMap.remove(fileOffset, this);
                    this.registerWriteStatus(fileOffset, 0, removed ? (char)'R' : 'L');
                }
            }
            finally {
                this.transferLock.unlock();
            }
        } else if (log.isInfoEnabled()) {
            log.info("clean WriteCache: hashCode=" + this.hashCode());
        }
        this.reset();
    }

    public void setRecordMap(Collection<RecordMetadata> map) {
        throw new RuntimeException("setRecordMap NotImplemented");
    }

    public long getLastOffset() {
        return this.lastOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRecordMapFromBuffer() throws InterruptedException {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lockInterruptibly();
        try {
            this.resetRecordMapFromBuffer(this.buf.get().buffer().duplicate(), this.recordMap);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyRawBuffer(ByteBuffer bin) throws InterruptedException {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lockInterruptibly();
        try {
            ByteBuffer buf = this.buf.get().buffer();
            buf.limit(bin.limit());
            buf.position(0);
            buf.put(bin);
            buf.position(0);
            this.resetRecordMapFromBuffer(buf, this.recordMap);
            buf.position(buf.limit());
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    static boolean transferTo(WriteCache src, WriteCache dst, ConcurrentMap<Long, WriteCache> serviceRecordMap, int threshold) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean prepareAddressMetadataForHA() throws IllegalStateException, InterruptedException {
        if (!this.prefixWrites) {
            throw new IllegalStateException();
        }
        if (this.orderedRecords == null) {
            throw new IllegalStateException();
        }
        ByteBuffer tmp = this.acquire();
        try {
            ByteBuffer byteBuffer = tmp;
            synchronized (byteBuffer) {
                block13: {
                    if (!this.orderedRecords.isEmpty()) break block13;
                    boolean bl = false;
                    return bl;
                }
                tmp.position(0);
                tmp.limit(tmp.capacity());
                for (RecordMetadata md : this.orderedRecords) {
                    if (md.deleted) {
                        tmp.putLong(-md.fileOffset);
                        tmp.putInt(-md.recordLength);
                    } else {
                        tmp.putLong(md.fileOffset);
                        tmp.putInt(-md.recordLength);
                    }
                    tmp.putInt(md.latchedAddr);
                }
                this.orderedRecords.clear();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.release();
        }
    }

    protected void resetRecordMapFromBuffer(ByteBuffer buf, Map<Long, RecordMetadata> recordMap) {
        recordMap.clear();
        recordMap.put(this.firstOffset.get(), new RecordMetadata(this.firstOffset.get(), 0, buf.limit(), 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeForWrites() throws IllegalStateException, InterruptedException {
        ReentrantReadWriteLock.WriteLock lock = this.lock.writeLock();
        lock.lockInterruptibly();
        try {
            if (this.m_closedForWrites) {
                throw new AssertionError();
            }
            this.m_closedForWrites = true;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isClosedForWrites() {
        return this.m_closedForWrites;
    }

    final int potentialCompaction() {
        int percentEmpty = this.m_removed * 100 / this.bytesWritten();
        assert (percentEmpty >= 0 && percentEmpty <= 100);
        return percentEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer allocate(int nbytes) throws IllegalStateException, InterruptedException {
        ByteBuffer byteBuffer;
        ByteBuffer tmp = this.acquire();
        try {
            ByteBuffer byteBuffer2 = tmp;
            synchronized (byteBuffer2) {
                if (this.remaining() > nbytes) {
                    int pos = tmp.position();
                    tmp.position(pos + nbytes);
                    ByteBuffer ret = tmp.duplicate();
                    ret.position(pos);
                    ret.limit(pos + nbytes);
                    ByteBuffer byteBuffer3 = ret;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.release();
                    return byteBuffer3;
                }
                byteBuffer = null;
            }
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
        this.release();
        return byteBuffer;
    }

    void commitToMap(long offset, int position, int nbytes) {
        RecordMetadata md = new RecordMetadata(offset, position, nbytes, -1);
        if (this.recordMap.put(offset, md) != null) {
            log.warn("Record already in cache");
        }
    }

    public int getReferenceCount() {
        return this.m_referenceCount.get();
    }

    public int incrementReferenceCount() {
        return this.m_referenceCount.incrementAndGet();
    }

    public int decrementReferenceCount() {
        return this.m_referenceCount.decrementAndGet();
    }

    public boolean contains(long offset) {
        return this.recordMap.containsKey(offset);
    }

    private static class ChecksumHelper
    extends ChecksumUtility {
        private final ByteBuffer chkbuf = ByteBuffer.allocate(4);

        private ChecksumHelper() {
        }

        public void update(int v) {
            this.chkbuf.clear();
            this.chkbuf.putInt(v);
            this.chk.update(this.chkbuf.array(), 0, 4);
        }

        @Override
        public int getChecksum() {
            return super.getChecksum();
        }

        @Override
        public void reset() {
            super.reset();
        }

        @Override
        public void update(ByteBuffer buf) {
            super.update(buf);
        }
    }

    public static class ReadCache
    extends WriteCache {
        public ReadCache(IBufferAccess buf) throws InterruptedException {
            super(buf, false, true, false, false, 0L);
        }

        @Override
        protected boolean writeOnChannel(ByteBuffer buf, long firstOffset, Map<Long, RecordMetadata> recordMap, long nanos) throws InterruptedException, TimeoutException, IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean clearAddrMap(long addr, int latchedAddr) throws IllegalStateException, InterruptedException {
            RecordMetadata removed = (RecordMetadata)this.recordMap.remove(addr);
            return removed != null;
        }

        @Override
        public boolean isClosedForWrites() {
            return true;
        }

        @Override
        public void closeForWrites() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean write(long offset, ByteBuffer data, int chk, boolean writeChecksum, int latchedAddr) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        ReadCache resetHitCounts() {
            Iterator mds = this.recordMap.values().iterator();
            while (mds.hasNext()) {
                ((RecordMetadata)mds.next()).hitCount = 0;
            }
            return this;
        }
    }

    public static class FileChannelScatteredWriteCache
    extends WriteCache {
        private final IReopenChannel<FileChannel> opener;
        private final BufferedWrite m_bufferedWrite;

        public FileChannelScatteredWriteCache(IBufferAccess buf, boolean useChecksum, boolean isHighlyAvailable, boolean bufferHasData, IReopenChannel<FileChannel> opener, long fileExtent, BufferedWrite bufferedWrite) throws InterruptedException {
            super(buf, true, useChecksum, isHighlyAvailable, bufferHasData, fileExtent);
            if (opener == null) {
                throw new IllegalArgumentException();
            }
            this.opener = opener;
            this.m_bufferedWrite = bufferedWrite;
        }

        @Override
        protected boolean writeOnChannel(ByteBuffer data, long firstOffsetIgnored, Map<Long, RecordMetadata> recordMap, long nanos) throws InterruptedException, IOException {
            long begin = System.nanoTime();
            int nbytes = data.remaining();
            if (this.m_written) {
                log.warn("DUPLICATE writeOnChannel for : " + this.hashCode());
            } else {
                this.m_written = true;
            }
            if (this.m_bufferedWrite != null) {
                this.m_bufferedWrite.reset();
            }
            int nwrites = 0;
            for (Map.Entry<Long, RecordMetadata> entry : recordMap.entrySet()) {
                RecordMetadata md = entry.getValue();
                ByteBuffer view = data.duplicate();
                int pos = md.bufferOffset;
                view.limit(pos + md.recordLength);
                view.position(pos);
                long offset = entry.getKey();
                nwrites = this.m_bufferedWrite == null ? (nwrites += FileChannelUtility.writeAll(this.opener, view, offset)) : (nwrites += this.m_bufferedWrite.write(offset, view, this.opener));
                this.registerWriteStatus(offset, md.recordLength, 'W');
            }
            if (this.m_bufferedWrite != null) {
                nwrites += this.m_bufferedWrite.flush(this.opener);
                if (log.isTraceEnabled()) {
                    log.trace(this.m_bufferedWrite.getStats(null, true));
                }
            }
            WriteCacheCounters counters = (WriteCacheCounters)this.counters.get();
            counters.nchannelWrite += (long)nwrites;
            counters.bytesWritten += (long)nbytes;
            counters.elapsedWriteNanos += System.nanoTime() - begin;
            if (log.isTraceEnabled()) {
                log.trace("WRITTEN ON CHANNEL");
            }
            return true;
        }

        @Override
        public void resetRecordMapFromBuffer(ByteBuffer buf, Map<Long, RecordMetadata> recordMap) {
            int recordLength;
            recordMap.clear();
            int limit = buf.limit();
            for (int pos = buf.position(); pos < limit; pos += 16 + (recordLength > 0 ? recordLength : 0)) {
                buf.position(pos);
                long fileOffset = buf.getLong();
                assert (fileOffset != 0L);
                recordLength = buf.getInt();
                assert (recordLength != 0);
                int latchedAddr = buf.getInt();
                if (fileOffset < 0L) {
                    if (recordMap.get(fileOffset) != null) {
                        throw new AssertionError();
                    }
                    this.addAddress(latchedAddr, recordLength);
                    if (recordLength <= 0) continue;
                    this.removeAddress(latchedAddr);
                    continue;
                }
                if (recordLength < 0) {
                    this.addAddress(latchedAddr, recordLength);
                    continue;
                }
                RecordMetadata md = new RecordMetadata(fileOffset, pos + 16, recordLength, latchedAddr);
                recordMap.put(fileOffset, md);
                this.addAddress(latchedAddr, recordLength);
            }
        }

        protected void addAddress(int latchedAddr, int size) {
        }

        protected void removeAddress(int latchedAddr) {
        }
    }

    public static class FileChannelWriteCache
    extends WriteCache {
        protected final long baseOffset;
        public final IReopenChannel<FileChannel> opener;

        public FileChannelWriteCache(long baseOffset, IBufferAccess buf, boolean useChecksum, boolean isHighlyAvailable, boolean bufferHasData, IReopenChannel<FileChannel> opener, long fileExtent) throws InterruptedException {
            super(buf, false, useChecksum, isHighlyAvailable, bufferHasData, fileExtent);
            if (baseOffset < 0L) {
                throw new IllegalArgumentException();
            }
            if (opener == null) {
                throw new IllegalArgumentException();
            }
            this.baseOffset = baseOffset;
            this.opener = opener;
        }

        @Override
        protected boolean writeOnChannel(ByteBuffer data, long firstOffset, Map<Long, RecordMetadata> recordMap, long nanos) throws InterruptedException, IOException {
            long begin = System.nanoTime();
            int nbytes = data.remaining();
            long pos = this.baseOffset + firstOffset;
            int nwrites = FileChannelUtility.writeAll(this.opener, data, pos);
            WriteCacheCounters counters = (WriteCacheCounters)this.counters.get();
            counters.nchannelWrite += (long)nwrites;
            counters.bytesWritten += (long)nbytes;
            counters.elapsedWriteNanos += System.nanoTime() - begin;
            return true;
        }
    }

    public static class HAPackage {
        private final IHAWriteMessage m_msg;
        private final ByteBuffer m_data;

        HAPackage(IHAWriteMessage msg, ByteBuffer data) {
            this.m_msg = msg;
            this.m_data = data;
        }

        public IHAWriteMessage getMessage() {
            return this.m_msg;
        }

        public ByteBuffer getData() {
            return this.m_data;
        }
    }

    public static class RecordMetadata {
        public final long fileOffset;
        public final int bufferOffset;
        public final int recordLength;
        public final int latchedAddr;
        private volatile boolean deleted;
        private volatile int hitCount;

        public RecordMetadata(long fileOffset, int bufferOffset, int recordLength, int latchedAddr) {
            this.fileOffset = fileOffset;
            this.bufferOffset = bufferOffset;
            this.recordLength = recordLength;
            this.latchedAddr = latchedAddr;
            this.deleted = false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{fileOffset=" + this.fileOffset + ",bufferOffset=" + this.bufferOffset + ",len=" + this.recordLength + ",delete=" + this.deleted + "}";
        }

        final int getHitCount() {
            return this.hitCount;
        }

        static /* synthetic */ int access$100(RecordMetadata x0) {
            return x0.hitCount;
        }
    }
}

